/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class QuickMenuAction
extends Action {
    private static final int CHAR_INDENT = 3;
    static /* synthetic */ Class class$0;

    public QuickMenuAction(String string) {
        this.setActionDefinitionId(string);
    }

    public void run() {
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Control control = display.getFocusControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillMenu((IMenuManager)menuManager);
        Menu menu = menuManager.createContextMenu((Control)control.getShell());
        Point point = this.computeMenuLocation(control, menu);
        if (point == null) {
            return;
        }
        menu.setLocation(point);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!menu.isDisposed()) {
            menu.dispose();
        }
    }

    protected abstract void fillMenu(IMenuManager var1);

    public String addShortcut(String string) {
        String string2 = this.getShortcutString();
        if (string == null || string2 == null) {
            return string;
        }
        return String.valueOf(string) + '\t' + string2;
    }

    private String getShortcutString() {
        IBindingService iBindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return iBindingService.getBestActiveBindingFormattedFor(this.getActionDefinitionId());
    }

    private Point computeMenuLocation(Control control, Menu menu) {
        StyledText styledText;
        Point point = control.getDisplay().getCursorLocation();
        Rectangle rectangle = null;
        Point point2 = null;
        if (control instanceof StyledText) {
            styledText = (StyledText)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation(styledText);
        } else if (control instanceof Tree) {
            styledText = (Tree)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation((Tree)styledText);
        } else if (control instanceof Table) {
            styledText = (Table)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation((Table)styledText);
        }
        if (point2 == null) {
            point2 = control.toControl(point);
        }
        if (rectangle != null && !rectangle.contains(point2)) {
            point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
        if (!(styledText = control.getShell().getClientArea()).contains(control.getShell().toControl(control.toDisplay(point2)))) {
            point2 = new Point(styledText.x + styledText.width / 2, styledText.y + styledText.height / 2);
        }
        return control.toDisplay(point2);
    }

    protected Point computeMenuLocation(StyledText styledText) {
        int n = styledText.getCaretOffset();
        Point point = styledText.getLocationAtOffset(n);
        point.y += styledText.getLineHeight(n);
        if (!styledText.getClientArea().contains(point)) {
            return null;
        }
        return point;
    }

    protected Point computeMenuLocation(Tree tree) {
        TreeItem[] treeItemArray = tree.getSelection();
        Rectangle rectangle = tree.getClientArea();
        switch (treeItemArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                Rectangle rectangle2 = treeItemArray[0].getBounds();
                Rectangle rectangle3 = rectangle.intersection(rectangle2);
                if (rectangle3 != null && rectangle3.height == rectangle2.height) {
                    return new Point(Math.max(0, rectangle2.x + this.getAvarageCharWith((Control)tree) * 3), rectangle2.y + rectangle2.height);
                }
                return null;
            }
        }
        Rectangle[] rectangleArray = new Rectangle[treeItemArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            rectangleArray[n] = treeItemArray[n].getBounds();
            ++n;
        }
        Point point = tree.getDisplay().getCursorLocation();
        Point point2 = this.findBestLocation(this.getIncludedPositions(rectangleArray, rectangle), tree.toControl(point));
        if (point2 != null) {
            point2.x += this.getAvarageCharWith((Control)tree) * 3;
        }
        return point2;
    }

    protected Point computeMenuLocation(Table table) {
        TableItem[] tableItemArray = table.getSelection();
        Rectangle rectangle = table.getClientArea();
        switch (tableItemArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                Rectangle rectangle2 = tableItemArray[0].getBounds(0);
                Rectangle rectangle3 = tableItemArray[0].getImageBounds(0);
                Rectangle rectangle4 = rectangle.intersection(rectangle2);
                if (rectangle4 != null && rectangle4.height == rectangle2.height) {
                    return new Point(Math.max(0, rectangle2.x + rectangle3.width + this.getAvarageCharWith((Control)table) * 3), rectangle2.y + rectangle2.height);
                }
                return null;
            }
        }
        Rectangle[] rectangleArray = new Rectangle[tableItemArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            rectangleArray[n] = tableItemArray[n].getBounds(0);
            ++n;
        }
        Rectangle rectangle5 = tableItemArray[0].getImageBounds(0);
        Point point = table.getDisplay().getCursorLocation();
        Point point2 = this.findBestLocation(this.getIncludedPositions(rectangleArray, rectangle), table.toControl(point));
        if (point2 != null) {
            point2.x = point2.x + rectangle5.width + this.getAvarageCharWith((Control)table) * 3;
        }
        return point2;
    }

    private Point[] getIncludedPositions(Rectangle[] rectangleArray, Rectangle rectangle) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle2 = rectangleArray[n];
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            if (rectangle3 != null && rectangle3.height == rectangle2.height) {
                arrayList.add(new Point(rectangle3.x, rectangle3.y + rectangle3.height));
            }
            ++n;
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    private Point findBestLocation(Point[] pointArray, Point point) {
        Point point2 = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < pointArray.length) {
            Point point3 = pointArray[n];
            int n2 = 0;
            int n3 = 0;
            n2 = point3.x > point.x ? point3.x - point.x : point.x - point3.x;
            double d2 = Math.sqrt(n2 * n2 + (n3 = point3.y > point.y ? point3.y - point.y : point.y - point3.y) * n3);
            if (d2 < d) {
                point2 = point3;
                d = d2;
            }
            ++n;
        }
        return point2;
    }

    private int getAvarageCharWith(Control control) {
        int n;
        block2: {
            GC gC = null;
            try {
                gC = new GC((Drawable)control);
                n = gC.getFontMetrics().getAverageCharWidth();
                Object var3_4 = null;
                if (gC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (gC == null) break block3;
                    gC.dispose();
                }
                throw throwable;
            }
            gC.dispose();
        }
        return n;
    }
}

