/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

class CallHierarchyTransferDropAdapter
extends SelectionTransferDropAdapter {
    private static final int OPERATION = 4;
    private CallHierarchyViewPart fCallHierarchyViewPart;

    public CallHierarchyTransferDropAdapter(CallHierarchyViewPart callHierarchyViewPart, StructuredViewer structuredViewer) {
        super(structuredViewer);
        this.setFullWidthMatchesItem(false);
        this.fCallHierarchyViewPart = callHierarchyViewPart;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        this.initializeSelection();
        if (object != null) {
            super.validateDrop(object, dropTargetEvent, n);
            return;
        }
        if (CallHierarchyTransferDropAdapter.getInputElement(this.getSelection()) != null) {
            dropTargetEvent.detail = 4;
        }
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        return true;
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
        if (object != null || dropTargetEvent.detail != 4) {
            super.drop(object, dropTargetEvent);
            return;
        }
        IMethod iMethod = CallHierarchyTransferDropAdapter.getInputElement(this.getSelection());
        this.fCallHierarchyViewPart.setMethod(iMethod);
    }

    private static IMethod getInputElement(ISelection iSelection) {
        Object object = SelectionUtil.getSingleElement(iSelection);
        if (object == null) {
            return null;
        }
        return CallHierarchyTransferDropAdapter.getCandidate(object);
    }

    public static IMethod getCandidate(Object object) {
        if (!(object instanceof IMethod)) {
            return null;
        }
        return (IMethod)object;
    }
}

