/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

class FiltersDialog
extends StatusDialog {
    private Label fNamesHelpText;
    private Button fFilterOnNames;
    private Text fNames;
    private Text fMaxCallDepth;

    protected FiltersDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CallHierarchyMessages.FiltersDialog_filter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.call_hierarchy_filters_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        this.createNamesArea(composite3);
        new Label(composite3, 0);
        this.createMaxCallDepthArea(composite3);
        this.updateUIFromFilter();
        return composite3;
    }

    private void createMaxCallDepthArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText(CallHierarchyMessages.FiltersDialog_maxCallDepth);
        this.fMaxCallDepth = new Text(composite2, 2052);
        this.fMaxCallDepth.setFont(composite2.getFont());
        this.fMaxCallDepth.setTextLimit(6);
        this.fMaxCallDepth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.fMaxCallDepth.setLayoutData((Object)gridData);
    }

    private void createNamesArea(Composite composite) {
        this.fFilterOnNames = this.createCheckbox(composite, CallHierarchyMessages.FiltersDialog_filterOnNames, true);
        this.fNames = new Text(composite, 2052);
        this.fNames.setFont(composite.getFont());
        this.fNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNames.setLayoutData((Object)gridData);
        this.fNamesHelpText = new Label(composite, 16384);
        this.fNamesHelpText.setFont(composite.getFont());
        this.fNamesHelpText.setText(CallHierarchyMessages.FiltersDialog_filterOnNamesSubCaption);
    }

    private Button createCheckbox(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 32);
        button.setFont(composite.getFont());
        if (bl) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(string);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersDialog.this.validateInput();
                FiltersDialog.this.updateEnabledState();
            }
        });
        return button;
    }

    private void updateEnabledState() {
        this.fNames.setEnabled(this.fFilterOnNames.getSelection());
        this.fNamesHelpText.setEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateFilterFromUI() {
        int n = Integer.parseInt(this.fMaxCallDepth.getText());
        CallHierarchyUI.getDefault().setMaxCallDepth(n);
        CallHierarchy.getDefault().setFilters(this.fNames.getText());
        CallHierarchy.getDefault().setFilterEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateUIFromFilter() {
        this.fMaxCallDepth.setText(String.valueOf(CallHierarchyUI.getDefault().getMaxCallDepth()));
        this.fNames.setText(CallHierarchy.getDefault().getFilters());
        this.fFilterOnNames.setSelection(CallHierarchy.getDefault().isFilterEnabled());
        this.updateEnabledState();
    }

    protected void okPressed() {
        if (!this.isMaxCallDepthValid() && this.fMaxCallDepth.forceFocus()) {
            this.fMaxCallDepth.setSelection(0, this.fMaxCallDepth.getCharCount());
            this.fMaxCallDepth.showSelection();
        }
        this.updateFilterFromUI();
        super.okPressed();
    }

    private boolean isMaxCallDepthValid() {
        String string = this.fMaxCallDepth.getText();
        if (string.length() == 0) {
            return false;
        }
        try {
            int n = Integer.parseInt(string);
            return n >= 1 && n <= 99;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void validateInput() {
        StatusInfo statusInfo = new StatusInfo();
        if (!this.isMaxCallDepthValid()) {
            statusInfo.setError(CallHierarchyMessages.FiltersDialog_messageMaxCallDepthInvalid);
        }
        this.updateStatus(statusInfo);
    }
}

