/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CopyCallHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationViewer;

class LocationCopyAction
extends Action {
    private final Clipboard fClipboard;
    private final IViewSite fViewSite;
    private final LocationViewer fLocationViewer;

    LocationCopyAction(IViewSite iViewSite, Clipboard clipboard, LocationViewer locationViewer) {
        this.fClipboard = clipboard;
        this.fViewSite = iViewSite;
        this.fLocationViewer = locationViewer;
        this.setText(CallHierarchyMessages.LocationCopyAction_copy);
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        locationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                LocationCopyAction.this.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
    }

    public void run() {
        block4: {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fLocationViewer.getSelection();
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                CallLocation callLocation = (CallLocation)iterator.next();
                stringBuffer.append(callLocation.getLineNumber()).append('\t').append(callLocation.getCallText());
                stringBuffer.append('\n');
            }
            iterator = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{CopyCallHierarchyAction.convertLineTerminators(stringBuffer.toString())}, new Transfer[]{iterator});
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.fViewSite.getShell(), (String)CallHierarchyMessages.CopyCallHierarchyAction_problem, (String)CallHierarchyMessages.CopyCallHierarchyAction_clipboard_busy)) break block4;
                this.run();
            }
        }
    }
}

