/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationCopyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationLabelProvider;

class LocationViewer
extends TableViewer {
    private final String[] columnHeaders = new String[]{CallHierarchyMessages.LocationViewer_ColumnIcon_header, CallHierarchyMessages.LocationViewer_ColumnLine_header, CallHierarchyMessages.LocationViewer_ColumnInfo_header};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(18, false, true), new ColumnWeightData(60), new ColumnWeightData(300)};

    LocationViewer(Composite composite) {
        super(LocationViewer.createTable(composite));
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LocationLabelProvider());
        this.setInput(new ArrayList());
        this.createColumns();
    }

    private static Table createTable(Composite composite) {
        return new Table(composite, 66306);
    }

    private void createColumns() {
        TableLayout tableLayout = new TableLayout();
        this.getTable().setLayout((Layout)tableLayout);
        this.getTable().setHeaderVisible(true);
        int n = 0;
        while (n < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[n]);
            TableColumn tableColumn = new TableColumn(this.getTable(), 0, n);
            tableColumn.setResizable(this.columnLayouts[n].resizable);
            tableColumn.setText(this.columnHeaders[n]);
            ++n;
        }
    }

    void initContextMenu(IMenuListener iMenuListener, String string, IWorkbenchPartSite iWorkbenchPartSite) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        iWorkbenchPartSite.registerContextMenu(string, menuManager, (ISelectionProvider)this);
    }

    LocationCopyAction initCopyAction(final IViewSite iViewSite, Clipboard clipboard) {
        final LocationCopyAction locationCopyAction = new LocationCopyAction(iViewSite, clipboard, this);
        this.getTable().addFocusListener(new FocusListener(){
            IAction fViewCopyHandler;

            public void focusLost(FocusEvent focusEvent) {
                if (this.fViewCopyHandler != null) {
                    IActionBars iActionBars = iViewSite.getActionBars();
                    iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.fViewCopyHandler);
                    iActionBars.updateActionBars();
                    this.fViewCopyHandler = null;
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                IActionBars iActionBars = iViewSite.getActionBars();
                this.fViewCopyHandler = iActionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
                iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)locationCopyAction);
                iActionBars.updateActionBars();
            }
        });
        return locationCopyAction;
    }

    void clearViewer() {
        this.setInput("");
    }
}

