/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_open_action_context");
    }

    public OpenCallHierarchyAction(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this(iWorkbenchSite);
        this.setSpecialSelectionProvider(iSelectionProvider);
    }

    public OpenCallHierarchyAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.isEnabled(iStructuredSelection));
    }

    private boolean isEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IJavaElement)) {
            return false;
        }
        switch (((IJavaElement)object).getElementType()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        try {
            IJavaElement iJavaElement2;
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (iJavaElementArray == null) {
                return;
            }
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(iJavaElementArray.length);
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement[] iJavaElementArray2 = CallHierarchyUI.getCandidates(iJavaElementArray[n]);
                if (iJavaElementArray2 != null) {
                    arrayList.addAll(Arrays.asList(iJavaElementArray2));
                }
                ++n;
            }
            if (arrayList.isEmpty() && (iJavaElement2 = this.getEnclosingMethod(iJavaElement, iTextSelection)) != null) {
                arrayList.add(iJavaElement2);
            }
            this.run(arrayList.toArray(new IJavaElement[arrayList.size()]));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), OpenCallHierarchyAction.getErrorDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IJavaElement getEnclosingMethod(IJavaElement iJavaElement, ITextSelection iTextSelection) {
        IJavaElement iJavaElement2 = null;
        try {
            switch (iJavaElement.getElementType()) {
                case 6: {
                    IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
                    if (iClassFile == null) break;
                    iJavaElement2 = iClassFile.getElementAt(iTextSelection.getOffset());
                    break;
                }
                case 5: {
                    ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                    if (iCompilationUnit == null) break;
                    iJavaElement2 = iCompilationUnit.getElementAt(iTextSelection.getOffset());
                }
            }
            if (iJavaElement2 != null && iJavaElement2.getElementType() == 9) {
                return iJavaElement2;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IJavaElement)) {
            IStatus iStatus = OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_java_element);
            this.openErrorDialog(iStatus);
            return;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        ArrayList arrayList = new ArrayList(1);
        IStatus iStatus = OpenCallHierarchyAction.compileCandidates(arrayList, iJavaElement);
        if (iStatus.isOK()) {
            this.run(arrayList.toArray(new IJavaElement[arrayList.size()]));
        } else {
            this.openErrorDialog(iStatus);
        }
    }

    private int openErrorDialog(IStatus iStatus) {
        String string = CallHierarchyMessages.OpenCallHierarchyAction_messages_title;
        String string2 = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)string2, (String)string, (IStatus)iStatus);
    }

    private static String getErrorDialogTitle() {
        return CallHierarchyMessages.OpenCallHierarchyAction_dialog_title;
    }

    public void run(IJavaElement[] iJavaElementArray) {
        if (iJavaElementArray.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open(iJavaElementArray, this.getSite().getWorkbenchWindow());
    }

    private static IStatus compileCandidates(List list, IJavaElement iJavaElement) {
        Status status = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        switch (iJavaElement.getElementType()) {
            case 9: {
                list.add(iJavaElement);
                return status;
            }
        }
        return OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String string) {
        return new Status(1, JavaPlugin.getPluginId(), 10001, string, null);
    }
}

