/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.ResizableDialog;

class CompareDialog
extends ResizableDialog {
    private CompareViewerSwitchingPane fContentPane;
    private CompareConfiguration fCompareConfiguration = new CompareConfiguration();
    private ICompareInput fInput;

    CompareDialog(Shell shell, ResourceBundle resourceBundle) {
        super(shell, resourceBundle);
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setRightEditable(false);
    }

    void compare(ICompareInput iCompareInput) {
        this.fInput = iCompareInput;
        this.fCompareConfiguration.setLeftLabel(this.fInput.getLeft().getName());
        this.fCompareConfiguration.setLeftImage(this.fInput.getLeft().getImage());
        this.fCompareConfiguration.setRightLabel(this.fInput.getRight().getName());
        this.fCompareConfiguration.setRightImage(this.fInput.getRight().getImage());
        if (this.fContentPane != null) {
            this.fContentPane.setInput((Object)this.fInput);
        }
        this.open();
    }

    protected synchronized Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.getShell().setText(JavaCompareUtilities.getString(this.fBundle, "title"));
        this.fContentPane = new ViewerSwitchingPane(composite2, 0x800800);
        this.fContentPane.setLayoutData((Object)new GridData(1808));
        if (this.fInput != null) {
            this.fContentPane.setInput((Object)this.fInput);
        }
        CompareDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        String string = JavaCompareUtilities.getString(this.fBundle, "buttonLabel", IDialogConstants.OK_LABEL);
        this.createButton(composite, 1, string, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.compare_dialog_context");
    }

    class ViewerSwitchingPane
    extends CompareViewerSwitchingPane {
        ViewerSwitchingPane(Composite composite, int n) {
            super(composite, n, false);
        }

        protected Viewer getViewer(Viewer viewer, Object object) {
            if (object instanceof ICompareInput) {
                return CompareUI.findContentViewer((Viewer)viewer, (ICompareInput)((ICompareInput)object), (Composite)this, (CompareConfiguration)CompareDialog.this.fCompareConfiguration);
            }
            return null;
        }

        public void setImage(Image image) {
        }
    }
}

