/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.History;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.OwnerDrawSupport;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoImageProvider;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class FilteredTypesSelectionDialog
extends FilteredItemsSelectionDialog
implements ITypeSelectionComponent {
    private static final boolean BUG_184693 = true;
    private static final String DIALOG_SETTINGS = "org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog";
    private static final String SHOW_CONTAINER_FOR_DUPLICATES = "ShowContainerForDuplicates";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private final TypeItemLabelProvider fTypeInfoLabelProvider;
    private String fTitle;
    private ShowContainerForDuplicatesAction fShowContainerForDuplicatesAction;
    private IJavaSearchScope fSearchScope;
    private boolean fAllowScopeSwitching;
    private final int fElementKinds;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeSelectionExtension fExtension;
    private ISelectionStatusValidator fValidator;
    private final TypeInfoUtil fTypeInfoUtil;
    private static boolean fgFirstTime = true;
    private final TypeItemsComparator fTypeItemsComparator;
    private int fTypeFilterVersion = 0;

    public FilteredTypesSelectionDialog(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n) {
        this(shell, bl, iRunnableContext, iJavaSearchScope, n, null);
    }

    public FilteredTypesSelectionDialog(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n, TypeSelectionExtension typeSelectionExtension) {
        super(shell, bl);
        this.setSelectionHistory(new TypeSelectionHistory());
        if (iJavaSearchScope == null) {
            this.fAllowScopeSwitching = true;
            iJavaSearchScope = SearchEngine.createWorkspaceScope();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.type_selection_dialog2_context");
        this.fElementKinds = n;
        this.fExtension = typeSelectionExtension;
        this.fFilterExtension = typeSelectionExtension == null ? null : typeSelectionExtension.getFilterExtension();
        this.fSearchScope = iJavaSearchScope;
        if (typeSelectionExtension != null) {
            this.fValidator = typeSelectionExtension.getSelectionValidator();
        }
        this.fTypeInfoUtil = new TypeInfoUtil(typeSelectionExtension != null ? typeSelectionExtension.getImageProvider() : null);
        this.fTypeInfoLabelProvider = new TypeItemLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.fTypeInfoLabelProvider);
        this.setListSelectionLabelDecorator(this.fTypeInfoLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new TypeItemDetailsLabelProvider(this.fTypeInfoUtil));
        this.fTypeItemsComparator = new TypeItemsComparator();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.fTitle = string;
    }

    private void setSubtitle(String string) {
        if (string == null || string.length() == 0) {
            this.getShell().setText(this.fTitle);
        } else {
            this.getShell().setText(Messages.format(JavaUIMessages.FilteredTypeSelectionDialog_titleFormat, new String[]{this.fTitle, string}));
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (iDialogSettings == null) {
            iDialogSettings = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return iDialogSettings;
    }

    protected void storeDialog(IDialogSettings iDialogSettings) {
        super.storeDialog(iDialogSettings);
        if (this.fFilterActionGroup != null) {
            XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)xMLMemento);
            this.fFilterActionGroup.dispose();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLMemento.save((Writer)stringWriter);
                iDialogSettings.put(WORKINGS_SET_SETTINGS, stringWriter.getBuffer().toString());
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
        }
    }

    protected void restoreDialog(IDialogSettings iDialogSettings) {
        super.restoreDialog(iDialogSettings);
        this.fTypeInfoLabelProvider.setContainerInfo(true);
        if (this.fAllowScopeSwitching) {
            IWorkingSet iWorkingSet;
            String string = iDialogSettings.get(WORKINGS_SET_SETTINGS);
            if (string != null) {
                try {
                    iWorkingSet = XMLMemento.createReadRoot((Reader)new StringReader(string));
                    this.fFilterActionGroup.restoreState((IMemento)iWorkingSet);
                }
                catch (WorkbenchException workbenchException) {
                    JavaPlugin.log(workbenchException);
                }
            }
            if ((iWorkingSet = this.fFilterActionGroup.getWorkingSet()) == null || iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
                this.setSearchScope(SearchEngine.createWorkspaceScope());
                this.setSubtitle(null);
            } else {
                this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(iWorkingSet, true));
                this.setSubtitle(iWorkingSet.getLabel());
            }
        }
    }

    protected void fillViewMenu(IMenuManager iMenuManager) {
        super.fillViewMenu(iMenuManager);
        if (this.fAllowScopeSwitching) {
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), JavaPlugin.getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
                    if (iWorkingSet == null || iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
                        FilteredTypesSelectionDialog.this.setSearchScope(SearchEngine.createWorkspaceScope());
                        FilteredTypesSelectionDialog.this.setSubtitle(null);
                    } else {
                        FilteredTypesSelectionDialog.this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(iWorkingSet, true));
                        FilteredTypesSelectionDialog.this.setSubtitle(iWorkingSet.getLabel());
                    }
                    FilteredTypesSelectionDialog.this.applyFilter();
                }
            });
            this.fFilterActionGroup.fillViewMenu(iMenuManager);
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)new TypeFiltersPreferencesAction());
    }

    protected Control createExtendedContentArea(Composite composite) {
        Control control = null;
        if (this.fExtension != null) {
            control = this.fExtension.createContentArea(composite);
            if (control != null) {
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                control.setLayoutData((Object)gridData);
            }
            this.fExtension.initialize(this);
        }
        return control;
    }

    protected void setResult(List list) {
        ArrayList<IType> arrayList = new ArrayList<IType>();
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof TypeNameMatch) {
                IType iType = ((TypeNameMatch)list.get(n)).getType();
                if (iType.exists()) {
                    arrayList.add(iType);
                } else {
                    TypeNameMatch typeNameMatch = (TypeNameMatch)list.get(n);
                    IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
                    String string = JavaElementLabels.getElementLabel((IJavaElement)iPackageFragmentRoot, 0x20000000000L);
                    String string2 = Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_dialogMessage, new String[]{typeNameMatch.getFullyQualifiedName(), string});
                    MessageDialog.openError((Shell)this.getShell(), (String)this.fTitle, (String)string2);
                    this.getSelectionHistory().remove((Object)typeNameMatch);
                }
            }
            ++n;
        }
        super.setResult(arrayList);
    }

    public void create() {
        super.create();
        Control control = this.getPatternControl();
        if (control instanceof Text) {
            TextFieldNavigationHandler.install((Text)control);
        }
    }

    public int open() {
        String string;
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow;
        if (this.getInitialPattern() == null && (iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow()) != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof ITextSelection && (string = ((ITextSelection)iSelection).getText()) != null && (string = string.trim()).length() > 0 && JavaConventions.validateJavaTypeName((String)string, (String)"1.3", (String)"1.3").isOK()) {
            this.setInitialPattern(string, 2);
        }
        return super.open();
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TypeItemsFilter(this.fSearchScope, this.fElementKinds, this.fFilterExtension);
    }

    protected Control createContents(Composite composite) {
        Table table;
        Control control = super.createContents(composite);
        if (ColoredViewersManager.showColoredLabels() && control instanceof Composite && (table = this.findTableControl((Composite)control)) != null) {
            this.installOwnerDraw(table);
        }
        return control;
    }

    private void installOwnerDraw(Table table) {
        new OwnerDrawSupport((Control)table){

            public ColoredString getColoredLabel(Item item) {
                String string = item.getText();
                ColoredString coloredString = new ColoredString(string);
                int n = string.indexOf(45);
                if (n != -1) {
                    coloredString.colorize(n, coloredString.length() - n, ColoredJavaElementLabels.QUALIFIER_STYLE);
                }
                return coloredString;
            }

            public Color getColor(String string, Display display) {
                return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(string);
            }
        };
    }

    private Table findTableControl(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Table table;
            Control control = controlArray[n];
            if (control instanceof Table) {
                return (Table)control;
            }
            if (control instanceof Composite && (table = this.findTableControl((Composite)control)) != null) {
                return table;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor iProgressMonitor) throws CoreException {
        TypeItemsFilter typeItemsFilter = (TypeItemsFilter)itemsFilter;
        TypeSearchRequestor typeSearchRequestor = new TypeSearchRequestor(abstractContentProvider, typeItemsFilter);
        SearchEngine searchEngine = new SearchEngine(null);
        String string = typeItemsFilter.getPackagePattern();
        iProgressMonitor.setTaskName(JavaUIMessages.FilteredTypesSelectionDialog_searchJob_taskName);
        String string2 = itemsFilter.getPattern();
        int n = typeItemsFilter.getMatchRule();
        if (n == 128) {
            char c = string2.charAt(string2.length() - 1);
            if (c == '<' || c == ' ') {
                string2 = string2.substring(0, string2.length() - 1);
            } else {
                typeItemsFilter.setMatchEverythingMode(true);
            }
        } else {
            typeItemsFilter.setMatchEverythingMode(true);
        }
        try {
            searchEngine.searchAllTypeNames(string == null ? null : string.toCharArray(), typeItemsFilter.getPackageFlags(), string2.toCharArray(), n, typeItemsFilter.getElementKind(), typeItemsFilter.getSearchScope(), (TypeNameMatchRequestor)typeSearchRequestor, 3, iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            typeItemsFilter.setMatchEverythingMode(false);
            throw throwable;
        }
        {
            Object var10_12 = null;
            typeItemsFilter.setMatchEverythingMode(false);
            return;
        }
    }

    protected Comparator getItemsComparator() {
        return this.fTypeItemsComparator;
    }

    public String getElementName(Object object) {
        TypeNameMatch typeNameMatch = (TypeNameMatch)object;
        return this.fTypeInfoUtil.getText(typeNameMatch);
    }

    protected IStatus validateItem(Object object) {
        if (object == null) {
            return new Status(4, JavaPlugin.getPluginId(), 4, "", null);
        }
        if (this.fValidator != null) {
            IType iType = ((TypeNameMatch)object).getType();
            if (!iType.exists()) {
                return new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_error_type_doesnot_exist, ((TypeNameMatch)object).getFullyQualifiedName()), null);
            }
            Object[] objectArray = new Object[]{iType};
            return this.fValidator.validate(objectArray);
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private void setSearchScope(IJavaSearchScope iJavaSearchScope) {
        this.fSearchScope = iJavaSearchScope;
    }

    public void reloadCache(boolean bl, IProgressMonitor iProgressMonitor) {
        IProgressMonitor iProgressMonitor2;
        if (ConsistencyRunnable.needsExecution()) {
            iProgressMonitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 10);
            try {
                ConsistencyRunnable consistencyRunnable = new ConsistencyRunnable();
                consistencyRunnable.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, JavaUIMessages.TypeSelectionDialog_error3Title, JavaUIMessages.TypeSelectionDialog_error3Message);
                this.close();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.close();
                return;
            }
            iProgressMonitor2 = new SubProgressMonitor(iProgressMonitor, 9);
        } else {
            iProgressMonitor2 = iProgressMonitor;
        }
        super.reloadCache(bl, iProgressMonitor2);
        iProgressMonitor.done();
    }

    public void triggerSearch() {
        ++this.fTypeFilterVersion;
        this.applyFilter();
    }

    private static class ConsistencyRunnable
    implements IRunnableWithProgress {
        private ConsistencyRunnable() {
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            Object object;
            if (fgFirstTime) {
                object = Job.getJobManager();
                object.join((Object)"org.eclipse.wst.jsdt.ui", iProgressMonitor);
            }
            object = OpenTypeHistory.getInstance();
            if (fgFirstTime || ((History)object).isEmpty()) {
                if (((OpenTypeHistory)object).needConsistencyCheck()) {
                    iProgressMonitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 90));
                    ((OpenTypeHistory)object).checkConsistency((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                } else {
                    this.refreshSearchIndices(iProgressMonitor);
                }
                iProgressMonitor.done();
                fgFirstTime = false;
            } else {
                ((OpenTypeHistory)object).checkConsistency(iProgressMonitor);
            }
        }

        public static boolean needsExecution() {
            OpenTypeHistory openTypeHistory = OpenTypeHistory.getInstance();
            return fgFirstTime || openTypeHistory.isEmpty() || openTypeHistory.needConsistencyCheck();
        }

        private void refreshSearchIndices(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
            try {
                new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                    final /* synthetic */ ConsistencyRunnable this$1;
                    {
                        this.this$1 = consistencyRunnable;
                    }
                }, 3, iProgressMonitor);
            }
            catch (JavaModelException javaModelException) {
                throw new InvocationTargetException(javaModelException);
            }
        }
    }

    private class ShowContainerForDuplicatesAction
    extends Action {
        public ShowContainerForDuplicatesAction() {
            super(JavaUIMessages.FilteredTypeSelectionDialog_showContainerForDuplicatesAction, 2);
        }

        public void run() {
            FilteredTypesSelectionDialog.this.fTypeInfoLabelProvider.setContainerInfo(this.isChecked());
        }
    }

    private class TypeFiltersPreferencesAction
    extends Action {
        public TypeFiltersPreferencesAction() {
            super(JavaUIMessages.FilteredTypesSelectionDialog_TypeFiltersPreferencesAction_label);
        }

        public void run() {
            String string = "org.eclipse.wst.jsdt.ui.preferences.TypeFilterPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)FilteredTypesSelectionDialog.this.getShell(), (String)string, (String[])new String[]{string}, null).open();
            FilteredTypesSelectionDialog.this.triggerSearch();
        }
    }

    private static class TypeInfoUtil {
        private final ITypeInfoImageProvider fProviderExtension;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private final Map fLib2Name = new HashMap();
        private final String[] fInstallLocations;
        private final String[] fVMNames;
        private boolean fFullyQualifyDuplicates;

        public TypeInfoUtil(ITypeInfoImageProvider iTypeInfoImageProvider) {
            this.fProviderExtension = iTypeInfoImageProvider;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = 0;
            while (n < iVMInstallTypeArray.length) {
                this.processVMInstallType(iVMInstallTypeArray[n], arrayList, arrayList2);
                ++n;
            }
            this.fInstallLocations = arrayList.toArray(new String[arrayList.size()]);
            this.fVMNames = arrayList2.toArray(new String[arrayList2.size()]);
        }

        public void setFullyQualifyDuplicates(boolean bl) {
            this.fFullyQualifyDuplicates = bl;
        }

        private void processVMInstallType(IVMInstallType iVMInstallType, List list, List list2) {
            if (iVMInstallType != null) {
                IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
                boolean bl = "macosx".equals(Platform.getOS());
                int n = 0;
                while (n < iVMInstallArray.length) {
                    String string = this.getFormattedLabel(iVMInstallArray[n].getName());
                    LibraryLocation[] libraryLocationArray = iVMInstallArray[n].getLibraryLocations();
                    if (libraryLocationArray != null) {
                        this.processLibraryLocation(libraryLocationArray, string);
                    } else {
                        String string2 = iVMInstallArray[n].getInstallLocation().getAbsolutePath();
                        if (bl && string2.endsWith("/Home")) {
                            string2 = string2.substring(0, string2.length() - "/Home".length() + 1);
                        }
                        list.add(string2);
                        list2.add(string);
                    }
                    ++n;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libraryLocationArray, String string) {
            int n = 0;
            while (n < libraryLocationArray.length) {
                LibraryLocation libraryLocation = libraryLocationArray[n];
                this.fLib2Name.put(libraryLocation.getSystemLibraryPath().toOSString(), string);
                ++n;
            }
        }

        private String getFormattedLabel(String string) {
            return Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, string);
        }

        public String getText(Object object) {
            return ((TypeNameMatch)object).getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(typeNameMatch.getSimpleTypeName());
            String string = typeNameMatch.getTypeContainerName();
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            if (string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(JavaUIMessages.FilteredTypesSelectionDialog_default_package);
            }
            return stringBuffer.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(typeNameMatch.getSimpleTypeName());
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                stringBuffer.append(string);
            }
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            stringBuffer.append(this.getContainerName(typeNameMatch));
            return stringBuffer.toString();
        }

        public String getText(TypeNameMatch typeNameMatch, TypeNameMatch typeNameMatch2, TypeNameMatch typeNameMatch3) {
            String string;
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            String string3 = typeNameMatch2.getSimpleTypeName();
            stringBuffer.append(string3);
            String string4 = this.getTypeContainerName(typeNameMatch2);
            if (typeNameMatch != null) {
                string2 = typeNameMatch.getSimpleTypeName();
                string = this.getTypeContainerName(typeNameMatch);
                if (string4.equals(string)) {
                    if (string3.equals(string2)) {
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(string4);
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(this.getContainerName(typeNameMatch2));
                        return stringBuffer.toString();
                    }
                } else if (string3.equals(string2)) {
                    n = 1;
                }
            }
            if (typeNameMatch3 != null) {
                string2 = typeNameMatch3.getSimpleTypeName();
                string = this.getTypeContainerName(typeNameMatch3);
                if (string4.equals(string)) {
                    if (string3.equals(string2)) {
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(string4);
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(this.getContainerName(typeNameMatch2));
                        return stringBuffer.toString();
                    }
                } else if (string3.equals(string2)) {
                    n = 1;
                }
            }
            if (n > 0) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                stringBuffer.append(string4);
                if (this.fFullyQualifyDuplicates) {
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                    stringBuffer.append(this.getContainerName(typeNameMatch2));
                }
            }
            return stringBuffer.toString();
        }

        public String getQualificationText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            }
            stringBuffer.append(this.getContainerName(typeNameMatch));
            return stringBuffer.toString();
        }

        private boolean isInnerType(TypeNameMatch typeNameMatch) {
            return typeNameMatch.getTypeQualifiedName().indexOf(46) != -1;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(typeNameMatch);
                ImageDescriptor imageDescriptor = this.fProviderExtension.getImageDescriptor(this.fAdapter);
                if (imageDescriptor != null) {
                    return imageDescriptor;
                }
            }
            return JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(typeNameMatch), false, typeNameMatch.getModifiers(), false);
        }

        private String getTypeContainerName(TypeNameMatch typeNameMatch) {
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                return string;
            }
            return JavaUIMessages.FilteredTypesSelectionDialog_default_package;
        }

        private String getContainerName(TypeNameMatch typeNameMatch) {
            CharSequence charSequence;
            IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
            if (iPackageFragmentRoot.isExternal()) {
                charSequence = iPackageFragmentRoot.getPath().toOSString();
                int n = 0;
                while (n < this.fInstallLocations.length) {
                    if (((String)charSequence).startsWith(this.fInstallLocations[n])) {
                        return this.fVMNames[n];
                    }
                    ++n;
                }
                String string = (String)this.fLib2Name.get(charSequence);
                if (string != null) {
                    return string;
                }
            }
            charSequence = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(iPackageFragmentRoot, 0x30000000000L, (StringBuffer)charSequence);
            return ((StringBuffer)charSequence).toString();
        }
    }

    private static class TypeItemDetailsLabelProvider
    extends LabelProvider {
        private final TypeNameMatchLabelProvider fLabelProvider = new TypeNameMatchLabelProvider(40);
        private final TypeInfoUtil fTypeInfoUtil;

        public TypeItemDetailsLabelProvider(TypeInfoUtil typeInfoUtil) {
            this.fTypeInfoUtil = typeInfoUtil;
        }

        public Image getImage(Object object) {
            if (object instanceof TypeNameMatch) {
                return this.fLabelProvider.getImage(object);
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            if (object instanceof TypeNameMatch) {
                return this.fTypeInfoUtil.getQualificationText((TypeNameMatch)object);
            }
            return super.getText(object);
        }
    }

    private class TypeItemLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private boolean fContainerInfo;

        public void setContainerInfo(boolean bl) {
            this.fContainerInfo = bl;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        private boolean isInnerType(TypeNameMatch typeNameMatch) {
            return typeNameMatch.getTypeQualifiedName().indexOf(46) != -1;
        }

        public Image getImage(Object object) {
            if (!(object instanceof TypeNameMatch)) {
                return super.getImage(object);
            }
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            ImageDescriptor imageDescriptor = JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(typeNameMatch), false, typeNameMatch.getModifiers(), false);
            return JavaPlugin.getImageDescriptorRegistry().get(imageDescriptor);
        }

        public String getText(Object object) {
            if (!(object instanceof TypeNameMatch)) {
                return super.getText(object);
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(object)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)object);
            }
            if (!this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(object)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)object);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getText(object);
        }

        public Image decorateImage(Image image, Object object) {
            return null;
        }

        public String decorateText(String string, Object object) {
            if (!(object instanceof TypeNameMatch)) {
                return null;
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(object)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)object);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)object);
        }
    }

    private static class TypeItemsComparator
    implements Comparator {
        private final Map fLib2Name = new HashMap();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeItemsComparator() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = 0;
            while (n < iVMInstallTypeArray.length) {
                this.processVMInstallType(iVMInstallTypeArray[n], arrayList, arrayList2);
                ++n;
            }
            this.fInstallLocations = arrayList.toArray(new String[arrayList.size()]);
            this.fVMNames = arrayList2.toArray(new String[arrayList2.size()]);
        }

        private void processVMInstallType(IVMInstallType iVMInstallType, List list, List list2) {
            if (iVMInstallType != null) {
                IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
                boolean bl = "macosx".equals(Platform.getOS());
                int n = 0;
                while (n < iVMInstallArray.length) {
                    String string = this.getFormattedLabel(iVMInstallArray[n].getName());
                    LibraryLocation[] libraryLocationArray = iVMInstallArray[n].getLibraryLocations();
                    if (libraryLocationArray != null) {
                        this.processLibraryLocation(libraryLocationArray, string);
                    } else {
                        String string2 = iVMInstallArray[n].getInstallLocation().getAbsolutePath();
                        if (bl && string2.endsWith("/Home")) {
                            string2 = string2.substring(0, string2.length() - "/Home".length() + 1);
                        }
                        list.add(string2);
                        list2.add(string);
                    }
                    ++n;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libraryLocationArray, String string) {
            int n = 0;
            while (n < libraryLocationArray.length) {
                LibraryLocation libraryLocation = libraryLocationArray[n];
                this.fLib2Name.put(libraryLocation.getSystemLibraryPath().toString(), string);
                ++n;
            }
        }

        private String getFormattedLabel(String string) {
            return MessageFormat.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, string);
        }

        public int compare(Object object, Object object2) {
            int n;
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            TypeNameMatch typeNameMatch2 = (TypeNameMatch)object2;
            int n2 = this.compareName(typeNameMatch.getSimpleTypeName(), typeNameMatch2.getSimpleTypeName());
            if (n2 != 0) {
                return n2;
            }
            n2 = this.compareTypeContainerName(typeNameMatch.getTypeContainerName(), typeNameMatch2.getTypeContainerName());
            if (n2 != 0) {
                return n2;
            }
            int n3 = this.getElementTypeCategory(typeNameMatch);
            if (n3 < (n = this.getElementTypeCategory(typeNameMatch2))) {
                return -1;
            }
            if (n3 > n) {
                return 1;
            }
            return this.compareContainerName(typeNameMatch, typeNameMatch2);
        }

        private int compareName(String string, String string2) {
            int n = string.compareToIgnoreCase(string2);
            if (n != 0 || string2.length() == 0) {
                return n;
            }
            if (Strings.isLowerCase(string.charAt(0)) && !Strings.isLowerCase(string2.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(string2.charAt(0)) && !Strings.isLowerCase(string.charAt(0))) {
                return -1;
            }
            return string.compareTo(string2);
        }

        private int compareTypeContainerName(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            if (n == 0 && n2 > 0) {
                return -1;
            }
            if (n == 0 && n2 == 0) {
                return 0;
            }
            if (n > 0 && n2 == 0) {
                return 1;
            }
            return this.compareName(string, string2);
        }

        private int compareContainerName(TypeNameMatch typeNameMatch, TypeNameMatch typeNameMatch2) {
            return this.getContainerName(typeNameMatch).compareTo(this.getContainerName(typeNameMatch2));
        }

        private String getContainerName(TypeNameMatch typeNameMatch) {
            CharSequence charSequence;
            IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
            if (iPackageFragmentRoot.isExternal()) {
                charSequence = iPackageFragmentRoot.getPath().toOSString();
                int n = 0;
                while (n < this.fInstallLocations.length) {
                    if (((String)charSequence).startsWith(this.fInstallLocations[n])) {
                        return this.fVMNames[n];
                    }
                    ++n;
                }
                String string = (String)this.fLib2Name.get(charSequence);
                if (string != null) {
                    return string;
                }
            }
            charSequence = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(iPackageFragmentRoot, 0x30000000000L, (StringBuffer)charSequence);
            return ((StringBuffer)charSequence).toString();
        }

        private int getElementTypeCategory(TypeNameMatch typeNameMatch) {
            try {
                if (typeNameMatch.getPackageFragmentRoot().getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return 1;
        }
    }

    private class TypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private static final int TYPE_MODIFIERS = 25088;
        private final IJavaSearchScope fScope;
        private final boolean fIsWorkspaceScope;
        private final int fElemKind;
        private final ITypeInfoFilterExtension fFilterExt;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private SearchPattern fPackageMatcher;
        private boolean fMatchEverything = false;
        private final int fMyTypeFilterVersion;

        public TypeItemsFilter(IJavaSearchScope iJavaSearchScope, int n, ITypeInfoFilterExtension iTypeInfoFilterExtension) {
            super((FilteredItemsSelectionDialog)FilteredTypesSelectionDialog.this, (SearchPattern)new TypeSearchPattern());
            this.fMyTypeFilterVersion = FilteredTypesSelectionDialog.this.fTypeFilterVersion;
            this.fScope = iJavaSearchScope;
            this.fIsWorkspaceScope = iJavaSearchScope == null ? false : iJavaSearchScope.equals(SearchEngine.createWorkspaceScope());
            this.fElemKind = n;
            this.fFilterExt = iTypeInfoFilterExtension;
            String string = ((TypeSearchPattern)this.patternMatcher).getPackagePattern();
            if (string != null) {
                this.fPackageMatcher = new SearchPattern();
                this.fPackageMatcher.setPattern(string);
            } else {
                this.fPackageMatcher = null;
            }
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            if (!super.isSubFilter(itemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)itemsFilter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            if (this.fMyTypeFilterVersion != typeItemsFilter.getMyTypeFilterVersion()) {
                return false;
            }
            return this.getPattern().indexOf(46, itemsFilter.getPattern().length()) == -1;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            if (!super.equalsFilter(itemsFilter)) {
                return false;
            }
            if (!(itemsFilter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)itemsFilter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            return this.fMyTypeFilterVersion == typeItemsFilter.getMyTypeFilterVersion();
        }

        public int getElementKind() {
            return this.fElemKind;
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return this.fFilterExt;
        }

        public IJavaSearchScope getSearchScope() {
            return this.fScope;
        }

        public int getMyTypeFilterVersion() {
            return this.fMyTypeFilterVersion;
        }

        public String getPackagePattern() {
            if (this.fPackageMatcher == null) {
                return null;
            }
            return this.fPackageMatcher.getPattern();
        }

        public int getPackageFlags() {
            if (this.fPackageMatcher == null) {
                return 1;
            }
            return this.fPackageMatcher.getMatchRule();
        }

        public boolean matchesRawNamePattern(TypeNameMatch typeNameMatch) {
            return Strings.startsWithIgnoreCase(typeNameMatch.getSimpleTypeName(), this.getPattern());
        }

        public boolean matchesCachedResult(TypeNameMatch typeNameMatch) {
            if (!this.matchesPackage(typeNameMatch) || !this.matchesFilterExtension(typeNameMatch)) {
                return false;
            }
            return this.matchesName(typeNameMatch);
        }

        public boolean matchesHistoryElement(TypeNameMatch typeNameMatch) {
            if (!(this.matchesPackage(typeNameMatch) && this.matchesModifiers(typeNameMatch) && this.matchesScope(typeNameMatch) && this.matchesFilterExtension(typeNameMatch))) {
                return false;
            }
            return this.matchesName(typeNameMatch);
        }

        public boolean matchesFilterExtension(TypeNameMatch typeNameMatch) {
            if (this.fFilterExt == null) {
                return true;
            }
            this.fAdapter.setMatch(typeNameMatch);
            return this.fFilterExt.select(this.fAdapter);
        }

        private boolean matchesName(TypeNameMatch typeNameMatch) {
            return this.matches(typeNameMatch.getSimpleTypeName());
        }

        private boolean matchesPackage(TypeNameMatch typeNameMatch) {
            if (this.fPackageMatcher == null) {
                return true;
            }
            return this.fPackageMatcher.matches(typeNameMatch.getPackageName());
        }

        private boolean matchesScope(TypeNameMatch typeNameMatch) {
            if (this.fIsWorkspaceScope) {
                return true;
            }
            return this.fScope.encloses((IJavaElement)typeNameMatch.getType());
        }

        private boolean matchesModifiers(TypeNameMatch typeNameMatch) {
            if (this.fElemKind == 0) {
                return true;
            }
            int n = typeNameMatch.getModifiers() & 0x6200;
            switch (this.fElemKind) {
                case 5: {
                    return n == 0;
                }
                case 8: {
                    return Flags.isAnnotation((int)n);
                }
                case 6: {
                    return Flags.isInterface((int)n);
                }
                case 7: {
                    return Flags.isEnum((int)n);
                }
                case 10: {
                    return n == 0 || Flags.isInterface((int)n);
                }
                case 9: {
                    return n == 0 || Flags.isEnum((int)n);
                }
            }
            return false;
        }

        public void setMatchEverythingMode(boolean bl) {
            this.fMatchEverything = bl;
        }

        public boolean isConsistentItem(Object object) {
            return true;
        }

        public boolean matchItem(Object object) {
            if (this.fMatchEverything) {
                return true;
            }
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            if (!(this.matchesPackage(typeNameMatch) && this.matchesModifiers(typeNameMatch) && this.matchesScope(typeNameMatch) && this.matchesFilterExtension(typeNameMatch))) {
                return false;
            }
            return this.matchesName(typeNameMatch);
        }

        public boolean matchesRawNamePattern(Object object) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            return this.matchesRawNamePattern(typeNameMatch);
        }
    }

    private static class TypeSearchPattern
    extends SearchPattern {
        private String packagePattern;

        private TypeSearchPattern() {
        }

        public void setPattern(String string) {
            String string2 = string;
            String string3 = null;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string3 = this.evaluatePackagePattern(string.substring(0, n));
                string2 = string.substring(n + 1);
                if (string2.length() == 0) {
                    string2 = "**";
                }
            }
            super.setPattern(string2);
            this.packagePattern = string3;
        }

        private String evaluatePackagePattern(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '.') {
                    if (!bl) {
                        stringBuffer.append('*');
                    }
                    bl = false;
                } else if (c == '*' || c == '?') {
                    bl = true;
                }
                stringBuffer.append(c);
                ++n;
            }
            if (!bl) {
                stringBuffer.append('*');
            }
            return stringBuffer.toString();
        }

        protected boolean isNameCharAllowed(char c) {
            return super.isNameCharAllowed(c);
        }

        protected boolean isPatternCharAllowed(char c) {
            return super.isPatternCharAllowed(c);
        }

        protected boolean isValidCamelCaseChar(char c) {
            return super.isValidCamelCaseChar(c);
        }

        public String getPackagePattern() {
            return this.packagePattern;
        }
    }

    private static class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private final FilteredItemsSelectionDialog.AbstractContentProvider fContentProvider;
        private final TypeItemsFilter fTypeItemsFilter;

        public TypeSearchRequestor(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, TypeItemsFilter typeItemsFilter) {
            this.fContentProvider = abstractContentProvider;
            this.fTypeItemsFilter = typeItemsFilter;
        }

        public void cancel() {
            this.fStop = true;
        }

        public void acceptTypeNameMatch(TypeNameMatch typeNameMatch) {
            if (this.fStop) {
                return;
            }
            if (TypeFilter.isFiltered(typeNameMatch)) {
                return;
            }
            if (this.fTypeItemsFilter.matchesFilterExtension(typeNameMatch)) {
                this.fContentProvider.add((Object)typeNameMatch, (FilteredItemsSelectionDialog.ItemsFilter)this.fTypeItemsFilter);
            }
        }
    }

    protected class TypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        public synchronized void accessed(Object object) {
            super.accessed(object);
        }

        public synchronized boolean remove(Object object) {
            OpenTypeHistory.getInstance().remove((TypeNameMatch)object);
            return super.remove(object);
        }

        public void load(IMemento iMemento) {
            TypeNameMatch[] typeNameMatchArray = OpenTypeHistory.getInstance().getTypeInfos();
            int n = 0;
            while (n < typeNameMatchArray.length) {
                TypeNameMatch typeNameMatch = typeNameMatchArray[n];
                this.accessed(typeNameMatch);
                ++n;
            }
        }

        public void save(IMemento iMemento) {
            this.persistHistory();
        }

        private synchronized void persistHistory() {
            if (FilteredTypesSelectionDialog.this.getReturnCode() == 0) {
                Object[] objectArray = this.getHistoryItems();
                int n = 0;
                while (n < objectArray.length) {
                    OpenTypeHistory.getInstance().accessed((TypeNameMatch)objectArray[n]);
                    ++n;
                }
            }
        }

        protected Object restoreItemFromMemento(IMemento iMemento) {
            return null;
        }

        protected void storeItemToMemento(Object object, IMemento iMemento) {
        }
    }
}

