/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class PackageSelectionDialog
extends ElementListSelectionDialog {
    public static final int F_REMOVE_DUPLICATES = 1;
    public static final int F_SHOW_PARENTS = 2;
    public static final int F_HIDE_DEFAULT_PACKAGE = 4;
    public static final int F_HIDE_EMPTY_INNER = 8;
    private Point fLocation;
    private Point fSize;
    private IRunnableContext fContext;
    private IJavaSearchScope fScope;
    private int fFlags;

    public PackageSelectionDialog(Shell shell, IRunnableContext iRunnableContext, int n, IJavaSearchScope iJavaSearchScope) {
        super(shell, PackageSelectionDialog.createLabelProvider(n));
        this.fFlags = n;
        this.fScope = iJavaSearchScope;
        this.fContext = iRunnableContext;
    }

    private static ILabelProvider createLabelProvider(int n) {
        int n2 = JavaElementLabelProvider.SHOW_DEFAULT;
        if ((n & 1) == 0) {
            n2 |= 0x40;
        }
        return new JavaElementLabelProvider(n2);
    }

    public int open() {
        final ArrayList arrayList = new ArrayList();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                boolean bl = (PackageSelectionDialog.this.fFlags & 8) != 0;
                iProgressMonitor.beginTask(JavaUIMessages.PackageSelectionDialog_progress_search, bl ? 2 : 1);
                try {
                    try {
                        SearchRequestor searchRequestor = new SearchRequestor(this, arrayList){
                            private HashSet fSet;
                            private final boolean fAddDefault;
                            private final boolean fDuplicates;
                            private final boolean fIncludeParents;
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ArrayList val$packageList;
                            {
                                this.this$1 = var1_1;
                                this.val$packageList = arrayList;
                                this.fSet = new HashSet<E>();
                                this.fAddDefault = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 4) == 0;
                                this.fDuplicates = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 1) == 0;
                                this.fIncludeParents = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 2) != 0;
                            }

                            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                                IJavaElement iJavaElement = (IJavaElement)searchMatch.getElement();
                                String string = iJavaElement.getElementName();
                                if ((this.fAddDefault || string.length() > 0) && (this.fDuplicates || this.fSet.add(string))) {
                                    this.val$packageList.add(iJavaElement);
                                    if (this.fIncludeParents) {
                                        this.addParentPackages(iJavaElement, string);
                                    }
                                }
                            }

                            private void addParentPackages(IJavaElement iJavaElement, String string) {
                                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getParent();
                                int n = string.lastIndexOf(46);
                                while (n != -1) {
                                    string = string.substring(0, n);
                                    if (this.fDuplicates || this.fSet.add(string)) {
                                        this.val$packageList.add(iPackageFragmentRoot.getPackageFragment(string));
                                    }
                                    n = string.lastIndexOf(46);
                                }
                            }
                        };
                        SearchPattern searchPattern = SearchPattern.createPattern((String)"*", (int)2, (int)0, (int)10);
                        new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), PackageSelectionDialog.this.fScope, searchRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        if (iProgressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (bl) {
                            this.removeEmptyPackages((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                iProgressMonitor.done();
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void removeEmptyPackages(IProgressMonitor iProgressMonitor) throws JavaModelException, InterruptedException {
                iProgressMonitor.beginTask(JavaUIMessages.PackageSelectionDialog_progress_findEmpty, arrayList.size());
                try {
                    ArrayList<IPackageFragment> arrayList2 = new ArrayList<IPackageFragment>(arrayList.size());
                    int n = 0;
                    while (true) {
                        block6: {
                            if (n < arrayList.size()) break block6;
                            arrayList.clear();
                            arrayList.addAll(arrayList2);
                            break;
                        }
                        IPackageFragment iPackageFragment = (IPackageFragment)arrayList.get(n);
                        if (iPackageFragment.hasChildren() || !iPackageFragment.hasSubpackages()) {
                            arrayList2.add(iPackageFragment);
                        }
                        iProgressMonitor.worked(1);
                        if (iProgressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                iProgressMonitor.done();
            }

            static /* synthetic */ PackageSelectionDialog access$0(1 var0) {
                return var0.PackageSelectionDialog.this;
            }
        };
        try {
            this.fContext.run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, JavaUIMessages.PackageSelectionDialog_error_title, JavaUIMessages.PackageSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (arrayList.isEmpty()) {
            String string = JavaUIMessages.PackageSelectionDialog_nopackages_title;
            String string2 = JavaUIMessages.PackageSelectionDialog_nopackages_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
            return 1;
        }
        this.setElements(arrayList.toArray());
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.open_package_dialog_context");
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.readSettings();
        return control;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (this.fSize != null) {
            point.x = Math.max(point.x, this.fSize.x);
            point.y = Math.max(point.y, this.fSize.y);
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            point.x = Math.min(point.x, rectangle.width);
            point.y = Math.min(point.y, rectangle.height);
        }
        return point;
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        if (this.fLocation != null) {
            int n;
            point2.x = this.fLocation.x;
            point2.y = this.fLocation.y;
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            int n2 = point2.x + point.x;
            if (n2 > rectangle.width) {
                point2.x -= n2 - rectangle.width;
            }
            if ((n = point2.y + point.y) > rectangle.height) {
                point2.y -= n - rectangle.height;
            }
        }
        return point2;
    }

    private void readSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        try {
            int n = iDialogSettings.getInt("x");
            int n2 = iDialogSettings.getInt("y");
            this.fLocation = new Point(n, n2);
            int n3 = iDialogSettings.getInt("width");
            int n4 = iDialogSettings.getInt("height");
            this.fSize = new Point(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    private void writeSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Point point = this.getShell().getLocation();
        iDialogSettings.put("x", point.x);
        iDialogSettings.put("y", point.y);
        Point point2 = this.getShell().getSize();
        iDialogSettings.put("width", point2.x);
        iDialogSettings.put("height", point2.y);
    }

    private IDialogSettings getDialogSettings() {
        String string;
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string = ((Object)((Object)this)).getClass().getName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }
}

