/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoImageProvider;

public class TypeInfoViewer {
    private Display fDisplay;
    private String fProgressMessage;
    private Label fProgressLabel;
    private int fProgressCounter;
    private ProgressUpdateJob fProgressUpdateJob;
    private OpenTypeHistory fHistory;
    private int fNextElement;
    private List fItems;
    private TypeNameMatch[] fHistoryMatches;
    private TypeNameMatch[] fSearchMatches;
    private int fNumberOfVisibleItems;
    private int fExpectedItemCount;
    private Color fDashLineColor;
    private int fScrollbarWidth;
    private int fTableWidthDelta;
    private int fDashLineIndex = -1;
    private Image fSeparatorIcon;
    private DashLine fDashLine = new DashLine();
    private boolean fFullyQualifySelection;
    private TableItem[] fLastSelection;
    private String[] fLastLabels;
    private TypeInfoLabelProvider fLabelProvider;
    private ImageManager fImageManager;
    private Table fTable;
    private SyncJob fSyncJob;
    private TypeInfoFilter fTypeInfoFilter;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeNameMatch[] fLastCompletedResult;
    private TypeInfoFilter fLastCompletedFilter;
    private int fSearchJobTicket;
    protected int fElementKind;
    protected IJavaSearchScope fSearchScope;
    private AbstractSearchJob fSearchJob;
    private static final int HISTORY = 1;
    private static final int INDEX = 2;
    private static final int FULL = 3;
    private static final char SEPARATOR = '-';
    private static final boolean DEBUG = false;
    private static final boolean VIRTUAL = false;
    private static final TypeNameMatch[] EMTPY_TYPE_INFO_ARRAY = new TypeNameMatch[0];
    private static final TypeNameMatch DASH_LINE = SearchEngine.createTypeNameMatch(null, (int)0);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeInfoViewer(Composite composite, int n, Label label, IJavaSearchScope iJavaSearchScope, int n2, String string, ITypeInfoFilterExtension iTypeInfoFilterExtension, ITypeInfoImageProvider iTypeInfoImageProvider) {
        Assert.isNotNull((Object)iJavaSearchScope);
        this.fDisplay = composite.getDisplay();
        this.fProgressLabel = label;
        this.fSearchScope = iJavaSearchScope;
        this.fElementKind = n2;
        this.fFilterExtension = iTypeInfoFilterExtension;
        this.fFullyQualifySelection = (n & 2) != 0;
        this.fTable = new Table(composite, 0x800B00 | n);
        this.fTable.setFont(composite.getFont());
        this.fLabelProvider = new TypeInfoLabelProvider(iTypeInfoImageProvider);
        this.fItems = new ArrayList(500);
        this.fTable.setHeaderVisible(false);
        this.addPopupMenu();
        this.fTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                int n = TypeInfoViewer.this.fTable.getItemHeight();
                Rectangle rectangle = TypeInfoViewer.this.fTable.getClientArea();
                TypeInfoViewer.this.fNumberOfVisibleItems = rectangle.height / n + 1;
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    TypeInfoViewer.this.deleteHistoryEntry();
                } else if (keyEvent.keyCode == 0x1000002) {
                    int n = TypeInfoViewer.this.fTable.getSelectionIndex();
                    if (n == TypeInfoViewer.this.fDashLineIndex - 1) {
                        keyEvent.doit = false;
                        TypeInfoViewer.this.setTableSelection(n + 2);
                    }
                } else if (keyEvent.keyCode == 0x1000001) {
                    int n = TypeInfoViewer.this.fTable.getSelectionIndex();
                    if (TypeInfoViewer.this.fDashLineIndex != -1 && n == TypeInfoViewer.this.fDashLineIndex + 1) {
                        keyEvent.doit = false;
                        TypeInfoViewer.this.setTableSelection(n - 2);
                    }
                }
            }
        });
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TypeInfoViewer.this.fLastSelection != null) {
                    int n = 0;
                    while (n < TypeInfoViewer.this.fLastSelection.length) {
                        TableItem tableItem = TypeInfoViewer.this.fLastSelection[n];
                        if (!tableItem.isDisposed()) {
                            tableItem.setText(TypeInfoViewer.this.fLastLabels[n]);
                        }
                        ++n;
                    }
                }
                TableItem[] tableItemArray = TypeInfoViewer.this.fTable.getSelection();
                TypeInfoViewer.this.fLastSelection = new TableItem[tableItemArray.length];
                TypeInfoViewer.this.fLastLabels = new String[tableItemArray.length];
                int n = 0;
                while (n < tableItemArray.length) {
                    String string;
                    TableItem tableItem;
                    ((TypeInfoViewer)TypeInfoViewer.this).fLastSelection[n] = tableItem = tableItemArray[n];
                    ((TypeInfoViewer)TypeInfoViewer.this).fLastLabels[n] = tableItem.getText();
                    Object object = tableItem.getData();
                    if (object instanceof TypeNameMatch && (string = TypeInfoViewer.this.getQualifiedText((TypeNameMatch)object)).length() > TypeInfoViewer.this.fLastLabels[n].length()) {
                        tableItem.setText(string);
                    }
                    ++n;
                }
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TypeInfoViewer.this.stop(true, true);
                TypeInfoViewer.this.fDashLineColor.dispose();
                TypeInfoViewer.this.fSeparatorIcon.dispose();
                TypeInfoViewer.this.fImageManager.dispose();
                if (TypeInfoViewer.this.fProgressUpdateJob != null) {
                    TypeInfoViewer.this.fProgressUpdateJob.stop();
                    TypeInfoViewer.this.fProgressUpdateJob = null;
                }
            }
        });
        this.fDashLineColor = this.computeDashLineColor();
        this.fScrollbarWidth = this.computeScrollBarWidth();
        this.fTableWidthDelta = this.fTable.computeTrim((int)0, (int)0, (int)0, (int)0).width - this.fScrollbarWidth;
        this.fSeparatorIcon = JavaPluginImages.DESC_OBJS_TYPE_SEPARATOR.createImage((Device)this.fTable.getDisplay());
        this.fImageManager = new ImageManager();
        this.fHistory = OpenTypeHistory.getInstance();
        if (string != null && string.length() > 0) {
            this.fTypeInfoFilter = this.createTypeInfoFilter(string);
        }
        GC gC = null;
        try {
            gC = new GC((Drawable)this.fTable);
            gC.setFont(this.fTable.getFont());
            this.fDashLine.initialize(gC);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            gC.dispose();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        gC.dispose();
        if (this.fTypeInfoFilter == null) {
            this.scheduleSyncJob();
        }
    }

    void startup() {
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(3);
        }
    }

    public Table getTable() {
        return this.fTable;
    }

    TypeInfoLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private int getNumberOfVisibleItems() {
        return this.fNumberOfVisibleItems;
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void setQualificationStyle(boolean bl) {
        if (this.fFullyQualifySelection == bl) {
            return;
        }
        this.fFullyQualifySelection = bl;
        if (this.fLastSelection != null) {
            int n = 0;
            while (n < this.fLastSelection.length) {
                TableItem tableItem = this.fLastSelection[n];
                Object object = tableItem.getData();
                if (object instanceof TypeNameMatch) {
                    tableItem.setText(this.getQualifiedText((TypeNameMatch)object));
                }
                ++n;
            }
        }
    }

    public TypeNameMatch[] getSelection() {
        TableItem[] tableItemArray = this.fTable.getSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            Object object = tableItemArray[n].getData();
            if (object instanceof TypeNameMatch) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray(new TypeNameMatch[arrayList.size()]);
    }

    public void stop() {
        this.stop(true, false);
    }

    public void stop(boolean bl, boolean bl2) {
        if (this.fSyncJob != null && bl) {
            this.fSyncJob.stop();
            this.fSyncJob = null;
        }
        if (this.fSearchJob != null) {
            this.fSearchJob.stop();
            this.fSearchJob = null;
        }
    }

    public void forceSearch() {
        this.stop(false, false);
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.fLastCompletedFilter = null;
            this.fLastCompletedResult = null;
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setSearchPattern(String string) {
        this.stop(false, false);
        if (string.length() == 0 || "*".equals(string)) {
            this.fTypeInfoFilter = null;
            this.reset();
        } else {
            this.fTypeInfoFilter = this.createTypeInfoFilter(string);
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setSearchScope(IJavaSearchScope iJavaSearchScope, boolean bl) {
        this.fSearchScope = iJavaSearchScope;
        if (!bl) {
            return;
        }
        this.stop(false, false);
        this.fLastCompletedFilter = null;
        this.fLastCompletedResult = null;
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setFullyQualifyDuplicates(boolean bl, boolean bl2) {
        this.fLabelProvider.setFullyQualifyDuplicates(bl);
        if (!bl2) {
            return;
        }
        this.stop(false, false);
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void reset() {
        this.fLastSelection = null;
        this.fLastLabels = null;
        this.fExpectedItemCount = 0;
        this.fDashLineIndex = -1;
        TypeInfoFilter typeInfoFilter = this.fTypeInfoFilter != null ? this.fTypeInfoFilter : new TypeInfoFilter("*", this.fSearchScope, this.fElementKind, this.fFilterExtension);
        this.fNextElement = 0;
        TypeNameMatch[] typeNameMatchArray = this.fHistory.getFilteredTypeInfos(typeInfoFilter);
        if (typeNameMatchArray.length == 0) {
            this.shortenTable();
            return;
        }
        this.fExpectedItemCount = typeNameMatchArray.length;
        int n = typeNameMatchArray.length - 1;
        TypeNameMatch typeNameMatch = null;
        TypeNameMatch typeNameMatch2 = typeNameMatchArray[0];
        int n2 = 0;
        while (n2 < typeNameMatchArray.length) {
            TypeNameMatch typeNameMatch3 = n2 == n ? null : typeNameMatchArray[n2 + 1];
            this.addSingleElement(typeNameMatch2, this.fLabelProvider.getImageDescriptor(typeNameMatch2), this.fLabelProvider.getText(typeNameMatch, typeNameMatch2, typeNameMatch3));
            typeNameMatch = typeNameMatch2;
            typeNameMatch2 = typeNameMatch3;
            ++n2;
        }
        this.shortenTable();
    }

    protected TypeInfoFilter createTypeInfoFilter(String string) {
        if ("**".equals(string)) {
            string = "*";
        }
        return new TypeInfoFilter(string, this.fSearchScope, this.fElementKind, this.fFilterExtension);
    }

    private void addPopupMenu() {
        Menu menu = new Menu((Decorations)this.fTable.getShell(), 8);
        this.fTable.setMenu(menu);
        final MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(JavaUIMessages.TypeInfoViewer_remove_from_history);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                TableItem[] tableItemArray = TypeInfoViewer.this.fTable.getSelection();
                menuItem.setEnabled(TypeInfoViewer.this.canEnable(tableItemArray));
            }
        });
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeInfoViewer.this.deleteHistoryEntry();
            }
        });
    }

    private boolean canEnable(TableItem[] tableItemArray) {
        if (tableItemArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            Object object = tableItem.getData();
            if (!(object instanceof TypeNameMatch)) {
                return false;
            }
            if (!this.fHistory.contains((TypeNameMatch)object)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void deleteHistoryEntry() {
        int n = this.fTable.getSelectionIndex();
        if (n == -1) {
            return;
        }
        TableItem tableItem = this.fTable.getItem(n);
        Object object = tableItem.getData();
        if (!(object instanceof TypeNameMatch)) {
            return;
        }
        if (this.fHistory.remove(object) != null) {
            tableItem.dispose();
            this.fItems.remove(n);
            int n2 = this.fTable.getItemCount();
            if (n2 > 0) {
                tableItem = this.fTable.getItem(0);
                if (tableItem.getData() instanceof DashLine) {
                    tableItem.dispose();
                    this.fItems.remove(0);
                    this.fDashLineIndex = -1;
                    if (n2 > 1) {
                        this.setTableSelection(0);
                    }
                } else {
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    this.setTableSelection(n);
                }
            } else {
                this.fTable.notifyListeners(13, new Event());
            }
        }
    }

    private void clear(int n) {
        this.syncExec(n, new Runnable(){

            public void run() {
                TypeInfoViewer.this.fNextElement = 0;
                TypeInfoViewer.this.fDashLineIndex = -1;
                TypeInfoViewer.this.fLastSelection = null;
                TypeInfoViewer.this.fLastLabels = null;
                TypeInfoViewer.this.fExpectedItemCount = 0;
            }
        });
    }

    private void rememberResult(int n, final TypeNameMatch[] typeNameMatchArray) {
        this.syncExec(n, new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fLastCompletedResult == null) {
                    TypeInfoViewer.this.fLastCompletedFilter = TypeInfoViewer.this.fTypeInfoFilter;
                    TypeInfoViewer.this.fLastCompletedResult = typeNameMatchArray;
                }
            }
        });
    }

    private void addHistory(int n, List list, List list2, List list3) {
        this.addAll(n, list, list2, list3);
    }

    private void addAll(int n, final List list, final List list2, final List list3) {
        this.syncExec(n, new Runnable(){

            public void run() {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    TypeInfoViewer.this.addSingleElement(list.get(n2), (ImageDescriptor)list2.get(n2), (String)list3.get(n2));
                    ++n2;
                }
            }
        });
    }

    private void addDashLineAndUpdateLastHistoryEntry(int n, final TypeNameMatch typeNameMatch) {
        this.syncExec(n, new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fNextElement > 0) {
                    TableItem tableItem;
                    TableItem tableItem2 = TypeInfoViewer.this.fTable.getItem(TypeInfoViewer.this.fNextElement - 1);
                    String string = tableItem2.getText();
                    String string2 = TypeInfoViewer.this.fLabelProvider.getText(null, (TypeNameMatch)tableItem2.getData(), typeNameMatch);
                    if (string2.length() != string.length()) {
                        tableItem2.setText(string2);
                    }
                    if (TypeInfoViewer.this.fLastSelection != null && TypeInfoViewer.this.fLastSelection.length > 0 && (tableItem = TypeInfoViewer.this.fLastSelection[TypeInfoViewer.this.fLastSelection.length - 1]) == tableItem2) {
                        ((TypeInfoViewer)TypeInfoViewer.this).fLastLabels[((TypeInfoViewer)TypeInfoViewer.this).fLastLabels.length - 1] = string2;
                    }
                }
                TypeInfoViewer.this.fDashLineIndex = TypeInfoViewer.this.fNextElement;
                TypeInfoViewer.this.addDashLine();
            }
        });
    }

    private void addDashLine() {
        TableItem tableItem = null;
        if (this.fItems.size() > this.fNextElement) {
            tableItem = (TableItem)this.fItems.get(this.fNextElement);
        } else {
            tableItem = new TableItem(this.fTable, 0);
            this.fItems.add(tableItem);
        }
        this.fillDashLine(tableItem);
        ++this.fNextElement;
    }

    private void addSingleElement(Object object, ImageDescriptor imageDescriptor, String string) {
        TableItem tableItem = null;
        Object object2 = null;
        if (this.fItems.size() > this.fNextElement) {
            tableItem = (TableItem)this.fItems.get(this.fNextElement);
            object2 = tableItem.getData();
            tableItem.setForeground(null);
        } else {
            tableItem = new TableItem(this.fTable, 0);
            this.fItems.add(tableItem);
        }
        tableItem.setData(object);
        tableItem.setImage(this.fImageManager.get(imageDescriptor));
        if (this.fNextElement == 0) {
            if (this.needsSelectionChange(object2, object) || this.fLastSelection != null) {
                tableItem.setText(string);
                this.fTable.setSelection(0);
                this.fTable.notifyListeners(13, new Event());
            } else {
                this.fLastSelection = new TableItem[]{tableItem};
                this.fLastLabels = new String[]{string};
            }
        } else {
            tableItem.setText(string);
        }
        ++this.fNextElement;
    }

    private boolean needsSelectionChange(Object object, Object object2) {
        int[] nArray = this.fTable.getSelectionIndices();
        if (nArray.length != 1) {
            return true;
        }
        if (nArray[0] != 0) {
            return true;
        }
        if (object == null) {
            return true;
        }
        return !object.equals(object2);
    }

    private void scheduleSearchJob(int n) {
        ++this.fSearchJobTicket;
        if (this.fLastCompletedFilter != null && this.fTypeInfoFilter.isSubFilter(this.fLastCompletedFilter.getText())) {
            this.fSearchJob = new CachedResultJob(this.fSearchJobTicket, this.fLastCompletedResult, this, this.fTypeInfoFilter, this.fHistory, this.fNumberOfVisibleItems, n);
        } else {
            this.fLastCompletedFilter = null;
            this.fLastCompletedResult = null;
            this.fSearchJob = new SearchEngineJob(this.fSearchJobTicket, this, this.fTypeInfoFilter, this.fHistory, this.fNumberOfVisibleItems, n, this.fSearchScope, this.fElementKind);
        }
        this.fSearchJob.schedule();
    }

    private void searchJobDone(int n) {
        this.syncExec(n, new Runnable(){

            public void run() {
                TypeInfoViewer.this.shortenTable();
                TypeInfoViewer.this.checkEmptyList();
                TypeInfoViewer.this.fSearchJob = null;
            }
        });
    }

    private void searchJobCanceled(int n, final boolean bl) {
        this.syncExec(n, new Runnable(){

            public void run() {
                if (bl) {
                    TypeInfoViewer.this.shortenTable();
                    TypeInfoViewer.this.checkEmptyList();
                }
                TypeInfoViewer.this.fSearchJob = null;
            }
        });
    }

    private synchronized void searchJobFailed(int n, CoreException coreException) {
        this.searchJobDone(n);
        JavaPlugin.log(coreException);
    }

    private void setHistoryResult(int n, final TypeNameMatch[] typeNameMatchArray) {
        this.syncExec(n, new Runnable(){

            public void run() {
                TypeInfoViewer.this.fExpectedItemCount = typeNameMatchArray.length;
                int n = TypeInfoViewer.this.fHistoryMatches.length;
                TypeInfoViewer.this.fHistoryMatches = typeNameMatchArray;
                int n2 = TypeInfoViewer.this.fHistoryMatches.length + TypeInfoViewer.this.fSearchMatches.length;
                int n3 = TypeInfoViewer.this.fHistoryMatches.length > 0 && TypeInfoViewer.this.fSearchMatches.length > 0 ? 1 : 0;
                TypeInfoViewer.this.fTable.setItemCount(n2 + n3);
                if (n2 == 0) {
                    TypeInfoViewer.this.fTable.redraw();
                    return;
                }
                int n4 = Math.max(n, TypeInfoViewer.this.fHistoryMatches.length);
                if (n4 > 0) {
                    TypeInfoViewer.this.fTable.clear(0, n4 + n3 - 1);
                }
            }
        });
    }

    private void setSearchResult(int n, final TypeNameMatch[] typeNameMatchArray) {
        this.syncExec(n, new Runnable(){

            public void run() {
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fExpectedItemCount = typeInfoViewer.fExpectedItemCount + typeNameMatchArray.length;
                TypeInfoViewer.this.fSearchMatches = typeNameMatchArray;
                int n = TypeInfoViewer.this.fHistoryMatches.length + TypeInfoViewer.this.fSearchMatches.length;
                int n2 = TypeInfoViewer.this.fHistoryMatches.length > 0 && TypeInfoViewer.this.fSearchMatches.length > 0 ? 1 : 0;
                TypeInfoViewer.this.fTable.setItemCount(n + n2);
                if (n == 0) {
                    TypeInfoViewer.this.fTable.redraw();
                    return;
                }
                if (TypeInfoViewer.this.fHistoryMatches.length == 0) {
                    TypeInfoViewer.this.fTable.clear(0, n + n2 - 1);
                } else {
                    TypeInfoViewer.this.fTable.clear(TypeInfoViewer.this.fHistoryMatches.length - 1, n + n2 - 1);
                }
            }
        });
    }

    private void setData(TableItem tableItem) {
        int n = this.fTable.indexOf(tableItem);
        TypeNameMatch typeNameMatch = this.getTypeInfo(n);
        if (typeNameMatch == DASH_LINE) {
            tableItem.setData((Object)this.fDashLine);
            this.fillDashLine(tableItem);
        } else {
            tableItem.setData((Object)typeNameMatch);
            tableItem.setImage(this.fImageManager.get(this.fLabelProvider.getImageDescriptor(typeNameMatch)));
            tableItem.setText(this.fLabelProvider.getText(this.getTypeInfo(n - 1), typeNameMatch, this.getTypeInfo(n + 1)));
            tableItem.setForeground(null);
        }
    }

    private TypeNameMatch getTypeInfo(int n) {
        int n2;
        if (n < 0) {
            return null;
        }
        if (n < this.fHistoryMatches.length) {
            return this.fHistoryMatches[n];
        }
        int n3 = n2 = this.fHistoryMatches.length > 0 && this.fSearchMatches.length > 0 ? 1 : 0;
        if (n == this.fHistoryMatches.length && n2 == 1) {
            return DASH_LINE;
        }
        if ((n = n - this.fHistoryMatches.length - n2) >= this.fSearchMatches.length) {
            return null;
        }
        return this.fSearchMatches[n];
    }

    private void scheduleSyncJob() {
        this.fSyncJob = new SyncJob(this);
        this.fSyncJob.schedule();
    }

    private void syncJobDone() {
        this.syncExec(new Runnable(){

            public void run() {
                TypeInfoViewer.this.fSyncJob = null;
                if (TypeInfoViewer.this.fTypeInfoFilter != null) {
                    TypeInfoViewer.this.scheduleSearchJob(3);
                }
            }
        });
    }

    private boolean isSyncJobRunning() {
        return this.fSyncJob != null;
    }

    private void scheduleProgressUpdateJob() {
        this.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fProgressCounter == 0) {
                    TypeInfoViewer.this.clearProgressMessage();
                    TypeInfoViewer.this.fProgressUpdateJob = new ProgressUpdateJob(TypeInfoViewer.this.fDisplay, TypeInfoViewer.this);
                    TypeInfoViewer.this.fProgressUpdateJob.schedule(300L);
                }
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fProgressCounter = typeInfoViewer.fProgressCounter + 1;
            }
        });
    }

    private void stopProgressUpdateJob() {
        this.syncExec(new Runnable(){

            public void run() {
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fProgressCounter = typeInfoViewer.fProgressCounter - 1;
                if (TypeInfoViewer.this.fProgressCounter == 0 && TypeInfoViewer.this.fProgressUpdateJob != null) {
                    TypeInfoViewer.this.fProgressUpdateJob.stop();
                    TypeInfoViewer.this.fProgressUpdateJob = null;
                    TypeInfoViewer.this.clearProgressMessage();
                }
            }
        });
    }

    private void setProgressMessage(String string) {
        this.fProgressMessage = string;
    }

    private void clearProgressMessage() {
        this.fProgressMessage = "";
        this.fProgressLabel.setText(this.fProgressMessage);
    }

    private void updateProgressMessage() {
        this.fProgressLabel.setText(this.fProgressMessage);
    }

    private void syncExec(final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fTable.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void syncExec(final int n, final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fTable.isDisposed() || n != TypeInfoViewer.this.fSearchJobTicket) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void fillDashLine(TableItem tableItem) {
        Rectangle rectangle = tableItem.getImageBounds(0);
        Rectangle rectangle2 = this.fTable.getBounds();
        boolean bl = this.fExpectedItemCount + 1 > this.fNumberOfVisibleItems;
        tableItem.setText(this.fDashLine.getText(rectangle2.width - rectangle.x - rectangle.width - this.fTableWidthDelta - (bl ? this.fScrollbarWidth : 0)));
        tableItem.setImage(this.fSeparatorIcon);
        tableItem.setForeground(this.fDashLineColor);
        tableItem.setData((Object)this.fDashLine);
    }

    private void shortenTable() {
        if (this.fNextElement < this.fItems.size()) {
            this.fTable.setRedraw(false);
            this.fTable.remove(this.fNextElement, this.fItems.size() - 1);
            this.fTable.setRedraw(true);
        }
        int n = this.fItems.size() - 1;
        while (n >= this.fNextElement) {
            this.fItems.remove(n);
            --n;
        }
    }

    private void checkEmptyList() {
        if (this.fTable.getItemCount() == 0) {
            this.fTable.notifyListeners(13, new Event());
        }
    }

    private void setTableSelection(int n) {
        this.fTable.setSelection(n);
        this.fTable.notifyListeners(13, new Event());
    }

    private Color computeDashLineColor() {
        Color color = this.fTable.getForeground();
        int n = (int)(0.3 * (double)color.getRed() + 0.59 * (double)color.getGreen() + 0.11 * (double)color.getBlue());
        Color color2 = this.fTable.getBackground();
        int n2 = (int)(0.3 * (double)color2.getRed() + 0.59 * (double)color2.getGreen() + 0.11 * (double)color2.getBlue());
        int n3 = (int)((double)(n + n2) * 0.66);
        return new Color((Device)this.fDisplay, n3, n3, n3);
    }

    private int computeScrollBarWidth() {
        Composite composite = new Composite((Composite)this.fTable.getShell(), 512);
        int n = composite.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        composite.dispose();
        return n;
    }

    private String getQualifiedText(TypeNameMatch typeNameMatch) {
        return this.fFullyQualifySelection ? this.fLabelProvider.getFullyQualifiedText(typeNameMatch) : this.fLabelProvider.getQualifiedText(typeNameMatch);
    }

    private static abstract class AbstractJob
    extends Job {
        protected TypeInfoViewer fViewer;

        protected AbstractJob(String string, TypeInfoViewer typeInfoViewer) {
            super(string);
            this.fViewer = typeInfoViewer;
            this.setSystem(true);
        }

        protected final IStatus run(IProgressMonitor iProgressMonitor) {
            IStatus iStatus;
            ProgressMonitor progressMonitor = new ProgressMonitor(iProgressMonitor, this.fViewer);
            try {
                this.fViewer.scheduleProgressUpdateJob();
                iStatus = this.doRun(progressMonitor);
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fViewer.stopProgressUpdateJob();
                throw throwable;
            }
            this.fViewer.stopProgressUpdateJob();
            return iStatus;
        }

        protected abstract IStatus doRun(ProgressMonitor var1);
    }

    private static abstract class AbstractSearchJob
    extends AbstractJob {
        private int fMode;
        protected int fTicket;
        protected TypeInfoLabelProvider fLabelProvider;
        protected TypeInfoFilter fFilter;
        protected OpenTypeHistory fHistory;

        protected AbstractSearchJob(int n, TypeInfoViewer typeInfoViewer, TypeInfoFilter typeInfoFilter, OpenTypeHistory openTypeHistory, int n2, int n3) {
            super(JavaUIMessages.TypeInfoViewer_job_label, typeInfoViewer);
            this.fMode = n3;
            this.fTicket = n;
            this.fViewer = typeInfoViewer;
            this.fLabelProvider = this.fViewer.getLabelProvider();
            this.fFilter = typeInfoFilter;
            this.fHistory = openTypeHistory;
        }

        public void stop() {
            this.cancel();
        }

        protected IStatus doRun(ProgressMonitor progressMonitor) {
            try {
                this.internalRun(progressMonitor);
            }
            catch (CoreException coreException) {
                this.fViewer.searchJobFailed(this.fTicket, coreException);
                return new Status(4, JavaPlugin.getPluginId(), 4, JavaUIMessages.TypeInfoViewer_job_error, (Throwable)coreException);
            }
            catch (InterruptedException interruptedException) {
                return this.canceled(interruptedException, true);
            }
            catch (OperationCanceledException operationCanceledException) {
                return this.canceled((Exception)((Object)operationCanceledException), false);
            }
            this.fViewer.searchJobDone(this.fTicket);
            return this.ok();
        }

        protected abstract TypeNameMatch[] getSearchResult(Set var1, ProgressMonitor var2) throws CoreException;

        private void internalRun(ProgressMonitor progressMonitor) throws CoreException, InterruptedException {
            block9: {
                if (progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.fViewer.clear(this.fTicket);
                TypeNameMatch typeNameMatch = null;
                TypeNameMatch typeNameMatch2 = null;
                TypeNameMatch typeNameMatch3 = null;
                ArrayList<TypeNameMatch> arrayList = new ArrayList<TypeNameMatch>();
                ArrayList<ImageDescriptor> arrayList2 = new ArrayList<ImageDescriptor>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                HashSet<TypeNameMatch> hashSet = new HashSet<TypeNameMatch>();
                TypeNameMatch[] typeNameMatchArray = this.fHistory.getFilteredTypeInfos(this.fFilter);
                if (typeNameMatchArray.length > 0) {
                    Arrays.sort(typeNameMatchArray, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
                    typeNameMatch2 = typeNameMatchArray[0];
                    int n = 1;
                    while (typeNameMatch2 != null) {
                        typeNameMatch3 = n == typeNameMatchArray.length ? null : typeNameMatchArray[n];
                        arrayList.add(typeNameMatch2);
                        hashSet.add(typeNameMatch2);
                        arrayList2.add(this.fLabelProvider.getImageDescriptor(typeNameMatch2));
                        arrayList3.add(this.fLabelProvider.getText(typeNameMatch, typeNameMatch2, typeNameMatch3));
                        typeNameMatch = typeNameMatch2;
                        typeNameMatch2 = typeNameMatch3;
                        ++n;
                    }
                }
                typeNameMatchArray = null;
                this.fViewer.fExpectedItemCount = arrayList.size();
                this.fViewer.addHistory(this.fTicket, arrayList, arrayList2, arrayList3);
                if ((this.fMode & 2) == 0) {
                    return;
                }
                TypeNameMatch[] typeNameMatchArray2 = this.getSearchResult(hashSet, progressMonitor);
                TypeInfoViewer typeInfoViewer = this.fViewer;
                typeInfoViewer.fExpectedItemCount = typeInfoViewer.fExpectedItemCount + typeNameMatchArray2.length;
                if (typeNameMatchArray2.length == 0) {
                    return;
                }
                if (progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                int n = 0;
                int n2 = 1;
                typeNameMatch2 = typeNameMatchArray2[0];
                if (!hashSet.isEmpty()) {
                    this.fViewer.addDashLineAndUpdateLastHistoryEntry(this.fTicket, typeNameMatch2);
                }
                do {
                    long l = System.currentTimeMillis();
                    arrayList.clear();
                    arrayList2.clear();
                    arrayList3.clear();
                    int n3 = Math.min(n2 == 1 ? this.fViewer.getNumberOfVisibleItems() : 10, typeNameMatchArray2.length - n);
                    if (n3 == 0) break block9;
                    n += n3;
                    while (n3 > 0) {
                        typeNameMatch3 = n2 == typeNameMatchArray2.length ? null : typeNameMatchArray2[n2];
                        arrayList.add(typeNameMatch2);
                        arrayList3.add(this.fLabelProvider.getText(typeNameMatch, typeNameMatch2, typeNameMatch3));
                        arrayList2.add(this.fLabelProvider.getImageDescriptor(typeNameMatch2));
                        typeNameMatch = typeNameMatch2;
                        typeNameMatch2 = typeNameMatch3;
                        ++n2;
                        --n3;
                    }
                    this.fViewer.addAll(this.fTicket, arrayList, arrayList2, arrayList3);
                    long l2 = 100L - (System.currentTimeMillis() - l);
                    if (l2 <= 0L) continue;
                    Thread.sleep(l2);
                } while (!progressMonitor.isCanceled());
                throw new OperationCanceledException();
            }
        }

        private void internalRunVirtual(ProgressMonitor progressMonitor) throws CoreException, InterruptedException {
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.clear(this.fTicket);
            TypeNameMatch[] typeNameMatchArray = this.fHistory.getFilteredTypeInfos(this.fFilter);
            this.fViewer.setHistoryResult(this.fTicket, typeNameMatchArray);
            if ((this.fMode & 2) == 0) {
                return;
            }
            HashSet<TypeNameMatch> hashSet = new HashSet<TypeNameMatch>(typeNameMatchArray.length * 2);
            int n = 0;
            while (n < typeNameMatchArray.length) {
                hashSet.add(typeNameMatchArray[n]);
                ++n;
            }
            TypeNameMatch[] typeNameMatchArray2 = this.getSearchResult(hashSet, progressMonitor);
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.setSearchResult(this.fTicket, typeNameMatchArray2);
        }

        private IStatus canceled(Exception exception, boolean bl) {
            this.fViewer.searchJobCanceled(this.fTicket, bl);
            return new Status(8, JavaPlugin.getPluginId(), 8, JavaUIMessages.TypeInfoViewer_job_cancel, (Throwable)exception);
        }

        private IStatus ok() {
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
    }

    private static class CachedResultJob
    extends AbstractSearchJob {
        private TypeNameMatch[] fLastResult;

        public CachedResultJob(int n, TypeNameMatch[] typeNameMatchArray, TypeInfoViewer typeInfoViewer, TypeInfoFilter typeInfoFilter, OpenTypeHistory openTypeHistory, int n2, int n3) {
            super(n, typeInfoViewer, typeInfoFilter, openTypeHistory, n2, n3);
            this.fLastResult = typeNameMatchArray;
        }

        protected TypeNameMatch[] getSearchResult(Set set, ProgressMonitor progressMonitor) throws CoreException {
            ArrayList<TypeNameMatch> arrayList = new ArrayList<TypeNameMatch>(2048);
            int n = 0;
            while (n < this.fLastResult.length) {
                TypeNameMatch typeNameMatch = this.fLastResult[n];
                if (!set.contains(typeNameMatch) && this.fFilter.matchesCachedResult(typeNameMatch)) {
                    arrayList.add(typeNameMatch);
                }
                ++n;
            }
            TypeNameMatch[] typeNameMatchArray = arrayList.toArray(new TypeNameMatch[arrayList.size()]);
            if (this.fFilter.isCamelCasePattern()) {
                Arrays.sort(typeNameMatchArray, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
            }
            return typeNameMatchArray;
        }
    }

    private static class DashLine {
        private int fSeparatorWidth;
        private String fMessage;
        private int fMessageLength;

        private DashLine() {
        }

        public String getText(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = (n - this.fMessageLength) / this.fSeparatorWidth / 2 - 2;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append('-');
                ++n3;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(this.fMessage);
            stringBuffer2.append(stringBuffer);
            return stringBuffer2.toString();
        }

        public void initialize(GC gC) {
            this.fSeparatorWidth = gC.getAdvanceWidth('-');
            this.fMessage = " " + JavaUIMessages.TypeInfoViewer_separator_message + " ";
            this.fMessageLength = gC.textExtent((String)this.fMessage).x;
        }
    }

    private static class ImageManager {
        private Map fImages = new HashMap(20);

        private ImageManager() {
        }

        public Image get(ImageDescriptor imageDescriptor) {
            Image image;
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            if ((image = (Image)this.fImages.get(imageDescriptor)) != null) {
                return image;
            }
            image = imageDescriptor.createImage();
            if (image != null) {
                this.fImages.put(imageDescriptor, image);
            }
            return image;
        }

        public void dispose() {
            Iterator iterator = this.fImages.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fImages.clear();
        }
    }

    private static class ProgressMonitor
    extends ProgressMonitorWrapper {
        private TypeInfoViewer fViewer;
        private String fName;
        private int fTotalWork;
        private double fWorked;
        private boolean fDone;

        public ProgressMonitor(IProgressMonitor iProgressMonitor, TypeInfoViewer typeInfoViewer) {
            super(iProgressMonitor);
            this.fViewer = typeInfoViewer;
        }

        public void setTaskName(String string) {
            super.setTaskName(string);
            this.fName = string;
        }

        public void beginTask(String string, int n) {
            super.beginTask(string, n);
            if (this.fName == null) {
                this.fName = string;
            }
            this.fTotalWork = n;
        }

        public void worked(int n) {
            super.worked(n);
            this.internalWorked(n);
        }

        public void done() {
            this.fDone = true;
            this.fViewer.setProgressMessage("");
            super.done();
        }

        public void internalWorked(double d) {
            this.fWorked += d;
            this.fViewer.setProgressMessage(this.getMessage());
        }

        private String getMessage() {
            if (this.fDone) {
                return "";
            }
            if (this.fTotalWork == 0) {
                return this.fName;
            }
            return Messages.format(JavaUIMessages.TypeInfoViewer_progress_label, new Object[]{this.fName, new Integer((int)(this.fWorked * 100.0 / (double)this.fTotalWork))});
        }
    }

    private static class ProgressUpdateJob
    extends UIJob {
        private TypeInfoViewer fViewer;
        private boolean fStopped;

        public ProgressUpdateJob(Display display, TypeInfoViewer typeInfoViewer) {
            super(display, JavaUIMessages.TypeInfoViewer_progressJob_label);
            this.fViewer = typeInfoViewer;
        }

        public void stop() {
            this.fStopped = true;
            this.cancel();
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (this.stopped()) {
                return new Status(8, JavaPlugin.getPluginId(), 8, "", null);
            }
            this.fViewer.updateProgressMessage();
            if (!this.stopped()) {
                this.schedule(300L);
            }
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        private boolean stopped() {
            return this.fStopped || this.fViewer.getTable().isDisposed();
        }
    }

    private static class SearchEngineJob
    extends AbstractSearchJob {
        private IJavaSearchScope fScope;
        private int fElementKind;
        private SearchRequestor fReqestor;

        public SearchEngineJob(int n, TypeInfoViewer typeInfoViewer, TypeInfoFilter typeInfoFilter, OpenTypeHistory openTypeHistory, int n2, int n3, IJavaSearchScope iJavaSearchScope, int n4) {
            super(n, typeInfoViewer, typeInfoFilter, openTypeHistory, n2, n3);
            this.fScope = iJavaSearchScope;
            this.fElementKind = n4;
            this.fReqestor = new SearchRequestor(typeInfoFilter);
        }

        public void stop() {
            this.fReqestor.cancel();
            super.stop();
        }

        protected TypeNameMatch[] getSearchResult(Set set, ProgressMonitor progressMonitor) throws CoreException {
            System.currentTimeMillis();
            this.fReqestor.setHistory(set);
            SearchEngine searchEngine = new SearchEngine(null);
            String string = this.fFilter.getPackagePattern();
            progressMonitor.setTaskName(JavaUIMessages.TypeInfoViewer_searchJob_taskName);
            searchEngine.searchAllTypeNames(string == null ? null : string.toCharArray(), this.fFilter.getPackageFlags(), this.fFilter.getNamePattern().toCharArray(), this.fFilter.getSearchFlags(), this.fElementKind, this.fScope, (TypeNameMatchRequestor)this.fReqestor, 3, (IProgressMonitor)progressMonitor);
            TypeNameMatch[] typeNameMatchArray = this.fReqestor.getResult();
            Arrays.sort(typeNameMatchArray, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
            this.fViewer.rememberResult(this.fTicket, typeNameMatchArray);
            return typeNameMatchArray;
        }
    }

    private static class SearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private Set fHistory;
        private TypeInfoFilter fFilter;
        private List fResult = new ArrayList(2048);

        public SearchRequestor(TypeInfoFilter typeInfoFilter) {
            this.fFilter = typeInfoFilter;
        }

        public TypeNameMatch[] getResult() {
            return this.fResult.toArray(new TypeNameMatch[this.fResult.size()]);
        }

        public void cancel() {
            this.fStop = true;
        }

        public void setHistory(Set set) {
            this.fHistory = set;
        }

        public void acceptTypeNameMatch(TypeNameMatch typeNameMatch) {
            if (this.fStop) {
                return;
            }
            if (TypeFilter.isFiltered(typeNameMatch)) {
                return;
            }
            if (this.fHistory.contains(typeNameMatch)) {
                return;
            }
            if (this.fFilter.matchesFilterExtension(typeNameMatch)) {
                this.fResult.add(typeNameMatch);
            }
        }
    }

    private static class SyncJob
    extends AbstractJob {
        public SyncJob(TypeInfoViewer typeInfoViewer) {
            super(JavaUIMessages.TypeInfoViewer_syncJob_label, typeInfoViewer);
        }

        public void stop() {
            this.cancel();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus doRun(ProgressMonitor progressMonitor) {
            try {
                try {
                    progressMonitor.setTaskName(JavaUIMessages.TypeInfoViewer_syncJob_taskName);
                    new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                        final /* synthetic */ SyncJob this$1;
                        {
                            this.this$1 = syncJob;
                        }
                    }, 3, (IProgressMonitor)progressMonitor);
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                    Status status = new Status(4, JavaPlugin.getPluginId(), 4, JavaUIMessages.TypeInfoViewer_job_error, (Throwable)javaModelException);
                    Object var3_6 = null;
                    this.fViewer.syncJobDone();
                    return status;
                }
                catch (OperationCanceledException operationCanceledException) {
                    Status status = new Status(8, JavaPlugin.getPluginId(), 8, JavaUIMessages.TypeInfoViewer_job_cancel, (Throwable)operationCanceledException);
                    Object var3_7 = null;
                    this.fViewer.syncJobDone();
                    return status;
                }
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                this.fViewer.syncJobDone();
                throw throwable;
            }
            {
                Object var3_9 = null;
            }
            this.fViewer.syncJobDone();
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
    }

    protected static class TypeInfoComparator
    implements Comparator {
        private TypeInfoLabelProvider fLabelProvider;
        private TypeInfoFilter fFilter;

        public TypeInfoComparator(TypeInfoLabelProvider typeInfoLabelProvider, TypeInfoFilter typeInfoFilter) {
            this.fLabelProvider = typeInfoLabelProvider;
            this.fFilter = typeInfoFilter;
        }

        public int compare(Object object, Object object2) {
            int n;
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            TypeNameMatch typeNameMatch2 = (TypeNameMatch)object2;
            int n2 = this.getCamelCaseCategory(typeNameMatch);
            if (n2 < (n = this.getCamelCaseCategory(typeNameMatch2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            int n3 = this.compareName(typeNameMatch.getSimpleTypeName(), typeNameMatch2.getSimpleTypeName());
            if (n3 != 0) {
                return n3;
            }
            n3 = this.compareTypeContainerName(typeNameMatch.getTypeContainerName(), typeNameMatch2.getTypeContainerName());
            if (n3 != 0) {
                return n3;
            }
            n2 = this.getElementTypeCategory(typeNameMatch);
            if (n2 < (n = this.getElementTypeCategory(typeNameMatch2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return this.compareContainerName(typeNameMatch, typeNameMatch2);
        }

        private int compareName(String string, String string2) {
            int n = string.compareToIgnoreCase(string2);
            if (n != 0 || string2.length() == 0) {
                return n;
            }
            if (Strings.isLowerCase(string.charAt(0)) && !Strings.isLowerCase(string2.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(string2.charAt(0)) && !Strings.isLowerCase(string.charAt(0))) {
                return -1;
            }
            return string.compareTo(string2);
        }

        private int compareTypeContainerName(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            if (n == 0 && n2 > 0) {
                return -1;
            }
            if (n == 0 && n2 == 0) {
                return 0;
            }
            if (n > 0 && n2 == 0) {
                return 1;
            }
            return this.compareName(string, string2);
        }

        private int compareContainerName(TypeNameMatch typeNameMatch, TypeNameMatch typeNameMatch2) {
            return this.fLabelProvider.getContainerName(typeNameMatch).compareTo(this.fLabelProvider.getContainerName(typeNameMatch2));
        }

        private int getCamelCaseCategory(TypeNameMatch typeNameMatch) {
            if (this.fFilter == null) {
                return 0;
            }
            if (!this.fFilter.isCamelCasePattern()) {
                return 0;
            }
            return this.fFilter.matchesRawNamePattern(typeNameMatch) ? 0 : 1;
        }

        private int getElementTypeCategory(TypeNameMatch typeNameMatch) {
            try {
                if (typeNameMatch.getPackageFragmentRoot().getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
            return 1;
        }
    }

    protected static class TypeInfoLabelProvider {
        private ITypeInfoImageProvider fProviderExtension;
        private TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private Map fLib2Name = new HashMap();
        private String[] fInstallLocations;
        private String[] fVMNames;
        private boolean fFullyQualifyDuplicates;

        public TypeInfoLabelProvider(ITypeInfoImageProvider iTypeInfoImageProvider) {
            this.fProviderExtension = iTypeInfoImageProvider;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = 0;
            while (n < iVMInstallTypeArray.length) {
                this.processVMInstallType(iVMInstallTypeArray[n], arrayList, arrayList2);
                ++n;
            }
            this.fInstallLocations = arrayList.toArray(new String[arrayList.size()]);
            this.fVMNames = arrayList2.toArray(new String[arrayList2.size()]);
        }

        public void setFullyQualifyDuplicates(boolean bl) {
            this.fFullyQualifyDuplicates = bl;
        }

        private void processVMInstallType(IVMInstallType iVMInstallType, List list, List list2) {
            if (iVMInstallType != null) {
                IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
                boolean bl = "macosx".equals(Platform.getOS());
                int n = 0;
                while (n < iVMInstallArray.length) {
                    String string = this.getFormattedLabel(iVMInstallArray[n].getName());
                    LibraryLocation[] libraryLocationArray = iVMInstallArray[n].getLibraryLocations();
                    if (libraryLocationArray != null) {
                        this.processLibraryLocation(libraryLocationArray, string);
                    } else {
                        String string2 = iVMInstallArray[n].getInstallLocation().getAbsolutePath();
                        if (bl && string2.endsWith("/Home")) {
                            string2 = string2.substring(0, string2.length() - "/Home".length() + 1);
                        }
                        list.add(string2);
                        list2.add(string);
                    }
                    ++n;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libraryLocationArray, String string) {
            int n = 0;
            while (n < libraryLocationArray.length) {
                LibraryLocation libraryLocation = libraryLocationArray[n];
                this.fLib2Name.put(libraryLocation.getSystemLibraryPath().toString(), string);
                ++n;
            }
        }

        private String getFormattedLabel(String string) {
            return Messages.format(JavaUIMessages.TypeInfoViewer_library_name_format, string);
        }

        public String getText(Object object) {
            return ((TypeNameMatch)object).getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(typeNameMatch.getSimpleTypeName());
            String string = typeNameMatch.getTypeContainerName();
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            if (string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(JavaUIMessages.TypeInfoViewer_default_package);
            }
            return stringBuffer.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(typeNameMatch.getSimpleTypeName());
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                stringBuffer.append(string);
            }
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            stringBuffer.append(this.getContainerName(typeNameMatch));
            return stringBuffer.toString();
        }

        public String getText(TypeNameMatch typeNameMatch, TypeNameMatch typeNameMatch2, TypeNameMatch typeNameMatch3) {
            String string;
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            String string3 = typeNameMatch2.getSimpleTypeName();
            stringBuffer.append(string3);
            String string4 = this.getTypeContainerName(typeNameMatch2);
            if (typeNameMatch != null) {
                string2 = typeNameMatch.getSimpleTypeName();
                string = this.getTypeContainerName(typeNameMatch);
                if (string4.equals(string)) {
                    if (string3.equals(string2)) {
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(string4);
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(this.getContainerName(typeNameMatch2));
                        return stringBuffer.toString();
                    }
                } else if (string3.equals(string2)) {
                    n = 1;
                }
            }
            if (typeNameMatch3 != null) {
                string2 = typeNameMatch3.getSimpleTypeName();
                string = this.getTypeContainerName(typeNameMatch3);
                if (string4.equals(string)) {
                    if (string3.equals(string2)) {
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(string4);
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(this.getContainerName(typeNameMatch2));
                        return stringBuffer.toString();
                    }
                } else if (string3.equals(string2)) {
                    n = 1;
                }
            }
            if (n > 0) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                stringBuffer.append(string4);
                if (this.fFullyQualifyDuplicates) {
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                    stringBuffer.append(this.getContainerName(typeNameMatch2));
                }
            }
            return stringBuffer.toString();
        }

        public String getQualificationText(TypeNameMatch typeNameMatch) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            }
            stringBuffer.append(this.getContainerName(typeNameMatch));
            return stringBuffer.toString();
        }

        private boolean isInnerType(TypeNameMatch typeNameMatch) {
            return typeNameMatch.getTypeQualifiedName().indexOf(46) != -1;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(typeNameMatch);
                ImageDescriptor imageDescriptor = this.fProviderExtension.getImageDescriptor(this.fAdapter);
                if (imageDescriptor != null) {
                    return imageDescriptor;
                }
            }
            return JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(typeNameMatch), false, typeNameMatch.getModifiers(), false);
        }

        private String getTypeContainerName(TypeNameMatch typeNameMatch) {
            String string = typeNameMatch.getTypeContainerName();
            if (string.length() > 0) {
                return string;
            }
            return JavaUIMessages.TypeInfoViewer_default_package;
        }

        private String getContainerName(TypeNameMatch typeNameMatch) {
            CharSequence charSequence;
            IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
            if (iPackageFragmentRoot.isExternal()) {
                charSequence = iPackageFragmentRoot.getPath().toOSString();
                int n = 0;
                while (n < this.fInstallLocations.length) {
                    if (((String)charSequence).startsWith(this.fInstallLocations[n])) {
                        return this.fVMNames[n];
                    }
                    ++n;
                }
                String string = (String)this.fLib2Name.get(charSequence);
                if (string != null) {
                    return string;
                }
            }
            charSequence = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(iPackageFragmentRoot, 0x30000000000L, (StringBuffer)charSequence);
            return ((StringBuffer)charSequence).toString();
        }
    }
}

