/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDropAdapter
implements DropTargetListener {
    private TransferDropTargetListener[] fListeners;
    private TransferDropTargetListener fCurrentListener;
    private int fOriginalDropType;

    public DelegatingDropAdapter(TransferDropTargetListener[] transferDropTargetListenerArray) {
        Assert.isNotNull((Object)transferDropTargetListenerArray);
        this.fListeners = transferDropTargetListenerArray;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.fOriginalDropType = dropTargetEvent.detail;
        this.updateCurrentListener(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.setCurrentListener(null, dropTargetEvent);
    }

    public void dragOperationChanged(final DropTargetEvent dropTargetEvent) {
        this.fOriginalDropType = dropTargetEvent.detail;
        TransferDropTargetListener transferDropTargetListener = this.getCurrentListener();
        this.updateCurrentListener(dropTargetEvent);
        final TransferDropTargetListener transferDropTargetListener2 = this.getCurrentListener();
        if (transferDropTargetListener2 != null && transferDropTargetListener2 == transferDropTargetListener) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    transferDropTargetListener2.dragOperationChanged(dropTargetEvent);
                }
            });
        }
    }

    public void dragOver(final DropTargetEvent dropTargetEvent) {
        TransferDropTargetListener transferDropTargetListener = this.getCurrentListener();
        this.updateCurrentListener(dropTargetEvent);
        final TransferDropTargetListener transferDropTargetListener2 = this.getCurrentListener();
        if (transferDropTargetListener2 != null && transferDropTargetListener2 == transferDropTargetListener) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    transferDropTargetListener2.dragOver(dropTargetEvent);
                }
            });
        }
    }

    public void drop(final DropTargetEvent dropTargetEvent) {
        this.updateCurrentListener(dropTargetEvent);
        if (this.getCurrentListener() != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().drop(dropTargetEvent);
                }
            });
        }
        this.setCurrentListener(null, dropTargetEvent);
    }

    public void dropAccept(final DropTargetEvent dropTargetEvent) {
        if (this.getCurrentListener() != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dropAccept(dropTargetEvent);
                }
            });
        }
    }

    private TransferDropTargetListener getCurrentListener() {
        return this.fCurrentListener;
    }

    private TransferData getSupportedTransferType(TransferData[] transferDataArray, TransferDropTargetListener transferDropTargetListener) {
        int n = 0;
        while (n < transferDataArray.length) {
            if (transferDropTargetListener.getTransfer().isSupportedType(transferDataArray[n])) {
                return transferDataArray[n];
            }
            ++n;
        }
        return null;
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray = new Transfer[this.fListeners.length];
        int n = 0;
        while (n < this.fListeners.length) {
            transferArray[n] = this.fListeners[n].getTransfer();
            ++n;
        }
        return transferArray;
    }

    private boolean setCurrentListener(TransferDropTargetListener transferDropTargetListener, final DropTargetEvent dropTargetEvent) {
        if (this.fCurrentListener == transferDropTargetListener) {
            return false;
        }
        if (this.fCurrentListener != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragLeave(dropTargetEvent);
                }
            });
        }
        this.fCurrentListener = transferDropTargetListener;
        if (this.fCurrentListener != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragEnter(dropTargetEvent);
                }
            });
        }
        return true;
    }

    private void updateCurrentListener(DropTargetEvent dropTargetEvent) {
        int n = dropTargetEvent.detail;
        dropTargetEvent.detail = this.fOriginalDropType;
        int n2 = 0;
        while (n2 < this.fListeners.length) {
            TransferDropTargetListener transferDropTargetListener = this.fListeners[n2];
            TransferData transferData = this.getSupportedTransferType(dropTargetEvent.dataTypes, transferDropTargetListener);
            if (transferData != null) {
                TransferData transferData2 = dropTargetEvent.currentDataType;
                dropTargetEvent.currentDataType = transferData;
                if (transferDropTargetListener.isEnabled(dropTargetEvent)) {
                    if (!this.setCurrentListener(transferDropTargetListener, dropTargetEvent)) {
                        dropTargetEvent.detail = n;
                    }
                    return;
                }
                dropTargetEvent.currentDataType = transferData2;
            }
            ++n2;
        }
        this.setCurrentListener(null, dropTargetEvent);
        dropTargetEvent.detail = 0;
    }
}

