/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;

public class CodeFormatFix
implements IFix {
    private final ICompilationUnit fCompilationUnit;
    private final TextChange fChange;

    public static IFix createCleanUp(ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) throws CoreException {
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        if (bl) {
            Document document;
            HashMap hashMap = new HashMap(iCompilationUnit.getJavaProject().getOptions(true));
            String string = iCompilationUnit.getBuffer().getContents();
            TextEdit textEdit = CodeFormatterUtil.reformat(8, string, 0, TextUtilities.getDefaultLineDelimiter((IDocument)(document = new Document(string))), hashMap);
            if (textEdit == null || !textEdit.hasChildren()) {
                return null;
            }
            String string2 = MultiFixMessages.CodeFormatFix_description;
            CompilationUnitChange compilationUnitChange = new CompilationUnitChange(string2, iCompilationUnit);
            compilationUnitChange.setEdit(textEdit);
            CategorizedTextEditGroup categorizedTextEditGroup = new CategorizedTextEditGroup(string2, new GroupCategorySet(new GroupCategory(string2, string2, string2)));
            categorizedTextEditGroup.addTextEdit(textEdit);
            compilationUnitChange.addTextEditGroup((TextEditGroup)categorizedTextEditGroup);
            return new CodeFormatFix((TextChange)compilationUnitChange, iCompilationUnit);
        }
        if (bl2 || bl3) {
            Object object;
            MultiTextEdit multiTextEdit;
            block15: {
                try {
                    multiTextEdit = new MultiTextEdit();
                    Document document = new Document(iCompilationUnit.getBuffer().getContents());
                    int n = document.getNumberOfLines();
                    int n2 = 0;
                    while (n2 < n) {
                        object = document.getLineInformation(n2);
                        if (object.getLength() != 0) {
                            int n3 = object.getOffset();
                            int n4 = n3 + object.getLength();
                            int n5 = CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(n3, n4 - 1, document);
                            if (bl2) {
                                if (++n5 < n4) {
                                    multiTextEdit.addChild((TextEdit)new DeleteEdit(n5, n4 - n5));
                                }
                            } else if (bl3 && n5 >= n3) {
                                if (document.getChar(n5) == '*' && CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(n3, n5 - 1, document) < n3) {
                                    ++n5;
                                }
                                if (++n5 < n4) {
                                    multiTextEdit.addChild((TextEdit)new DeleteEdit(n5, n4 - n5));
                                }
                            }
                        }
                        ++n2;
                    }
                    if (multiTextEdit.getChildrenSize() != 0) break block15;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)badLocationException));
                }
            }
            String string = MultiFixMessages.CodeFormatFix_RemoveTrailingWhitespace_changeDescription;
            object = new CompilationUnitChange(string, iCompilationUnit);
            object.setEdit((TextEdit)multiTextEdit);
            CategorizedTextEditGroup categorizedTextEditGroup = new CategorizedTextEditGroup(string, new GroupCategorySet(new GroupCategory(string, string, string)));
            categorizedTextEditGroup.addTextEdit((TextEdit)multiTextEdit);
            object.addTextEditGroup((TextEditGroup)categorizedTextEditGroup);
            return new CodeFormatFix((TextChange)object, iCompilationUnit);
        }
        return null;
    }

    private static int getIndexOfRightMostNoneWhitspaceCharacter(int n, int n2, Document document) throws BadLocationException {
        int n3 = n2;
        while (n3 >= n && Character.isWhitespace(document.getChar(n3))) {
            --n3;
        }
        return n3;
    }

    public CodeFormatFix(TextChange textChange, ICompilationUnit iCompilationUnit) {
        this.fChange = textChange;
        this.fCompilationUnit = iCompilationUnit;
    }

    public TextChange createChange() throws CoreException {
        return this.fChange;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getDescription() {
        return MultiFixMessages.CodeFormatFix_description;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

