/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ControlStatementsCleanUp
extends AbstractCleanUp {
    public ControlStatementsCleanUp(Map map) {
        super(map);
    }

    public ControlStatementsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.use_blocks");
        if (!bl) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_blocks") || this.isEnabled("cleanup.never_use_blocks") || this.isEnabled("cleanup.use_blocks_only_for_return_and_throw");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.use_blocks");
        if (!bl) {
            return null;
        }
        return ControlStatementsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_blocks"), this.isEnabled("cleanup.never_use_blocks"), this.isEnabled("cleanup.use_blocks_only_for_return_and_throw"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            arrayList.add(MultiFixMessages.CodeStyleMultiFix_ConvertSingleStatementInControlBodeyToBlock_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            arrayList.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocks_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            arrayList.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocksWithReturnOrThrow_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            stringBuffer.append("if (obj == null) {\n");
            stringBuffer.append("    throw ('some exception');\n");
            stringBuffer.append("}\n");
            stringBuffer.append("if (ids.length > 0) {\n");
            stringBuffer.append("    alert(ids[0]);\n");
            stringBuffer.append("} else {\n");
            stringBuffer.append("    return;\n");
            stringBuffer.append("}\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            stringBuffer.append("if (obj == null)\n");
            stringBuffer.append("    throw ('some exception');\n");
            stringBuffer.append("\n");
            stringBuffer.append("if (ids.length > 0)\n");
            stringBuffer.append("    alert(ids[0]);\n");
            stringBuffer.append("else\n");
            stringBuffer.append("    return;\n");
            stringBuffer.append("\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            stringBuffer.append("if (obj == null)\n");
            stringBuffer.append("    throw ('some exception');\n");
            stringBuffer.append("\n");
            stringBuffer.append("if (ids.length > 0) {\n");
            stringBuffer.append("    alert(ids[0]);\n");
            stringBuffer.append("} else \n");
            stringBuffer.append("    return;\n");
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("if (obj == null) {\n");
            stringBuffer.append("    throw ('some exception');\n");
            stringBuffer.append("}\n");
            stringBuffer.append("if (ids.length > 0) {\n");
            stringBuffer.append("    alert(ids[0]);\n");
            stringBuffer.append("} else \n");
            stringBuffer.append("    return;\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

