/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.Java50Fix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class Java50CleanUp
extends AbstractCleanUp {
    public Java50CleanUp(Map map) {
        super(map);
    }

    public Java50CleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.add_missing_annotations");
        return bl && this.isEnabled("cleanup.add_missing_override_annotations") || bl && this.isEnabled("cleanup.add_missing_deprecated_annotations") || this.isEnabled("cleanup.use_arguments_for_raw_type_references");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.add_missing_annotations");
        return Java50Fix.createCleanUp(compilationUnit, bl && this.isEnabled("cleanup.add_missing_override_annotations"), bl && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return Java50Fix.createCleanUp(compilationUnit, iProblemLocationArray, this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations"), this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.missingOverrideAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "warning");
        }
        return hashtable;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            arrayList.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            arrayList.add(MultiFixMessages.Java50MultiFix_AddMissingDeprecated_description);
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            arrayList.add(MultiFixMessages.Java50CleanUp_AddTypeParameters_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class E {\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     * @deprecated\n");
        stringBuffer.append("     */\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            stringBuffer.append("    @Deprecated\n");
        }
        stringBuffer.append("    public void foo() {}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("class ESub extends E {\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            stringBuffer.append("    @Override\n");
        }
        stringBuffer.append("    public void foo() {}\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        Java50Fix java50Fix;
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations") && (java50Fix = Java50Fix.createAddOverrideAnnotationFix(compilationUnit, iProblemLocation)) != null) {
            return true;
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations") && (java50Fix = Java50Fix.createAddDeprectatedAnnotation(compilationUnit, iProblemLocation)) != null) {
            return true;
        }
        return this.isEnabled("cleanup.use_arguments_for_raw_type_references") && (java50Fix = Java50Fix.createRawTypeReferenceFix(compilationUnit, iProblemLocation)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int n;
        int n2;
        int n3 = 0;
        IProblem[] iProblemArray = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            n3 += this.getNumberOfProblems(iProblemArray, 67109491);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            n2 = 0;
            while (n2 < iProblemArray.length) {
                n = iProblemArray[n2].getID();
                if (n == 536871540 || n == 536871541 || n == 536871542) {
                    ++n3;
                }
                ++n2;
            }
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            n2 = 0;
            while (n2 < iProblemArray.length) {
                n = iProblemArray[n2].getID();
                if (n == 16777748 || n == 16777788 || n == 16777747) {
                    ++n3;
                }
                ++n2;
            }
        }
        return n3;
    }
}

