/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarManifestWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarOptionsPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public class JarPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarPackageWizard";
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;
    private JarOptionsPage fJarOptionsWizardPage;
    private JarPackageData fJarPackage;
    private JarPackageWizardPage fJarPackageWizardPage;
    private IStructuredSelection fSelection;

    public JarPackageWizard() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings2 == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(iDialogSettings2);
        }
    }

    private void addJavaElement(List list, IJavaElement iJavaElement) {
        if (iJavaElement.getElementType() == 5) {
            list.add(iJavaElement);
        } else if (iJavaElement.getElementType() == 6) {
            list.add(iJavaElement);
        } else if (iJavaElement.getElementType() == 2) {
            list.add(iJavaElement);
        } else if (iJavaElement.getElementType() == 4) {
            if (!JavaModelUtil.getPackageFragmentRoot(iJavaElement).isArchive()) {
                list.add(iJavaElement);
            }
        } else if (iJavaElement.getElementType() == 3) {
            if (!((IPackageFragmentRoot)iJavaElement).isArchive()) {
                list.add(iJavaElement);
            }
        } else {
            IOpenable iOpenable = iJavaElement.getOpenable();
            if (iOpenable instanceof ICompilationUnit) {
                list.add(((ICompilationUnit)iOpenable).getPrimary());
            } else if (iOpenable instanceof IClassFile && !JavaModelUtil.getPackageFragmentRoot(iJavaElement).isArchive()) {
                list.add(iOpenable);
            }
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarPackageWizardPage = new JarPackageWizardPage(this.fJarPackage, this.fSelection);
        this.addPage(this.fJarPackageWizardPage);
        this.fJarOptionsWizardPage = new JarOptionsPage(this.fJarPackage);
        this.addPage(this.fJarOptionsWizardPage);
        this.addPage(new JarManifestWizardPage(this.fJarPackage));
    }

    private void addProject(List list, IProject iProject) {
        try {
            if (iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                list.add(JavaCore.create((IProject)iProject));
            }
        }
        catch (CoreException coreException) {}
    }

    private void addResource(List list, IResource iResource) {
        IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
        if (iJavaElement != null && iJavaElement.exists() && iJavaElement.getElementType() == 5) {
            list.add(iJavaElement);
        } else {
            list.add(iResource);
        }
    }

    protected boolean executeExportOperation(IJarExportRunnable iJarExportRunnable) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)iJarExportRunnable);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() == null) break block4;
                ExceptionHandler.handle(invocationTargetException, this.getShell(), JarPackagerMessages.JarPackageWizard_jarExportError_title, JarPackagerMessages.JarPackageWizard_jarExportError_message);
                return false;
            }
        }
        IStatus iStatus = iJarExportRunnable.getStatus();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.JarPackageWizard_jarExport_title, null, (IStatus)iStatus);
            return !iStatus.matches(4);
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fJarPackageWizardPage && !this.fJarPackage.isRefactoringAware()) {
            return this.fJarOptionsWizardPage;
        }
        return super.getNextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fJarOptionsWizardPage && !this.fJarPackage.isRefactoringAware()) {
            return this.fJarPackageWizardPage;
        }
        return super.getPreviousPage(iWizardPage);
    }

    protected IStructuredSelection getValidSelection() {
        ISelection iSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList arrayList = new ArrayList(iStructuredSelection.size());
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof IProject) {
                    this.addProject(arrayList, (IProject)e);
                    continue;
                }
                if (e instanceof IResource) {
                    this.addResource(arrayList, (IResource)e);
                    continue;
                }
                if (!(e instanceof IJavaElement)) continue;
                this.addJavaElement(arrayList, (IJavaElement)e);
            }
            return new StructuredSelection(arrayList);
        }
        return StructuredSelection.EMPTY;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fSelection = this.getValidSelection();
        this.fJarPackage = new JarPackageData();
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, JarPackageData jarPackageData) {
        Assert.isNotNull((Object)iWorkbench);
        Assert.isNotNull((Object)jarPackageData);
        this.fJarPackage = jarPackageData;
        this.setInitializeFromJarPackage(true);
        this.fSelection = new StructuredSelection(this.fJarPackage.getElements());
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray;
        this.fJarPackage.setElements(this.fJarPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(this.fJarPackage.createJarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            iWizardPageArray = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings = iWizardPageArray.getSection(DIALOG_SETTINGS_KEY);
            iDialogSettings = iWizardPageArray.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(iDialogSettings);
        }
        iWizardPageArray = this.getPages();
        int n = 0;
        while (n < this.getPageCount()) {
            IWizardPage iWizardPage = iWizardPageArray[n];
            if (iWizardPage instanceof IJarPackageWizardPage) {
                ((IJarPackageWizardPage)iWizardPage).finish();
            }
            ++n;
        }
        return true;
    }

    void setInitializeFromJarPackage(boolean bl) {
        this.fInitializeFromJarPackage = bl;
    }
}

