/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavadocLinkRef {
    private final IJavaProject fProject;
    private final IPath fContainerPath;
    private IClasspathEntry fClasspathEntry;

    public JavadocLinkRef(IPath iPath, IClasspathEntry iClasspathEntry, IJavaProject iJavaProject) {
        this.fContainerPath = iPath;
        this.fProject = iJavaProject;
        this.fClasspathEntry = iClasspathEntry;
    }

    public JavadocLinkRef(IJavaProject iJavaProject) {
        this(null, null, iJavaProject);
    }

    public boolean isProjectRef() {
        return this.fClasspathEntry == null;
    }

    public IPath getFullPath() {
        return this.isProjectRef() ? this.fProject.getPath() : this.fClasspathEntry.getPath();
    }

    public URL getURL() {
        if (this.isProjectRef()) {
            return JavaUI.getProjectJavadocLocation(this.fProject);
        }
        return JavaUI.getLibraryJavadocLocation(this.fClasspathEntry);
    }

    public void setURL(URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.isProjectRef()) {
            JavaUI.setProjectJavadocLocation(this.fProject, uRL);
        } else {
            CPListElement cPListElement = CPListElement.createFromExisting(this.fClasspathEntry, this.fProject);
            String string = uRL != null ? uRL.toExternalForm() : null;
            cPListElement.setAttribute("javadoc_location", string);
            String[] stringArray = new String[]{"javadoc_location"};
            BuildPathSupport.modifyClasspathEntry(null, cPListElement.getClasspathEntry(), stringArray, this.fProject, this.fContainerPath, iProgressMonitor);
            this.fClasspathEntry = cPListElement.getClasspathEntry();
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            JavadocLinkRef javadocLinkRef = (JavadocLinkRef)object;
            if (!this.fProject.equals(javadocLinkRef.fProject) || this.isProjectRef() != javadocLinkRef.isProjectRef()) {
                return false;
            }
            if (!this.isProjectRef()) {
                return !this.fClasspathEntry.equals(javadocLinkRef.fClasspathEntry);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.isProjectRef()) {
            return this.fProject.hashCode();
        }
        return this.fProject.hashCode() + this.fClasspathEntry.hashCode();
    }
}

