/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompoundEditListener;

public final class CompoundEditExitStrategy {
    private final String[] fCommandIds;
    private final EventListener fEventListener = new EventListener();
    private final ListenerList fListenerList = new ListenerList(1);
    private ITextViewer fViewer;
    private StyledText fWidgetEventSource;
    static /* synthetic */ Class class$0;

    public CompoundEditExitStrategy(String string) {
        if (string == null) {
            throw new NullPointerException("commandId");
        }
        this.fCommandIds = new String[]{string};
    }

    public CompoundEditExitStrategy(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new NullPointerException("commandIds[" + n + "]");
            }
            ++n;
        }
        this.fCommandIds = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.fCommandIds, 0, stringArray.length);
    }

    public void arm(ITextViewer iTextViewer) {
        this.disarm();
        if (iTextViewer == null) {
            throw new NullPointerException("editor");
        }
        this.fViewer = iTextViewer;
        this.addListeners(this.fViewer);
    }

    public void disarm() {
        if (this.isInstalled()) {
            this.removeListeners(this.fViewer);
            this.fViewer = null;
        }
    }

    private void addListeners(ITextViewer iTextViewer) {
        ICommandService iCommandService;
        this.fWidgetEventSource = iTextViewer.getTextWidget();
        if (this.fWidgetEventSource != null) {
            this.fWidgetEventSource.addVerifyKeyListener((VerifyKeyListener)this.fEventListener);
            this.fWidgetEventSource.addMouseListener((MouseListener)this.fEventListener);
            this.fWidgetEventSource.addFocusListener((FocusListener)this.fEventListener);
        }
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCommandService = (ICommandService)iWorkbench.getAdapter((Class)clazz)) != null) {
            iCommandService.addExecutionListener((IExecutionListener)this.fEventListener);
        }
    }

    private void removeListeners(ITextViewer iTextViewer) {
        ICommandService iCommandService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCommandService = (ICommandService)iWorkbench.getAdapter((Class)clazz)) != null) {
            iCommandService.removeExecutionListener((IExecutionListener)this.fEventListener);
        }
        if (this.fWidgetEventSource != null) {
            this.fWidgetEventSource.removeFocusListener((FocusListener)this.fEventListener);
            this.fWidgetEventSource.removeMouseListener((MouseListener)this.fEventListener);
            this.fWidgetEventSource.removeVerifyKeyListener((VerifyKeyListener)this.fEventListener);
            this.fWidgetEventSource = null;
        }
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    private void fireEndCompoundEdit() {
        this.disarm();
        Object[] objectArray = this.fListenerList.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICompoundEditListener iCompoundEditListener = (ICompoundEditListener)objectArray[n];
            try {
                iCompoundEditListener.endCompoundEdit();
            }
            catch (Exception exception) {
                JavaPlugin.log(exception);
            }
            ++n;
        }
    }

    public void addCompoundListener(ICompoundEditListener iCompoundEditListener) {
        this.fListenerList.add((Object)iCompoundEditListener);
    }

    public void removeCompoundListener(ICompoundEditListener iCompoundEditListener) {
        this.fListenerList.remove((Object)iCompoundEditListener);
    }

    private final class EventListener
    implements MouseListener,
    FocusListener,
    VerifyKeyListener,
    IExecutionListener {
        private EventListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            CompoundEditExitStrategy.this.fireEndCompoundEdit();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            CompoundEditExitStrategy.this.fireEndCompoundEdit();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            CompoundEditExitStrategy.this.fireEndCompoundEdit();
        }

        public void notHandled(String string, NotHandledException notHandledException) {
        }

        public void postExecuteFailure(String string, ExecutionException executionException) {
        }

        public void postExecuteSuccess(String string, Object object) {
        }

        public void preExecute(String string, ExecutionEvent executionEvent) {
            int n = 0;
            while (n < CompoundEditExitStrategy.this.fCommandIds.length) {
                if (string.equals(CompoundEditExitStrategy.this.fCommandIds[n])) {
                    return;
                }
                ++n;
            }
            CompoundEditExitStrategy.this.fireEndCompoundEdit();
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            int n = SWT.MODIFIER_MASK & 0xFFFDFFFF;
            if ((verifyEvent.keyCode & SWT.MODIFIER_MASK) == 0 && (verifyEvent.stateMask & n) == 0) {
                CompoundEditExitStrategy.this.fireEndCompoundEdit();
            }
        }
    }
}

