/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class JavaEditorErrorTickUpdater
implements IProblemChangedListener {
    private JavaEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;
    static /* synthetic */ Class class$0;

    public JavaEditorErrorTickUpdater(JavaEditor javaEditor) {
        Assert.isNotNull((Object)javaEditor);
        this.fJavaEditor = javaEditor;
        this.fLabelProvider = new JavaUILabelProvider(0L, 2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        JavaPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] iResourceArray, boolean bl) {
        if (!bl) {
            return;
        }
        IEditorInput iEditorInput = this.fJavaEditor.getEditorInput();
        if (iEditorInput != null) {
            IJavaElement iJavaElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iEditorInput.getAdapter((Class)clazz)) != null) {
                IResource iResource = iJavaElement.getResource();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n].equals((Object)iResource)) {
                        this.updateEditorImage(iJavaElement);
                    }
                    ++n;
                }
            }
        }
    }

    public void updateEditorImage(IJavaElement iJavaElement) {
        Image image = this.fJavaEditor.getTitleImage();
        if (image == null) {
            return;
        }
        Image image2 = iJavaElement instanceof ICompilationUnit && !iJavaElement.getJavaProject().isOnClasspath(iJavaElement) ? this.fLabelProvider.getImage(iJavaElement.getResource()) : this.fLabelProvider.getImage(iJavaElement);
        if (image != image2) {
            this.postImageChange(image2);
        }
    }

    private void postImageChange(final Image image) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(image);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

