/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompoundEditExitStrategy;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompoundEditListener;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;

public class JavaMoveLinesAction
extends TextEditorAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final SharedState fSharedState;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static JavaMoveLinesAction[] createMoveCopyActionSet(ResourceBundle resourceBundle, CompilationUnitEditor compilationUnitEditor) {
        SharedState sharedState = new SharedState(compilationUnitEditor);
        JavaMoveLinesAction[] javaMoveLinesActionArray = new JavaMoveLinesAction[]{new JavaMoveLinesAction(resourceBundle, "Editor.MoveLinesUp.", true, false, sharedState), new JavaMoveLinesAction(resourceBundle, "Editor.MoveLinesDown.", false, false, sharedState), new JavaMoveLinesAction(resourceBundle, "Editor.CopyLineUp.", true, true, sharedState), new JavaMoveLinesAction(resourceBundle, "Editor.CopyLineDown.", false, true, sharedState)};
        return javaMoveLinesActionArray;
    }

    public void setEditor(ITextEditor iTextEditor) {
        Assert.isTrue((boolean)(iTextEditor instanceof CompilationUnitEditor));
        super.setEditor(iTextEditor);
        if (this.fSharedState != null) {
            this.fSharedState.fEditor = (CompilationUnitEditor)iTextEditor;
        }
    }

    private JavaMoveLinesAction(ResourceBundle resourceBundle, String string, boolean bl, boolean bl2, SharedState sharedState) {
        super(resourceBundle, string, (ITextEditor)sharedState.fEditor);
        this.fUpwards = bl;
        this.fCopy = bl2;
        this.fSharedState = sharedState;
        this.update();
    }

    private boolean containedByVisibleRegion(ITextSelection iTextSelection, ISourceViewer iSourceViewer) {
        block7: {
            int n;
            IDocument iDocument;
            int n2;
            block8: {
                int n3;
                IRegion iRegion;
                block5: {
                    int n4;
                    block6: {
                        n4 = iTextSelection.getOffset();
                        n2 = n4 + iTextSelection.getLength();
                        iDocument = iSourceViewer.getDocument();
                        iRegion = iSourceViewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)iSourceViewer).getModelCoverage() : iSourceViewer.getVisibleRegion();
                        n3 = iRegion.getOffset();
                        try {
                            if (n3 <= n4) break block5;
                            if (iDocument.getLineOfOffset(n3) == iTextSelection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(iDocument.get(n4, n3 - n4))) break block5;
                    this.showStatus();
                    return false;
                }
                n = n3 + iRegion.getLength();
                if (n >= n2) break block7;
                if (iDocument.getLineOfOffset(n) == iTextSelection.getEndLine()) break block8;
                return false;
            }
            if (this.isWhitespace(iDocument.get(n, n2 - n))) break block7;
            this.showStatus();
            return false;
        }
        return true;
    }

    private ITextSelection getMovingSelection(IDocument iDocument, ITextSelection iTextSelection, ISourceViewer iSourceViewer) throws BadLocationException {
        int n = iDocument.getLineOffset(iTextSelection.getStartLine());
        int n2 = iTextSelection.getEndLine();
        int n3 = iDocument.getLineOffset(n2) + iDocument.getLineLength(n2);
        String string = iDocument.getLineDelimiter(n2);
        if (string != null) {
            n3 -= string.length();
        }
        return new TextSelection(iDocument, n, n3 - n);
    }

    private ITextSelection getSkippedLine(IDocument iDocument, ITextSelection iTextSelection) {
        int n;
        int n2 = n = this.fUpwards ? iTextSelection.getStartLine() - 1 : iTextSelection.getEndLine() + 1;
        if (n > iDocument.getNumberOfLines() || !this.fCopy && (n < 0 || n == iDocument.getNumberOfLines())) {
            return null;
        }
        try {
            if (this.fCopy && n == -1) {
                n = 0;
            }
            IRegion iRegion = iDocument.getLineInformation(n);
            return new TextSelection(iDocument, iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithEvent(Event event) {
        if (this.fSharedState.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer iSourceViewer = this.fSharedState.fEditor.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        Point point = iSourceViewer.getSelectedRange();
        if (point == null) {
            return;
        }
        TextSelection textSelection = new TextSelection(iDocument, point.x, point.y);
        ITextSelection iTextSelection = this.getSkippedLine(iDocument, (ITextSelection)textSelection);
        if (iTextSelection == null) {
            return;
        }
        try {
            block24: {
                block22: {
                    try {
                        int n;
                        String string;
                        ITextSelection iTextSelection2 = this.getMovingSelection(iDocument, (ITextSelection)textSelection, iSourceViewer);
                        if (!this.containedByVisibleRegion(iTextSelection2, iSourceViewer)) break block22;
                        if (!this.containedByVisibleRegion(iTextSelection, iSourceViewer)) {
                            break block22;
                        }
                        String string2 = iTextSelection2.getText();
                        String string3 = iTextSelection.getText();
                        if (string2 == null || string3 == null || iDocument.getLength() == 0) break block22;
                        if (this.fUpwards) {
                            String string4 = iDocument.getLineDelimiter(iTextSelection.getEndLine());
                            if (this.fCopy) {
                                string4 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                                string = String.valueOf(string2) + string4;
                                n = iTextSelection2.getOffset();
                            } else {
                                Assert.isNotNull((Object)string4);
                                string = String.valueOf(string2) + string4 + string3;
                                n = iTextSelection.getOffset();
                            }
                        } else {
                            String string5 = iDocument.getLineDelimiter(iTextSelection2.getEndLine());
                            if (this.fCopy) {
                                if (string5 == null) {
                                    string5 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                                    string = String.valueOf(string5) + string2;
                                } else {
                                    string = String.valueOf(string2) + string5;
                                }
                                n = iTextSelection.getOffset();
                            } else {
                                Assert.isNotNull((Object)string5);
                                string = String.valueOf(string3) + string5 + string2;
                                n = iTextSelection2.getOffset();
                            }
                        }
                        int n2 = this.fCopy ? 0 : string.length();
                        ILineRange iLineRange = this.getLineRange(iDocument, iTextSelection2);
                        if (this.fCopy) {
                            this.fSharedState.endCompoundEdit();
                        }
                        this.fSharedState.beginCompoundEdit();
                        this.fSharedState.fIsChanging = true;
                        iDocument.replace(n, n2, string);
                        Object object = this.fUpwards && this.fCopy ? iLineRange : (this.fUpwards ? new LineRange(iLineRange.getStartLine() - 1, iLineRange.getNumberOfLines()) : (this.fCopy ? new LineRange(iLineRange.getStartLine() + iLineRange.getNumberOfLines(), iLineRange.getNumberOfLines()) : new LineRange(iLineRange.getStartLine() + 1, iLineRange.getNumberOfLines())));
                        this.fSharedState.fResult = IndentUtil.indentLines(iDocument, object, this.getProject(), this.fSharedState.fResult);
                        IRegion iRegion = this.getRegion(iDocument, (ILineRange)object);
                        this.selectAndReveal((ITextViewer)iSourceViewer, iRegion.getOffset(), iRegion.getLength());
                        break block24;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                Object var18_9 = null;
                this.fSharedState.fIsChanging = false;
                if (!this.fCopy) return;
                this.fSharedState.endCompoundEdit();
                return;
            }
            Object var18_11 = null;
            this.fSharedState.fIsChanging = false;
            if (!this.fCopy) return;
            this.fSharedState.endCompoundEdit();
            return;
        }
        catch (Throwable throwable) {
            Object var18_10 = null;
            this.fSharedState.fIsChanging = false;
            if (!this.fCopy) throw throwable;
            this.fSharedState.endCompoundEdit();
            throw throwable;
        }
    }

    private IJavaProject getProject() {
        IEditorInput iEditorInput = this.fSharedState.fEditor.getEditorInput();
        ICompilationUnit iCompilationUnit = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
        if (iCompilationUnit != null) {
            return iCompilationUnit.getJavaProject();
        }
        return null;
    }

    private ILineRange getLineRange(IDocument iDocument, ITextSelection iTextSelection) throws BadLocationException {
        int n = iTextSelection.getOffset();
        int n2 = iDocument.getLineOfOffset(n);
        int n3 = n + iTextSelection.getLength();
        int n4 = iDocument.getLineOfOffset(n3);
        int n5 = n4 - n2 + 1;
        return new LineRange(n2, n5);
    }

    private IRegion getRegion(IDocument iDocument, ILineRange iLineRange) throws BadLocationException {
        int n = iLineRange.getStartLine();
        int n2 = iDocument.getLineOffset(n);
        int n3 = iLineRange.getNumberOfLines();
        if (n3 < 1) {
            return new Region(n2, 0);
        }
        int n4 = n + n3 - 1;
        int n5 = iDocument.getLineOffset(n4) + iDocument.getLineLength(n4);
        return new Region(n2, n5 - n2);
    }

    private void selectAndReveal(ITextViewer iTextViewer, int n, int n2) {
        iTextViewer.setSelectedRange(n + n2, -n2);
        StyledText styledText = iTextViewer.getTextWidget();
        if (styledText != null) {
            styledText.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine iEditorStatusLine;
        CompilationUnitEditor compilationUnitEditor = this.fSharedState.fEditor;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)compilationUnitEditor.getAdapter(clazz)) == null) {
            return;
        }
        iEditorStatusLine.setMessage(false, JavaEditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    private static final class SharedState {
        public CompilationUnitEditor fEditor;
        public IndentUtil.IndentResult fResult = null;
        boolean fIsChanging = false;
        private boolean fEditInProgress = false;
        private final CompoundEditExitStrategy fExitStrategy;

        public SharedState(CompilationUnitEditor compilationUnitEditor) {
            this.fEditor = compilationUnitEditor;
            this.fExitStrategy = new CompoundEditExitStrategy(new String[]{"org.eclipse.ui.edit.text.moveLineUp", "org.eclipse.ui.edit.text.moveLineDown", "org.eclipse.ui.edit.text.copyLineUp", "org.eclipse.ui.edit.text.copyLineDown"});
            this.fExitStrategy.addCompoundListener(new ICompoundEditListener(this){
                final /* synthetic */ SharedState this$1;
                {
                    this.this$1 = sharedState;
                }

                public void endCompoundEdit() {
                    this.this$1.endCompoundEdit();
                }
            });
        }

        public void beginCompoundEdit() {
            IRewriteTarget iRewriteTarget;
            if (this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fEditInProgress = true;
            this.fExitStrategy.arm((ITextViewer)this.fEditor.getViewer());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iRewriteTarget = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                iRewriteTarget.beginCompoundChange();
            }
        }

        public void endCompoundEdit() {
            IRewriteTarget iRewriteTarget;
            if (!this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fExitStrategy.disarm();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iRewriteTarget = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                iRewriteTarget.endCompoundChange();
            }
            this.fResult = null;
            this.fEditInProgress = false;
        }
    }
}

