/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SpecificContentAssistExecutor;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;

final class SpecificContentAssistAction
extends Action
implements IUpdate {
    private final CompletionProposalCategory fCategory;
    private final SpecificContentAssistExecutor fExecutor = new SpecificContentAssistExecutor(CompletionProposalComputerRegistry.getDefault());
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    public SpecificContentAssistAction(CompletionProposalCategory completionProposalCategory) {
        this.fCategory = completionProposalCategory;
        this.setText(completionProposalCategory.getName());
        this.setImageDescriptor(completionProposalCategory.getImageDescriptor());
        this.setActionDefinitionId("org.eclipse.wst.jsdt.ui.specific_content_assist.command");
    }

    public void run() {
        ITextEditor iTextEditor = this.getActiveEditor();
        if (iTextEditor == null) {
            return;
        }
        this.fExecutor.invokeContentAssist(iTextEditor, this.fCategory.getId());
    }

    private ITextEditor getActiveEditor() {
        return this.fEditor;
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        JavaEditor javaEditor = iEditorPart instanceof JavaEditor ? (JavaEditor)iEditorPart : null;
        this.fEditor = javaEditor;
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }

    private boolean computeEnablement(ITextEditor iTextEditor) {
        ITextOperationTarget iTextOperationTarget;
        boolean bl;
        if (iTextEditor == null) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl2 = bl = (iTextOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz)) != null && iTextOperationTarget.canDoOperation(13);
        if (!bl) {
            return false;
        }
        ISelection iSelection = iTextEditor.getSelectionProvider().getSelection();
        return this.isValidSelection(iSelection);
    }

    private boolean isValidSelection(ISelection iSelection) {
        String string;
        if (!(iSelection instanceof ITextSelection)) {
            return false;
        }
        int n = ((ITextSelection)iSelection).getOffset();
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return false;
        }
        try {
            string = TextUtilities.getContentType((IDocument)iDocument, (String)"___java_partitioning", (int)n, (boolean)true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return this.fCategory.hasComputers(string);
    }

    private IDocument getDocument() {
        Assert.isTrue((this.fEditor != null ? 1 : 0) != 0);
        IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
        if (iDocumentProvider == null) {
            return null;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput());
        return iDocument;
    }

    public void update() {
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }
}

