/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.navigator.CommonLayoutActionGroup;

public class JavaNavigatorViewActionProvider
extends CommonActionProvider {
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String TAG_LAYOUT = "org.eclipse.wst.jsdt.internal.ui.navigator.layout";
    private IExtensionStateModel fStateModel;
    private CommonLayoutActionGroup fLayoutActionGroup;
    private ICommonActionExtensionSite fExtensionSite;
    private String fExtensionId;
    private IActionBars fActionBars;
    private boolean fEnabled = false;
    private IExtensionActivationListener fMenuUpdater = new IExtensionActivationListener(){

        public void onExtensionActivation(String string, String[] stringArray, boolean bl) {
            int n;
            if (JavaNavigatorViewActionProvider.this.fExtensionSite != null && JavaNavigatorViewActionProvider.this.fActionBars != null && (n = Arrays.binarySearch(stringArray, JavaNavigatorViewActionProvider.this.fExtensionId)) > -1) {
                if (this.isMyViewer(string)) {
                    if (this.wasEnabled(bl)) {
                        JavaNavigatorViewActionProvider.this.fLayoutActionGroup.fillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                    } else if (this.wasDisabled(bl)) {
                        JavaNavigatorViewActionProvider.this.fLayoutActionGroup.unfillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                    }
                }
                JavaNavigatorViewActionProvider.this.fEnabled = bl;
            }
        }

        private boolean isMyViewer(String string) {
            String string2 = JavaNavigatorViewActionProvider.this.fExtensionSite.getViewSite().getId();
            return string2 != null && string2.equals(string);
        }

        private boolean wasDisabled(boolean bl) {
            return JavaNavigatorViewActionProvider.this.fEnabled && !bl;
        }

        private boolean wasEnabled(boolean bl) {
            return !JavaNavigatorViewActionProvider.this.fEnabled && bl;
        }
    };

    public void fillActionBars(IActionBars iActionBars) {
        this.fActionBars = iActionBars;
        this.fLayoutActionGroup.fillActionBars(iActionBars);
    }

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        this.fExtensionSite = iCommonActionExtensionSite;
        this.fStateModel = this.fExtensionSite.getExtensionStateModel();
        this.fLayoutActionGroup = new CommonLayoutActionGroup(this.fExtensionSite.getStructuredViewer(), this.fStateModel);
        INavigatorActivationService iNavigatorActivationService = this.fExtensionSite.getContentService().getActivationService();
        iNavigatorActivationService.addExtensionActivationListener(this.fMenuUpdater);
        this.fExtensionId = this.fExtensionSite.getExtensionId();
        this.fEnabled = true;
    }

    public void dispose() {
        super.dispose();
        this.fExtensionSite.getContentService().getActivationService().removeExtensionActivationListener(this.fMenuUpdater);
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
    }

    public void restoreState(IMemento iMemento) {
        boolean bl = false;
        Integer n = null;
        if (iMemento != null) {
            n = iMemento.getInteger(TAG_LAYOUT);
        }
        if (n == null) {
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            n = new Integer(iPreferenceStore.getInt(TAG_LAYOUT));
        }
        if (n == 2) {
            bl = true;
        } else if (n == 1) {
            bl = false;
        }
        this.fStateModel.setBooleanProperty("isLayoutFlat", bl);
        this.fLayoutActionGroup.setFlatLayout(bl);
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fStateModel.getBooleanProperty("isLayoutFlat")) {
            iPreferenceStore.setValue(TAG_LAYOUT, 2);
        } else {
            iPreferenceStore.setValue(TAG_LAYOUT, 1);
        }
    }
}

