/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

class GotoPackageAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoPackageAction(PackageExplorerPart packageExplorerPart) {
        super(PackagesMessages.GotoPackage_action_label);
        this.setDescription(PackagesMessages.GotoPackage_action_description);
        this.fPackageExplorer = packageExplorerPart;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_package_action");
    }

    public void run() {
        try {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            SelectionDialog selectionDialog = this.createAllPackagesDialog(shell);
            selectionDialog.setTitle(this.getDialogTitle());
            selectionDialog.setMessage(PackagesMessages.GotoPackage_dialog_message);
            selectionDialog.open();
            Object[] objectArray = selectionDialog.getResult();
            if (objectArray != null && objectArray.length == 1) {
                this.gotoPackage((IPackageFragment)objectArray[0]);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private SelectionDialog createAllPackagesDialog(Shell shell) throws JavaModelException {
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        int n = 8;
        PackageSelectionDialog packageSelectionDialog = new PackageSelectionDialog(shell, (IRunnableContext)iProgressService, n, iJavaSearchScope);
        packageSelectionDialog.setFilter("");
        packageSelectionDialog.setIgnoreCase(false);
        packageSelectionDialog.setMultipleSelection(false);
        return packageSelectionDialog;
    }

    private void gotoPackage(IPackageFragment iPackageFragment) {
        this.fPackageExplorer.selectReveal((ISelection)new StructuredSelection((Object)iPackageFragment));
        if (!iPackageFragment.equals(this.getSelectedElement())) {
            MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, iPackageFragment.getElementName()));
        }
    }

    private Object getSelectedElement() {
        return ((IStructuredSelection)this.fPackageExplorer.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoPackage_dialog_title;
    }
}

