/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

public class GotoResourceAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    public GotoResourceAction(PackageExplorerPart packageExplorerPart) {
        this.setText(PackagesMessages.GotoResource_action_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_resource_action");
        this.fPackageExplorer = packageExplorerPart;
    }

    public void run() {
        TreeViewer treeViewer = this.fPackageExplorer.getTreeViewer();
        GotoResourceDialog gotoResourceDialog = new GotoResourceDialog(this.fPackageExplorer.getSite().getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), (StructuredViewer)treeViewer);
        gotoResourceDialog.open();
        Object[] objectArray = gotoResourceDialog.getResult();
        if (objectArray == null || objectArray.length == 0 || !(objectArray[0] instanceof IResource)) {
            return;
        }
        StructuredSelection structuredSelection = null;
        IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)objectArray[0]));
        structuredSelection = iJavaElement != null && iJavaElement.exists() ? new StructuredSelection((Object)iJavaElement) : new StructuredSelection(objectArray[0]);
        treeViewer.setSelection((ISelection)structuredSelection, true);
    }

    private static class GotoResourceDialog
    extends FilteredResourcesSelectionDialog {
        private IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

        public GotoResourceDialog(Shell shell, IContainer iContainer, StructuredViewer structuredViewer) {
            super(shell, false, iContainer, 7);
            this.setTitle(PackagesMessages.GotoResource_dialog_title);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.goto_resource_dialog");
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new GotoResourceFilter();
        }

        private class GotoResourceFilter
        extends FilteredResourcesSelectionDialog.ResourceFilter {
            private GotoResourceFilter() {
                super((FilteredResourcesSelectionDialog)GotoResourceDialog.this);
            }

            public boolean matchItem(Object object) {
                IResource iResource = (IResource)object;
                return super.matchItem(object) && this.select(iResource);
            }

            private boolean select(IResource iResource) {
                IProject iProject = iResource.getProject();
                try {
                    if (iProject.getNature("org.eclipse.wst.jsdt.core.jsNature") != null) {
                        return GotoResourceDialog.this.fJavaModel.contains(iResource);
                    }
                }
                catch (CoreException coreException) {}
                return true;
            }

            public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
                if (!super.equalsFilter(itemsFilter)) {
                    return false;
                }
                return itemsFilter instanceof GotoResourceFilter;
            }
        }
    }
}

