/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectAllAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.CollapseAllAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.GotoPackageAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.GotoRequiredProjectAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.GotoResourceAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.GotoTypeAction;
import org.eclipse.wst.jsdt.internal.ui.packageview.LayoutActionGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesFrameSource;
import org.eclipse.wst.jsdt.internal.ui.packageview.ToggleLinkingAction;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ViewActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.BuildActionGroup;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.ImportActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.NavigateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenProjectAction;
import org.eclipse.wst.jsdt.ui.actions.ProjectActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

class PackageExplorerActionGroup
extends CompositeActionGroup {
    private PackageExplorerPart fPart;
    private FrameList fFrameList;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private GotoTypeAction fGotoTypeAction;
    private GotoPackageAction fGotoPackageAction;
    private GotoResourceAction fGotoResourceAction;
    private CollapseAllAction fCollapseAllAction;
    private SelectAllAction fSelectAllAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private RefactorActionGroup fRefactorActionGroup;
    private NavigateActionGroup fNavigateActionGroup;
    private ViewActionGroup fViewActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private IAction fGotoRequiredProjectAction;
    private ProjectActionGroup fProjectActionGroup;

    public PackageExplorerActionGroup(PackageExplorerPart packageExplorerPart) {
        this.fPart = packageExplorerPart;
        TreeViewer treeViewer = packageExplorerPart.getTreeViewer();
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PackageExplorerActionGroup.this.doWorkingSetChanged(propertyChangeEvent);
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = this.fPart.getSite();
        ActionGroup[] actionGroupArray = new ActionGroup[13];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)iWorkbenchPartSite);
        this.fNavigateActionGroup = new NavigateActionGroup(this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        actionGroupArray[2] = new CCPActionGroup(this.fPart);
        actionGroupArray[3] = new GenerateBuildPathActionGroup(this.fPart);
        actionGroupArray[4] = new GenerateActionGroup(this.fPart);
        this.fRefactorActionGroup = new RefactorActionGroup(this.fPart);
        actionGroupArray[5] = this.fRefactorActionGroup;
        actionGroupArray[6] = new ImportActionGroup(this.fPart);
        actionGroupArray[7] = new BuildActionGroup(this.fPart);
        actionGroupArray[8] = new JavaSearchActionGroup(this.fPart);
        this.fProjectActionGroup = new ProjectActionGroup(this.fPart);
        actionGroupArray[9] = this.fProjectActionGroup;
        this.fViewActionGroup = new ViewActionGroup(this.fPart.getRootMode(), iPropertyChangeListener, iWorkbenchPartSite);
        actionGroupArray[10] = this.fViewActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.fPart, (StructuredViewer)treeViewer);
        actionGroupArray[11] = this.fCustomFiltersActionGroup;
        actionGroupArray[12] = new LayoutActionGroup(this.fPart);
        this.setGroups(actionGroupArray);
        this.fViewActionGroup.fillFilters((StructuredViewer)treeViewer);
        PackagesFrameSource packagesFrameSource = new PackagesFrameSource(this.fPart);
        this.fFrameList = new FrameList((IFrameSource)packagesFrameSource);
        packagesFrameSource.connectTo(this.fFrameList);
        this.fZoomInAction = new GoIntoAction(this.fFrameList);
        this.fBackAction = new BackAction(this.fFrameList);
        this.fForwardAction = new ForwardAction(this.fFrameList);
        this.fUpAction = new UpAction(this.fFrameList);
        this.fGotoTypeAction = new GotoTypeAction(this.fPart);
        this.fGotoPackageAction = new GotoPackageAction(this.fPart);
        this.fGotoResourceAction = new GotoResourceAction(this.fPart);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
        this.fToggleLinkingAction = new ToggleLinkingAction(this.fPart);
        this.fGotoRequiredProjectAction = new GotoRequiredProjectAction(this.fPart);
        this.fSelectAllAction = new SelectAllAction(this.fPart.getTreeViewer());
    }

    public void dispose() {
        super.dispose();
    }

    void restoreFilterAndSorterState(IMemento iMemento) {
        this.fViewActionGroup.restoreState(iMemento);
        this.fCustomFiltersActionGroup.restoreState(iMemento);
    }

    void saveFilterAndSorterState(IMemento iMemento) {
        this.fViewActionGroup.saveState(iMemento);
        this.fCustomFiltersActionGroup.saveState(iMemento);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
        this.fillToolBar(iActionBars.getToolBarManager());
        this.fillViewMenu(iActionBars.getMenuManager());
    }

    void updateActionBars(IActionBars iActionBars) {
        iActionBars.getToolBarManager().removeAll();
        iActionBars.getMenuManager().removeAll();
        this.fillActionBars(iActionBars);
        iActionBars.updateActionBars();
        this.fZoomInAction.setEnabled(true);
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        iActionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        iActionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        iActionBars.setGlobalActionHandler("goToResource", (IAction)this.fGotoResourceAction);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GoToType", (IAction)this.fGotoTypeAction);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GoToPackage", (IAction)this.fGotoPackageAction);
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        this.fRefactorActionGroup.retargetFileMenuActions(iActionBars);
    }

    void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.fBackAction);
        iToolBarManager.add((IAction)this.fForwardAction);
        iToolBarManager.add((IAction)this.fUpAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.fCollapseAllAction);
        iToolBarManager.add((IAction)this.fToggleLinkingAction);
    }

    void fillViewMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.fToggleLinkingAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        int n = iStructuredSelection.size();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ClassPathContainer.RequiredProjectWrapper) {
            iMenuManager.appendToGroup("group.show", this.fGotoRequiredProjectAction);
        }
        this.addGotoMenu(iMenuManager, object, n);
        this.addOpenNewWindowAction(iMenuManager, object);
        super.fillContextMenu(iMenuManager);
    }

    private void addGotoMenu(IMenuManager iMenuManager, Object object, int n) {
        boolean bl = n == 1 && this.fPart.getTreeViewer().isExpandable(object) && (this.isGoIntoTarget(object) || object instanceof IContainer);
        this.fZoomInAction.setEnabled(bl);
        if (bl) {
            iMenuManager.appendToGroup("group.goto", (IAction)this.fZoomInAction);
        }
    }

    private boolean isGoIntoTarget(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IJavaElement) {
            int n = ((IJavaElement)object).getElementType();
            return n == 2 || n == 3 || n == 4;
        }
        return object instanceof IWorkingSet;
    }

    private void addOpenNewWindowAction(IMenuManager iMenuManager, Object object) {
        if (object instanceof IJavaElement) {
            object = ((IJavaElement)object).getResource();
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return;
        }
        if (!(object instanceof IContainer)) {
            return;
        }
        iMenuManager.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        OpenProjectAction openProjectAction;
        IStructuredSelection iStructuredSelection;
        Object object;
        TreeViewer treeViewer = this.fPart.getTreeViewer();
        if (treeViewer.isExpandable(object = (iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (object instanceof ICompilationUnit || object instanceof IClassFile) {
                    return;
                }
                if (object instanceof IOpenable || object instanceof IContainer || object instanceof IWorkingSet) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction iAction = this.fNavigateActionGroup.getOpenAction();
                if (iAction != null && iAction.isEnabled() && OpenStrategy.getOpenMethod() == 0) {
                    return;
                }
                if (iStructuredSelection instanceof ITreeSelection) {
                    TreePath[] treePathArray = ((ITreeSelection)iStructuredSelection).getPathsFor(object);
                    int n = 0;
                    while (n < treePathArray.length) {
                        treeViewer.setExpandedState((Object)treePathArray[n], !treeViewer.getExpandedState((Object)treePathArray[n]));
                        ++n;
                    }
                } else {
                    treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
                }
            }
        } else if (object instanceof IProject && !((IProject)object).isOpen() && (openProjectAction = this.fProjectActionGroup.getOpenProjectAction()).isEnabled()) {
            openProjectAction.run();
        }
    }

    void handleOpen(OpenEvent openEvent) {
        IAction iAction = this.fNavigateActionGroup.getOpenAction();
        if (iAction != null && iAction.isEnabled()) {
            iAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.stateMask != 0) {
            return;
        }
        if (keyEvent.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
            keyEvent.doit = false;
        }
    }

    private void doWorkingSetChanged(PropertyChangeEvent propertyChangeEvent) {
        if (ViewActionGroup.MODE_CHANGED.equals(propertyChangeEvent.getProperty())) {
            this.fPart.rootModeChanged((Integer)propertyChangeEvent.getNewValue());
            WorkingSetModel workingSetModel = null;
            Object object = null;
            if (this.fPart.showProjects()) {
                workingSetModel = this.fPart.getWorkingSetModel();
                object = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            } else if (this.fPart.showWorkingSets()) {
                workingSetModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                object = this.fPart.getWorkingSetModel();
            }
            if (workingSetModel != null && object != null) {
                Frame frame;
                int n = 0;
                while ((frame = this.fFrameList.getFrame(n)) != null) {
                    TreeFrame treeFrame;
                    if (frame instanceof TreeFrame && workingSetModel.equals((treeFrame = (TreeFrame)frame).getInput())) {
                        treeFrame.setInput(object);
                    }
                    ++n;
                }
            }
        } else {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
            String string = null;
            if (iWorkingSet != null) {
                string = iWorkingSet.getLabel();
            }
            this.fPart.setWorkingSetLabel(string);
            this.fPart.updateTitle();
            String string2 = propertyChangeEvent.getProperty();
            if ("workingSetContentChange".equals(string2)) {
                TreeViewer treeViewer = this.fPart.getTreeViewer();
                treeViewer.getControl().setRedraw(false);
                treeViewer.refresh();
                treeViewer.getControl().setRedraw(true);
            }
        }
    }

    private boolean doubleClickGoesInto() {
        return "packageview.gointo".equals(PreferenceConstants.getPreferenceStore().getString("packageview.doubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }

    public ViewActionGroup getWorkingSetActionGroup() {
        return this.fViewActionGroup;
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }

    public FrameList getFrameList() {
        return this.fFrameList;
    }
}

