/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.VariableBlock;

public class ClasspathVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.wst.jsdt.ui.preferences.ClasspathVariablesPreferencePage";
    public static final String DATA_SELECT_VARIABLE = "ClasspathVariablesPreferencePage.select_var";
    private VariableBlock fVariableBlock;
    private String fStoredSettings;

    public ClasspathVariablesPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fVariableBlock = new VariableBlock(true, null);
        this.fStoredSettings = null;
        this.setTitle(PreferencesMessages.ClasspathVariablesPreferencePage_title);
        this.setDescription(PreferencesMessages.ClasspathVariablesPreferencePage_description);
        this.noDefaultAndApplyButton();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.cp_variables_preference_page_context");
    }

    protected Control createContents(Composite composite) {
        Control control = this.fVariableBlock.createContents(composite);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        JavaPlugin.getDefault().savePluginPreferences();
        return this.fVariableBlock.performOk();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.fStoredSettings != null && !this.fStoredSettings.equals(this.getCurrentSettings())) {
                this.fVariableBlock.refresh(null);
            }
        } else {
            if (this.fVariableBlock.hasChanges()) {
                String string = PreferencesMessages.ClasspathVariablesPreferencePage_savechanges_title;
                String string2 = PreferencesMessages.ClasspathVariablesPreferencePage_savechanges_message;
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)string, (String)string2)) {
                    this.performOk();
                }
                this.fVariableBlock.setChanges(false);
            }
            this.fStoredSettings = this.getCurrentSettings();
        }
        super.setVisible(bl);
    }

    private String getCurrentSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = JavaCore.getClasspathVariableNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringBuffer.append(string).append('\u0000');
            IPath iPath = JavaCore.getClasspathVariable((String)string);
            if (iPath != null) {
                stringBuffer.append(iPath.toString());
            }
            stringBuffer.append('\u0000');
            ++n;
        }
        return stringBuffer.toString();
    }

    public void applyData(Object object) {
        Object v;
        if (object instanceof Map && (v = ((Map)object).get(DATA_SELECT_VARIABLE)) instanceof String) {
            this.fVariableBlock.setSelection((String)v);
        }
        super.applyData(object);
    }
}

