/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.preferences.CodeTemplateSourceViewerConfiguration;
import org.eclipse.wst.jsdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class CodeTemplateBlock {
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = PreferencesMessages.CodeTemplateBlock_templates_comment_node;
    protected static final Object CODE_NODE = PreferencesMessages.CodeTemplateBlock_templates_code_node;
    private TreeListDialogField fCodeTemplateTree;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private Control fSWTWidget;
    private TemplateVariableProcessor fTemplateProcessor;
    private final IProject fProject;

    public CodeTemplateBlock(IProject iProject) {
        this.fProject = iProject;
        this.fTemplateStore = new ProjectTemplateStore(iProject);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter codeTemplateAdapter = new CodeTemplateAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.CodeTemplateBlock_templates_edit_button;
        stringArray[2] = PreferencesMessages.CodeTemplateBlock_templates_import_button;
        stringArray[3] = PreferencesMessages.CodeTemplateBlock_templates_export_button;
        stringArray[4] = PreferencesMessages.CodeTemplateBlock_templates_exportall_button;
        String[] stringArray2 = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField(codeTemplateAdapter, stringArray2, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(codeTemplateAdapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.CodeTemplateBlock_templates_label);
        this.fCodeTemplateTree.setViewerComparator(codeTemplateAdapter);
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCodeTemplateTree.selectFirstElement();
    }

    public void postSetSelection(Object object) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(object));
    }

    public boolean hasProjectSpecificOptions(IProject iProject) {
        if (iProject != null) {
            return ProjectTemplateStore.hasProjectSpecificTempates(iProject);
        }
        return false;
    }

    protected Control createContents(Composite composite) {
        this.fPixelConverter = new PixelConverter((Control)composite);
        this.fSWTWidget = composite;
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.fCodeTemplateTree.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite2, 2);
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private SourceViewer createViewer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setText(PreferencesMessages.CodeTemplateBlock_preview);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        Document document = new Document();
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        javaTextTools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer javaSourceViewer = new JavaSourceViewer(composite, null, null, false, 2816, iPreferenceStore);
        CodeTemplateSourceViewerConfiguration codeTemplateSourceViewerConfiguration = new CodeTemplateSourceViewerConfiguration(javaTextTools.getColorManager(), iPreferenceStore, null, this.fTemplateProcessor);
        javaSourceViewer.configure((SourceViewerConfiguration)codeTemplateSourceViewerConfiguration);
        javaSourceViewer.setEditable(false);
        javaSourceViewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont");
        javaSourceViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)javaSourceViewer, codeTemplateSourceViewerConfiguration, iPreferenceStore);
        Control control = javaSourceViewer.getControl();
        gridData = new GridData(1296);
        gridData.horizontalSpan = n;
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        return javaSourceViewer;
    }

    protected TemplatePersistenceData[] getTemplateOfCategory(boolean bl) {
        ArrayList<TemplatePersistenceData> arrayList = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templatePersistenceDataArray = this.fTemplateStore.getTemplateData();
        int n = 0;
        while (n < templatePersistenceDataArray.length) {
            TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n];
            if (bl == templatePersistenceData.getTemplate().getName().endsWith("comment")) {
                arrayList.add(templatePersistenceData);
            }
            ++n;
        }
        return arrayList.toArray(new TemplatePersistenceData[arrayList.size()]);
    }

    protected static boolean canEdit(List list) {
        return list.size() == 1 && list.get(0) instanceof TemplatePersistenceData;
    }

    protected void updateSourceViewerInput(List list) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (list.size() == 1 && list.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData templatePersistenceData = (TemplatePersistenceData)list.get(0);
            Template template = templatePersistenceData.getTemplate();
            TemplateContextType templateContextType = JavaPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(templateContextType);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int n, List list) {
        if (n == 0) {
            this.edit((TemplatePersistenceData)list.get(0));
        } else if (n == 3) {
            this.export(list);
        } else if (n == 4) {
            this.exportAll();
        } else if (n == 2) {
            this.import_();
        }
    }

    private void edit(TemplatePersistenceData templatePersistenceData) {
        Template template = new Template(templatePersistenceData.getTemplate());
        EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.getShell(), template, true, false, JavaPlugin.getDefault().getCodeTemplateContextRegistry());
        if (editTemplateDialog.open() == 0) {
            templatePersistenceData.setTemplate(editTemplateDialog.getTemplate());
            this.fCodeTemplateTree.refresh(templatePersistenceData);
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)templatePersistenceData));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void import_() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(PreferencesMessages.CodeTemplateBlock_import_title);
        fileDialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_import_extension});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
            File file = new File(string);
            if (file.exists()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] templatePersistenceDataArray = templateReaderWriter.read((InputStream)bufferedInputStream, null);
                    int n = 0;
                    while (n < templatePersistenceDataArray.length) {
                        this.updateTemplate(templatePersistenceDataArray[n]);
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    try {
                        ((InputStream)bufferedInputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var8_12 = null;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)bufferedInputStream).close();
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.openReadErrorDialog(fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            this.openReadErrorDialog(iOException);
        }
    }

    private void updateTemplate(TemplatePersistenceData templatePersistenceData) {
        TemplatePersistenceData[] templatePersistenceDataArray = this.fTemplateStore.getTemplateData();
        int n = 0;
        while (n < templatePersistenceDataArray.length) {
            String string = templatePersistenceDataArray[n].getId();
            if (string != null && string.equals(templatePersistenceData.getId())) {
                templatePersistenceDataArray[n].setTemplate(templatePersistenceData.getTemplate());
                break;
            }
            ++n;
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List list) {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof TemplatePersistenceData) {
                hashSet.add(e);
            } else {
                TemplatePersistenceData[] templatePersistenceDataArray = this.getTemplateOfCategory(e == COMMENT_NODE);
                hashSet.addAll(Arrays.asList(templatePersistenceDataArray));
            }
            ++n;
        }
        this.export(hashSet.toArray(new TemplatePersistenceData[hashSet.size()]));
    }

    private void export(TemplatePersistenceData[] templatePersistenceDataArray) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(Messages.format(PreferencesMessages.CodeTemplateBlock_export_title, String.valueOf(templatePersistenceDataArray.length)));
        fileDialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_export_extension});
        fileDialog.setFileName(PreferencesMessages.CodeTemplateBlock_export_filename);
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.isHidden()) {
            String string2 = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String string3 = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_hidden, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)string2, (String)string3);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String string4 = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String string5 = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_canNotWrite, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)string4, (String)string5);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
                templateReaderWriter.save(templatePersistenceDataArray, outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                this.openWriteErrorDialog(iOException);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.CodeTemplateBlock_export_exists_title, (String)Messages.format(PreferencesMessages.CodeTemplateBlock_export_exists_message, file.getAbsolutePath()));
    }

    public void performDefaults() {
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean bl) {
        if (this.fProject != null) {
            TemplatePersistenceData[] templatePersistenceDataArray = this.fTemplateStore.getTemplateData();
            int n = 0;
            while (n < templatePersistenceDataArray.length) {
                this.fTemplateStore.setProjectSpecific(templatePersistenceDataArray[n].getId(), bl);
                ++n;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
            this.openWriteErrorDialog(iOException);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException iOException) {
            this.openReadErrorDialog(iOException);
        }
    }

    private void openReadErrorDialog(Exception exception) {
        String string = PreferencesMessages.CodeTemplateBlock_error_read_title;
        String string2 = exception.getLocalizedMessage();
        string2 = string2 != null ? Messages.format(PreferencesMessages.CodeTemplateBlock_error_parse_message, string2) : PreferencesMessages.CodeTemplateBlock_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)string, (String)string2);
    }

    private void openWriteErrorDialog(Exception exception) {
        String string = PreferencesMessages.CodeTemplateBlock_error_write_title;
        String string2 = PreferencesMessages.CodeTemplateBlock_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)string, (String)string2);
    }

    private class CodeTemplateAdapter
    extends ViewerComparator
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CodeTemplateBlock.this.doButtonPressed(n, treeListDialogField.getSelectedElements());
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            List list = treeListDialogField.getSelectedElements();
            treeListDialogField.enableButton(0, CodeTemplateBlock.canEdit(list));
            treeListDialogField.enableButton(3, !list.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(list);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            List list = treeListDialogField.getSelectedElements();
            if (CodeTemplateBlock.canEdit(list)) {
                CodeTemplateBlock.this.doButtonPressed(0, list);
            }
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object == COMMENT_NODE || object == CODE_NODE) {
                return CodeTemplateBlock.this.getTemplateOfCategory(object == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof TemplatePersistenceData) {
                TemplatePersistenceData templatePersistenceData = (TemplatePersistenceData)object;
                if (templatePersistenceData.getTemplate().getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                return CODE_NODE;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return object == COMMENT_NODE || object == CODE_NODE;
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        }

        public int category(Object object) {
            if (object == COMMENT_NODE) {
                return 1;
            }
            if (object == CODE_NODE) {
                return 2;
            }
            TemplatePersistenceData templatePersistenceData = (TemplatePersistenceData)object;
            String string = templatePersistenceData.getId();
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.newtype".equals(string)) {
                return 101;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.classbody".equals(string)) {
                return 102;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.interfacebody".equals(string)) {
                return 103;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.enumbody".equals(string)) {
                return 104;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.annotationbody".equals(string)) {
                return 105;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.methodbody".equals(string)) {
                return 106;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.constructorbody".equals(string)) {
                return 107;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.getterbody".equals(string)) {
                return 108;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.setterbody".equals(string)) {
                return 109;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.catchblock".equals(string)) {
                return 110;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.filecomment".equals(string)) {
                return 1;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.typecomment".equals(string)) {
                return 2;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.fieldcomment".equals(string)) {
                return 3;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment".equals(string)) {
                return 4;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment".equals(string)) {
                return 5;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment".equals(string)) {
                return 6;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment".equals(string)) {
                return 7;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.gettercomment".equals(string)) {
                return 8;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.settercomment".equals(string)) {
                return 9;
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            if (object == COMMENT_NODE || object == CODE_NODE) {
                return (String)object;
            }
            TemplatePersistenceData templatePersistenceData = (TemplatePersistenceData)object;
            String string = templatePersistenceData.getId();
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.catchblock".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_catchblock_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.methodbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_methodstub_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.constructorbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_constructorstub_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.getterbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_getterstub_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.setterbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_setterstub_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.newtype".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_newtype_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.classbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_classbody_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.interfacebody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_interfacebody_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.enumbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_enumbody_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.annotationbody".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_annotationbody_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.filecomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_filecomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.typecomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_typecomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.fieldcomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_fieldcomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_methodcomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_overridecomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_delegatecomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_constructorcomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.gettercomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_gettercomment_label;
            }
            if ("org.eclipse.wst.jsdt.ui.text.codetemplates.settercomment".equals(string)) {
                return PreferencesMessages.CodeTemplateBlock_settercomment_label;
            }
            return templatePersistenceData.getTemplate().getDescription();
        }
    }
}

