/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;

public class JavaBuildConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = "JavaBuildConfigurationBlock";
    private static final OptionsConfigurationBlock.Key PREF_PB_MAX_PER_UNIT = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit");
    private static final OptionsConfigurationBlock.Key PREF_RESOURCE_FILTER = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.resourceCopyExclusionFilter");
    private static final OptionsConfigurationBlock.Key PREF_BUILD_INVALID_CLASSPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.invalidClasspath");
    private static final OptionsConfigurationBlock.Key PREF_BUILD_CLEAN_OUTPUT_FOLDER = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.cleanOutputFolder");
    private static final OptionsConfigurationBlock.Key PREF_ENABLE_EXCLUSION_PATTERNS = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns");
    private static final OptionsConfigurationBlock.Key PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.classpath.multipleOutputLocations");
    private static final OptionsConfigurationBlock.Key PREF_PB_INCOMPLETE_BUILDPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.incompleteClasspath");
    private static final OptionsConfigurationBlock.Key PREF_PB_CIRCULAR_BUILDPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.circularClasspath");
    private static final OptionsConfigurationBlock.Key PREF_PB_INCOMPATIBLE_JDK_LEVEL = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.incompatibleJDKLevel");
    private static final OptionsConfigurationBlock.Key PREF_PB_DUPLICATE_RESOURCE = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.duplicateResourceTask");
    private static final OptionsConfigurationBlock.Key PREF_RECREATE_MODIFIED_CLASS_FILES = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.recreateModifiedClassFileInOutputFolder");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ABORT = "abort";
    private static final String CLEAN = "clean";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private PixelConverter fPixelConverter;
    private IStatus fMaxNumberProblemsStatus = new StatusInfo();
    private IStatus fResourceFilterStatus = new StatusInfo();

    public JavaBuildConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, JavaBuildConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keyArray = new OptionsConfigurationBlock.Key[]{PREF_PB_MAX_PER_UNIT, PREF_RESOURCE_FILTER, PREF_BUILD_INVALID_CLASSPATH, PREF_PB_INCOMPLETE_BUILDPATH, PREF_PB_CIRCULAR_BUILDPATH, PREF_BUILD_CLEAN_OUTPUT_FOLDER, PREF_PB_DUPLICATE_RESOURCE, PREF_PB_INCOMPATIBLE_JDK_LEVEL, PREF_ENABLE_EXCLUSION_PATTERNS, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, PREF_RECREATE_MODIFIED_CLASS_FILES};
        return keyArray;
    }

    protected Control createContents(Composite composite) {
        this.fPixelConverter = new PixelConverter((Control)composite);
        this.setShell(composite.getShell());
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createBuildPathTabContent(composite2);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        composite3.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return composite2;
    }

    private Composite createBuildPathTabContent(Composite composite) {
        String[] stringArray = new String[]{ABORT, IGNORE};
        String[] stringArray2 = new String[]{CLEAN, IGNORE};
        String[] stringArray3 = new String[]{ENABLED, DISABLED};
        String[] stringArray4 = new String[]{ENABLED, IGNORE};
        String[] stringArray5 = new String[]{ERROR, WARNING};
        String[] stringArray6 = new String[]{PreferencesMessages.JavaBuildConfigurationBlock_error, PreferencesMessages.JavaBuildConfigurationBlock_warning};
        String[] stringArray7 = new String[]{ERROR, WARNING, IGNORE};
        String[] stringArray8 = new String[]{PreferencesMessages.JavaBuildConfigurationBlock_error, PreferencesMessages.JavaBuildConfigurationBlock_warning, PreferencesMessages.JavaBuildConfigurationBlock_ignore};
        int n = 3;
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = scrolledPageContent.getBody();
        composite2.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaBuildConfigurationBlock_section_general;
        ExpandableComposite expandableComposite = this.createStyleSection(composite2, string, n);
        Composite composite3 = new Composite((Composite)expandableComposite, 0);
        expandableComposite.setClient((Control)composite3);
        composite3.setLayout((Layout)new GridLayout(n, false));
        string = PreferencesMessages.JavaBuildConfigurationBlock_pb_max_per_unit_label;
        Text text = this.addTextField(composite3, string, PREF_PB_MAX_PER_UNIT, 0, 0);
        GridData gridData = (GridData)text.getLayoutData();
        gridData.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(8);
        gridData.horizontalAlignment = 3;
        text.setTextLimit(6);
        string = PreferencesMessages.JavaBuildConfigurationBlock_enable_exclusion_patterns_label;
        this.addCheckBox(composite3, string, PREF_ENABLE_EXCLUSION_PATTERNS, stringArray3, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_enable_multiple_outputlocations_label;
        this.addCheckBox(composite3, string, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, stringArray3, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_section_build_path_problems;
        expandableComposite = this.createStyleSection(composite2, string, n);
        composite3 = new Composite((Composite)expandableComposite, 0);
        expandableComposite.setClient((Control)composite3);
        composite3.setLayout((Layout)new GridLayout(n, false));
        string = PreferencesMessages.JavaBuildConfigurationBlock_build_invalid_classpath_label;
        this.addCheckBox(composite3, string, PREF_BUILD_INVALID_CLASSPATH, stringArray, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_pb_incomplete_build_path_label;
        this.addComboBox(composite3, string, PREF_PB_INCOMPLETE_BUILDPATH, stringArray5, stringArray6, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_pb_build_path_cycles_label;
        this.addComboBox(composite3, string, PREF_PB_CIRCULAR_BUILDPATH, stringArray5, stringArray6, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_pb_check_prereq_binary_level_label;
        this.addComboBox(composite3, string, PREF_PB_INCOMPATIBLE_JDK_LEVEL, stringArray7, stringArray8, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_section_output_folder;
        expandableComposite = this.createStyleSection(composite2, string, n);
        composite3 = new Composite((Composite)expandableComposite, 0);
        expandableComposite.setClient((Control)composite3);
        composite3.setLayout((Layout)new GridLayout(n, false));
        string = PreferencesMessages.JavaBuildConfigurationBlock_pb_duplicate_resources_label;
        this.addComboBox(composite3, string, PREF_PB_DUPLICATE_RESOURCE, stringArray5, stringArray6, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_build_clean_outputfolder_label;
        this.addCheckBox(composite3, string, PREF_BUILD_CLEAN_OUTPUT_FOLDER, stringArray2, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_build_recreate_modified;
        this.addCheckBox(composite3, string, PREF_RECREATE_MODIFIED_CLASS_FILES, stringArray4, 0);
        string = PreferencesMessages.JavaBuildConfigurationBlock_resource_filter_label;
        text = this.addTextField(composite3, string, PREF_RESOURCE_FILTER, 0, 0);
        gridData = (GridData)text.getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(10);
        Label label = new Label(composite3, 64);
        label.setText(PreferencesMessages.JavaBuildConfigurationBlock_resource_filter_description);
        gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)gridData);
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(iDialogSettings);
        return scrolledPageContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (key != null) {
            if (PREF_PB_MAX_PER_UNIT.equals(key)) {
                this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            } else {
                if (!PREF_RESOURCE_FILTER.equals(key)) return;
                this.fResourceFilterStatus = this.validateResourceFilters();
            }
        } else {
            this.updateEnableStates();
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            this.fResourceFilterStatus = this.validateResourceFilters();
        }
        IStatus iStatus = StatusUtil.getMostSevere(new IStatus[]{this.fMaxNumberProblemsStatus, this.fResourceFilterStatus});
        this.fContext.statusChanged(iStatus);
    }

    private void updateEnableStates() {
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        String string = PreferencesMessages.JavaBuildConfigurationBlock_needsbuild_title;
        String string2 = bl ? PreferencesMessages.JavaBuildConfigurationBlock_needsfullbuild_message : PreferencesMessages.JavaBuildConfigurationBlock_needsprojectbuild_message;
        return new String[]{string, string2};
    }

    private IStatus validateMaxNumberProblems() {
        String string = this.getValue(PREF_PB_MAX_PER_UNIT);
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() == 0) {
            statusInfo.setError(PreferencesMessages.JavaBuildConfigurationBlock_empty_input);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n <= 0) {
                    statusInfo.setError(Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, string));
            }
        }
        return statusInfo;
    }

    private IStatus validateResourceFilters() {
        String string = this.getValue(PREF_RESOURCE_FILTER);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String[] stringArray = this.getTokens(string, ",");
        int n = 0;
        while (n < stringArray.length) {
            IStatus iStatus;
            String string2 = stringArray[n].replace('*', 'x');
            int n2 = 1;
            int n3 = string2.length() - 1;
            if (n3 >= 0 && string2.charAt(n3) == '/') {
                string2 = string2.substring(0, n3);
                n2 = 2;
            }
            if ((iStatus = iWorkspace.validateName(string2, n2)).matches(4)) {
                String string3 = Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_filter_invalidsegment_error, iStatus.getMessage());
                return new StatusInfo(4, string3);
            }
            ++n;
        }
        return new StatusInfo();
    }

    public void dispose() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(iDialogSettings);
        super.dispose();
    }
}

