/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaPreferencesSettings {
    public static CodeGenerationSettings getCodeGenerationSettings(IJavaProject iJavaProject) {
        CodeGenerationSettings codeGenerationSettings = new CodeGenerationSettings();
        codeGenerationSettings.createComments = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.javadoc", iJavaProject));
        codeGenerationSettings.useKeywordThis = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.keywordthis", iJavaProject));
        codeGenerationSettings.overrideAnnotation = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.overrideannotation", iJavaProject));
        codeGenerationSettings.importOrder = JavaPreferencesSettings.getImportOrderPreference(iJavaProject);
        codeGenerationSettings.importThreshold = JavaPreferencesSettings.getImportNumberThreshold(iJavaProject);
        codeGenerationSettings.staticImportThreshold = JavaPreferencesSettings.getStaticImportNumberThreshold(iJavaProject);
        codeGenerationSettings.importIgnoreLowercase = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ignorelowercasenames", iJavaProject));
        codeGenerationSettings.tabWidth = CodeFormatterUtil.getTabWidth(iJavaProject);
        codeGenerationSettings.indentWidth = CodeFormatterUtil.getIndentWidth(iJavaProject);
        return codeGenerationSettings;
    }

    public static CodeGenerationSettings getCodeGenerationSettings() {
        return JavaPreferencesSettings.getCodeGenerationSettings(null);
    }

    public static int getImportNumberThreshold(IJavaProject iJavaProject) {
        String string = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", iJavaProject);
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static int getStaticImportNumberThreshold(IJavaProject iJavaProject) {
        String string = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", iJavaProject);
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static String[] getImportOrderPreference(IJavaProject iJavaProject) {
        String string = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.importorder", iJavaProject);
        if (string != null) {
            return JavaPreferencesSettings.unpackList(string, ";");
        }
        return new String[0];
    }

    public static int getImportNumberThreshold(IPreferenceStore iPreferenceStore) {
        int n = iPreferenceStore.getInt("org.eclipse.wst.jsdt.ui.ondemandthreshold");
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public static String[] getImportOrderPreference(IPreferenceStore iPreferenceStore) {
        String string = iPreferenceStore.getString("org.eclipse.wst.jsdt.ui.importorder");
        if (string != null) {
            return JavaPreferencesSettings.unpackList(string, ";");
        }
        return new String[0];
    }

    private static String[] unpackList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }
}

