/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentSetupParticipant;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.wst.jsdt.internal.ui.text.JavaColorManager;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public class PropertiesFileEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.PropertiesFileEditorPreferencePage_key, "pf_coloring_key"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_value, "pf_coloring_value"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_assignment, "pf_coloring_assignment"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_argument, "pf_coloring_argument"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_comment, "pf_coloring_comment"}};
    private OverlayPreferenceStore fOverlayStore;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private SourceViewer fPreviewViewer;
    private boolean fFieldsInitialized = false;
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private final List fHighlightingColorList = new ArrayList();
    private TableViewer fHighlightingColorListViewer;
    private IColorManager fColorManager;

    public PropertiesFileEditorPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int n = 0;
        while (n < this.fSyntaxColorListModel.length) {
            String string = this.fSyntaxColorListModel[n][1];
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, string));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(string) + BOLD));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(string) + ITALIC));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(string) + STRIKETHROUGH));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(string) + UNDERLINE));
            ++n;
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.properties_file_editor_preference_page_context");
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem highlightingColorListItem = this.getHighlightingColorListItem();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)highlightingColorListItem.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rGB);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(highlightingColorListItem.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(highlightingColorListItem.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.fOverlayStore.getBoolean(highlightingColorListItem.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.fOverlayStore.getBoolean(highlightingColorListItem.getUnderlineKey()));
        this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
        this.fBoldCheckBox.setEnabled(true);
        this.fItalicCheckBox.setEnabled(true);
        this.fStrikethroughCheckBox.setEnabled(true);
        this.fUnderlineCheckBox.setEnabled(true);
    }

    private Control createSyntaxPage(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_foreground);
        label.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 1, true, false);
        composite2.setLayoutData((Object)gridData);
        this.fHighlightingColorListViewer = new TableViewer(composite2, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setComparator((ViewerComparator)new WorkbenchViewerSorter());
        gridData = new GridData(1, 4, false, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1, 1, false, false));
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        label = new Label(composite3, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_color);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        label.setLayoutData((Object)gridData);
        this.fSyntaxForegroundColorEditor = new ColorSelector(composite3);
        Button button = this.fSyntaxForegroundColorEditor.getButton();
        gridData = new GridData(32);
        button.setLayoutData((Object)gridData);
        this.fBoldCheckBox = new Button(composite3, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_bold);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gridData);
        this.fItalicCheckBox = new Button(composite3, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_italic);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gridData);
        this.fStrikethroughCheckBox = new Button(composite3, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_strikethrough);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gridData);
        this.fUnderlineCheckBox = new Button(composite3, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_underline);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gridData);
        label = new Label(composite, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control control = this.createPreviewer(composite);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(20);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PropertiesFileEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)PropertiesFileEditorPreferencePage.this.fOverlayStore, (String)highlightingColorListItem.getColorKey(), (RGB)PropertiesFileEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(highlightingColorListItem.getBoldKey(), PropertiesFileEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(highlightingColorListItem.getItalicKey(), PropertiesFileEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(highlightingColorListItem.getStrikethroughKey(), PropertiesFileEditorPreferencePage.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(highlightingColorListItem.getUnderlineKey(), PropertiesFileEditorPreferencePage.this.fUnderlineCheckBox.getSelection());
            }
        });
        composite.layout();
        return composite;
    }

    private Control createPreviewer(Composite composite) {
        ChainedPreferenceStore chainedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, JavaPlugin.getDefault().getCombinedPreferenceStore()});
        this.fPreviewViewer = new JavaSourceViewer(composite, null, null, false, 2816, (IPreferenceStore)chainedPreferenceStore);
        this.fColorManager = new JavaColorManager(false);
        PropertiesFileSourceViewerConfiguration propertiesFileSourceViewerConfiguration = new PropertiesFileSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)chainedPreferenceStore, null, "___pf_partitioning");
        this.fPreviewViewer.configure((SourceViewerConfiguration)propertiesFileSourceViewerConfiguration);
        Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.PropertiesFileEditor.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new SourcePreviewerUpdater(this.fPreviewViewer, propertiesFileSourceViewerConfiguration, (IPreferenceStore)chainedPreferenceStore);
        this.fPreviewViewer.setEditable(false);
        String string = this.loadPreviewContentFromFile("PropertiesFileEditorColorSettingPreviewCode.txt");
        Document document = new Document(string);
        PropertiesFileDocumentSetupParticipant.setupDocument((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private void createDependency(final Button button, String string, final Control control) {
        PropertiesFileEditorPreferencePage.indent(control);
        boolean bl = this.fOverlayStore.getBoolean(string);
        control.setEnabled(bl);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                control.setEnabled(button.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    protected Control createContents(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createHeader(composite2);
        this.createSyntaxPage(composite2);
        this.initialize();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createHeader(Composite composite) {
        String string = PreferencesMessages.PropertiesFileEditorPreferencePage_link;
        Link link = new Link(composite, 0);
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PropertiesFileEditorPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.PropertiesFileEditorPreferencePage_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        this.addFiller(composite);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private void initialize() {
        this.initializeFields();
        int n = 0;
        int n2 = this.fSyntaxColorListModel.length;
        while (n < n2) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[n][0], this.fSyntaxColorListModel[n][1], String.valueOf(this.fSyntaxColorListModel[n][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[n][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[n][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[n][1]) + UNDERLINE, null));
            ++n;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
    }

    private void initializeFields() {
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
        Iterator iterator = this.fMasterSlaveListeners.iterator();
        while (iterator.hasNext()) {
            SelectionListener selectionListener = (SelectionListener)iterator.next();
            selectionListener.widgetSelected(null);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleSyntaxColorListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        this.fColorManager.dispose();
        super.dispose();
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void updateStatus(IStatus iStatus) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)iStructuredSelection.getFirstElement();
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object object) {
            return ((List)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object object) {
            return ((HighlightingColorListItem)object).getDisplayName();
        }

        public Color getForeground(Object object) {
            return ((HighlightingColorListItem)object).getItemColor();
        }

        public Color getBackground(Object object) {
            return null;
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;
        private Color fItemColor;

        public HighlightingColorListItem(String string, String string2, String string3, String string4, String string5, String string6, Color color) {
            this.fDisplayName = string;
            this.fColorKey = string2;
            this.fBoldKey = string3;
            this.fItalicKey = string4;
            this.fStrikethroughKey = string5;
            this.fUnderlineKey = string6;
            this.fItemColor = color;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }

    private static class SourcePreviewerUpdater {
        SourcePreviewerUpdater(SourceViewer sourceViewer, PropertiesFileSourceViewerConfiguration propertiesFileSourceViewerConfiguration, IPreferenceStore iPreferenceStore) {
            Assert.isNotNull((Object)sourceViewer);
            Assert.isNotNull((Object)((Object)propertiesFileSourceViewerConfiguration));
            Assert.isNotNull((Object)iPreferenceStore);
            IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(this, sourceViewer){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("org.eclipse.wst.jsdt.ui.PropertiesFileEditor.textfont")) {
                        Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.PropertiesFileEditor.textfont");
                        this.val$viewer.getTextWidget().setFont(font);
                    }
                }
            };
            IPropertyChangeListener iPropertyChangeListener2 = new IPropertyChangeListener(this, propertiesFileSourceViewerConfiguration, sourceViewer){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ PropertiesFileSourceViewerConfiguration val$configuration;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$configuration = propertiesFileSourceViewerConfiguration;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.val$configuration.affectsTextPresentation(propertyChangeEvent)) {
                        this.val$configuration.handlePropertyChangeEvent(propertyChangeEvent);
                        this.val$viewer.invalidateTextPresentation();
                    }
                }
            };
            sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(this, iPreferenceStore, iPropertyChangeListener2, iPropertyChangeListener){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ IPreferenceStore val$preferenceStore;
                private final /* synthetic */ IPropertyChangeListener val$propertyChangeListener;
                private final /* synthetic */ IPropertyChangeListener val$fontChangeListener;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$preferenceStore = iPreferenceStore;
                    this.val$propertyChangeListener = iPropertyChangeListener;
                    this.val$fontChangeListener = iPropertyChangeListener2;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    this.val$preferenceStore.removePropertyChangeListener(this.val$propertyChangeListener);
                    JFaceResources.getFontRegistry().removeListener(this.val$fontChangeListener);
                }
            });
            JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
            iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener2);
        }
    }
}

