/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;

public class CreateProfileDialog
extends StatusDialog {
    private static final String PREF_OPEN_EDIT_DIALOG = "org.eclipse.wst.jsdt.ui.codeformatter.create_profile_dialog.open_edit";
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_name_is_empty);
    private static final StatusInfo fDuplicate = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_with_this_name_already_exists);
    private final ProfileManager fProfileManager;
    private final List fSortedProfiles;
    private final String[] fSortedNames;
    private ProfileManager.CustomProfile fCreatedProfile;
    protected boolean fOpenEditDialog;
    private final IProfileVersioner fProfileVersioner;

    public CreateProfileDialog(Shell shell, ProfileManager profileManager, IProfileVersioner iProfileVersioner) {
        super(shell);
        this.fProfileManager = profileManager;
        this.fProfileVersioner = iProfileVersioner;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.CreateProfileDialog_dialog_title);
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        Label label = new Label(composite2, 64);
        label.setText(FormatterMessages.CreateProfileDialog_profile_name_label_text);
        label.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fNameText = new Text(composite2, 2052);
        this.fNameText.setLayoutData((Object)gridData);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        Label label2 = new Label(composite2, 64);
        label2.setText(FormatterMessages.CreateProfileDialog_base_profile_label_text);
        label2.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite2, 12);
        this.fProfileCombo.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite2, 32);
        this.fEditCheckbox.setText(FormatterMessages.CreateProfileDialog_open_edit_dialog_checkbox_text);
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)selectionEvent.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fOpenEditDialog = iDialogSettings.get(PREF_OPEN_EDIT_DIALOG) != null ? iDialogSettings.getBoolean(PREF_OPEN_EDIT_DIALOG) : true;
        this.fEditCheckbox.setSelection(this.fOpenEditDialog);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fProfileManager.getDefaultProfile().getName());
        this.updateStatus(fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite2);
        this.fNameText.setFocus();
        return composite2;
    }

    protected void doValidation() {
        String string = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(string)) {
            this.updateStatus(fDuplicate);
            return;
        }
        if (string.length() == 0) {
            this.updateStatus(fEmpty);
            return;
        }
        this.updateStatus(fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        JavaPlugin.getDefault().getDialogSettings().put(PREF_OPEN_EDIT_DIALOG, this.fOpenEditDialog);
        HashMap hashMap = new HashMap(((ProfileManager.Profile)this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex())).getSettings());
        String string = this.fNameText.getText();
        this.fCreatedProfile = new ProfileManager.CustomProfile(string, hashMap, this.fProfileVersioner.getCurrentVersion(), this.fProfileVersioner.getProfileKind());
        this.fProfileManager.addProfile(this.fCreatedProfile);
        super.okPressed();
    }

    public final ProfileManager.CustomProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

