/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.wst.jsdt.ui.formatterprofiles";
    private final IProfileVersioner fProfileVersioner;

    public FormatterProfileStore(IProfileVersioner iProfileVersioner) {
        super(PREF_FORMATTER_PROFILES, iProfileVersioner);
        this.fProfileVersioner = iProfileVersioner;
    }

    public List readProfiles(IScopeContext iScopeContext) throws CoreException {
        List list = super.readProfiles(iScopeContext);
        if (list == null) {
            list = this.readOldForCompatibility(iScopeContext);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List readOldForCompatibility(IScopeContext iScopeContext) {
        File file = JavaPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
        if (!file.exists()) {
            return null;
        }
        try {
            List list;
            FileReader fileReader = new FileReader(file);
            try {
                List list2 = FormatterProfileStore.readProfilesFromStream(new InputSource(fileReader));
                if (list2 != null) {
                    int n = 0;
                    while (true) {
                        if (n >= list2.size()) {
                            this.writeProfiles(list2, iScopeContext);
                            break;
                        }
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)list2.get(n));
                        ++n;
                    }
                }
                file.delete();
                list = list2;
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                fileReader.close();
                throw throwable;
            }
            fileReader.close();
            return list;
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return null;
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
        }
        return null;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess preferencesAccess = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext iScopeContext = preferencesAccess.getInstanceScope();
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
        int n = iEclipsePreferences.getInt("org.eclipse.wst.jsdt.ui.formatterprofiles.version", 0);
        if (n >= profileVersioner.getCurrentVersion()) {
            return;
        }
        try {
            FormatterProfileManager formatterProfileManager;
            ArrayList arrayList = new FormatterProfileStore(profileVersioner).readProfiles(iScopeContext);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if ((formatterProfileManager = new FormatterProfileManager(arrayList, iScopeContext, preferencesAccess, profileVersioner)).getSelected() instanceof ProfileManager.CustomProfile) {
                formatterProfileManager.commitChanges(iScopeContext);
            }
            iEclipsePreferences.putInt("org.eclipse.wst.jsdt.ui.formatterprofiles.version", profileVersioner.getCurrentVersion());
            FormatterProfileStore.savePreferences(iScopeContext);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                IScopeContext iScopeContext2 = preferencesAccess.getProjectScope(iProjectArray[n2]);
                if (formatterProfileManager.hasProjectSpecificSettings(iScopeContext2)) {
                    formatterProfileManager = new FormatterProfileManager(arrayList, iScopeContext2, preferencesAccess, profileVersioner);
                    formatterProfileManager.commitChanges(iScopeContext2);
                    FormatterProfileStore.savePreferences(iScopeContext2);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BackingStoreException backingStoreException) {
            JavaPlugin.log(backingStoreException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void savePreferences(IScopeContext iScopeContext) throws BackingStoreException {
        try {
            iScopeContext.getNode("org.eclipse.wst.jsdt.ui").flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            iScopeContext.getNode("org.eclipse.wst.jsdt.core").flush();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        iScopeContext.getNode("org.eclipse.wst.jsdt.core").flush();
    }
}

