/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class LineWrappingTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.wst.jsdt.uiformatter_page.line_wrapping_tab_page.last_category_index";
    protected static final String[] INDENT_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_indentation_default, FormatterMessages.LineWrappingTabPage_indentation_on_column, FormatterMessages.LineWrappingTabPage_indentation_by_one};
    protected static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_splitting_do_not_split, FormatterMessages.LineWrappingTabPage_splitting_wrap_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_wrap_always, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_indent_all_but_first, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary};
    private final Category fCompactIfCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_compact_if", "function foo(int argument) {\n  if (argument==0)\n    return 0;\n  if (argument==1)\n    return 42;\n  else\n    return 43;\n}", FormatterMessages.LineWrappingTabPage_compact_if_else);
    private final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", "function foo(arg1, arg2, arg3, arg4, arg5, arg6) { var x = 0; return x;}", FormatterMessages.LineWrappingTabPage_parameters);
    private final Category fMessageSendArgumentsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", "function foo() {Other.bar( 100, 200, 300, 400, 500, 600, 700, 800, 900 );}", FormatterMessages.LineWrappingTabPage_arguments);
    private final Category fAllocationExpressionArgumentsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_allocation_expression", "foo( new SomeClass(100, 200, 300, 400, 500, 600, 700, 800, 900 ) );", FormatterMessages.LineWrappingTabPage_object_allocation);
    private final Category fArrayInitializerExpressionsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", "fArray= [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];", FormatterMessages.LineWrappingTabPage_array_init);
    private final Category fObjectInitializerExpressionsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", "anObject = { color:'red', wheels:4, engine:{ cylinders:4, size:2.2 } };", FormatterMessages.LineWrappingTabPage_object_init);
    private final Category fConditionalExpressionCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", "function exampleFunction( anArgument) {return anArgument ? 100000 : 200000;}", FormatterMessages.LineWrappingTabPage_conditionals);
    private final Category fBinaryExpressionCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", "function foo() {  var sum= 100 + 200 + 300 + 400 + 500 + 600 + 700 + 800;  var product= 1 * 2 * 3 * 4 * 5 * 6 * 7 * 8 * 9 * 10;  var val= true && false && true && false && true;  return product / sum;}", FormatterMessages.LineWrappingTabPage_binary_exprs);
    private final Category fAssignmentCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", "var string = \"TextTextText\";\nfunction foo() {\n    for (int i = 0; i < 10; i++) {\n    }\n    var s;\n    s = \"TextTextText\";\n}\n", FormatterMessages.LineWrappingTabPage_assignment_alignment);
    private static int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.wst.jsdt.ui.codeformatter.line_wrapping_tab_page.preview_line_width";
    protected final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    protected TreeViewer fCategoriesViewer;
    protected Label fWrappingStylePolicy;
    protected Combo fWrappingStyleCombo;
    protected Label fIndentStylePolicy;
    protected Combo fIndentStyleCombo;
    protected Button fForceSplit;
    protected CompilationUnitPreview fPreview;
    protected Group fOptionsGroup;
    private final List fCategories;
    protected final CategoryListener fCategoryListener;
    protected IStructuredSelection fSelection;
    SelectionState fSelectionState;
    protected final Map fPreviewPreferences;
    private final String LINE_SPLIT = "org.eclipse.wst.jsdt.core.formatter.lineSplit";
    private Composite fOptionsComposite;

    public LineWrappingTabPage(ModifyDialog modifyDialog, Map map) {
        super(modifyDialog, map);
        String string = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap();
        this.fPreviewPreferences.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", string != null ? string : Integer.toString(DEFAULT_PREVIEW_WINDOW_LINE_WIDTH));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
    }

    protected List createCategories() {
        Category category = new Category(null, null, FormatterMessages.LineWrappingTabPage_method_decls);
        category.children.add(this.fMethodDeclarationsParametersCategory);
        Category category2 = new Category(FormatterMessages.LineWrappingTabPage_function_calls);
        category2.children.add(this.fMessageSendArgumentsCategory);
        category2.children.add(this.fAllocationExpressionArgumentsCategory);
        Category category3 = new Category(FormatterMessages.LineWrappingTabPage_expressions);
        category3.children.add(this.fBinaryExpressionCategory);
        category3.children.add(this.fConditionalExpressionCategory);
        category3.children.add(this.fArrayInitializerExpressionsCategory);
        category3.children.add(this.fObjectInitializerExpressionsCategory);
        category3.children.add(this.fAssignmentCategory);
        Category category4 = new Category(FormatterMessages.LineWrappingTabPage_statements);
        category4.children.add(this.fCompactIfCategory);
        ArrayList<Category> arrayList = new ArrayList<Category>();
        arrayList.add(category);
        arrayList.add(category2);
        arrayList.add(category3);
        arrayList.add(category4);
        return arrayList;
    }

    protected void doCreatePreferences(Composite composite, int n) {
        this.fOptionsComposite = composite;
        Group group = this.createGroup(n, composite, FormatterMessages.LineWrappingTabPage_width_indent);
        this.createNumberPref((Composite)group, n, FormatterMessages.LineWrappingTabPage_width_indent_option_max_line_width, "org.eclipse.wst.jsdt.core.formatter.lineSplit", 0, 9999);
        this.createNumberPref((Composite)group, n, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_wrapped, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation", 0, 9999);
        this.createNumberPref((Composite)group, n, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_array, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", 0, 9999);
        this.createNumberPref((Composite)group, n, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_objlit, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_objlit_initializer", 0, 9999);
        this.fCategoriesViewer = new TreeViewer(composite, 2570);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object object) {
                return ((Collection)object).toArray();
            }

            public Object[] getChildren(Object object) {
                return ((Category)object).children.toArray();
            }

            public Object getParent(Object object) {
                return null;
            }

            public boolean hasChildren(Object object) {
                return !((Category)object).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput((Object)this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gridData = LineWrappingTabPage.createGridData(n, 1808, -1);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gridData);
        this.fOptionsGroup = this.createGroup(n, composite, "");
        this.fWrappingStylePolicy = LineWrappingTabPage.createLabel(n, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_wrapping_policy_label_text);
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(n, 256, 0));
        this.fIndentStylePolicy = LineWrappingTabPage.createLabel(n, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_indentation_policy_label_text);
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(n, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        this.fForceSplit.setLayoutData((Object)LineWrappingTabPage.createGridData(n - 1, 32, -1));
        this.fForceSplit.setText(FormatterMessages.LineWrappingTabPage_force_split_checkbox_text);
        ModifyDialogTabPage.CheckboxPreference checkboxPreference = this.createCheckboxPref((Composite)this.fOptionsGroup, 1, FormatterMessages.LineWrappingTabPage_binary_expression_wrap_operator, "org.eclipse.wst.jsdt.core.formatter.wrap_before_binary_operator", FALSE_TRUE);
        Control control = ((ModifyDialogTabPage.Preference)checkboxPreference).getControl();
        control.setVisible(false);
        ((GridData)control.getLayoutData()).exclude = true;
        this.fBinaryExpressionCategory.addPreference(checkboxPreference);
        this.fSelectionState = new SelectionState();
    }

    protected Composite doCreatePreviewPane(Composite composite, int n) {
        super.doCreatePreviewPane(composite, n);
        ModifyDialogTabPage.NumberPreference numberPreference = new ModifyDialogTabPage.NumberPreference(this, composite, n / 2, this.fPreviewPreferences, "org.eclipse.wst.jsdt.core.formatter.lineSplit", 0, 9999, FormatterMessages.LineWrappingTabPage_line_width_for_preview_label_text);
        this.fDefaultFocusManager.add(numberPreference);
        numberPreference.addObserver(this.fUpdater);
        numberPreference.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_PREVIEW_LINE_WIDTH, (String)LineWrappingTabPage.this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
            }
        });
        return composite;
    }

    protected JavaPreview doCreateJavaPreview(Composite composite) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, composite);
        return this.fPreview;
    }

    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LineWrappingTabPage.this.forceSplitChanged(LineWrappingTabPage.this.fForceSplit.getSelection());
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LineWrappingTabPage.this.indentStyleChanged(((Combo)selectionEvent.widget).getSelectionIndex());
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LineWrappingTabPage.this.wrappingStyleChanged(((Combo)selectionEvent.widget).getSelectionIndex());
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        Object v = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
        this.fPreview.update();
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", v);
    }

    protected void setPreviewText(String string) {
        Object v = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
        this.fPreview.setPreviewText(string);
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", v);
    }

    protected void forceSplitChanged(boolean bl) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String string = ((Category)iterator.next()).key;
            try {
                this.changeForceSplit(string, bl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fWorkingValues.put(string, DefaultCodeFormatterConstants.createAlignmentValue((boolean)bl, (int)0, (int)0));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, string), (Throwable)illegalArgumentException));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeForceSplit(String string, boolean bl) throws IllegalArgumentException {
        String string2 = (String)this.fWorkingValues.get(string);
        if ((string2 = DefaultCodeFormatterConstants.setForceWrapping((String)string2, (boolean)bl)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(string, string2);
    }

    protected void wrappingStyleChanged(int n) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String string = ((Category)iterator.next()).key;
            try {
                this.changeWrappingStyle(string, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fWorkingValues.put(string, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)n, (int)0));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, string), (Throwable)illegalArgumentException));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeWrappingStyle(String string, int n) throws IllegalArgumentException {
        String string2 = (String)this.fWorkingValues.get(string);
        if ((string2 = DefaultCodeFormatterConstants.setWrappingStyle((String)string2, (int)n)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(string, string2);
    }

    protected void indentStyleChanged(int n) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String string = ((Category)iterator.next()).key;
            try {
                this.changeIndentStyle(string, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fWorkingValues.put(string, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)n));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, string), (Throwable)illegalArgumentException));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeIndentStyle(String string, int n) throws IllegalArgumentException {
        String string2 = (String)this.fWorkingValues.get(string);
        if ((string2 = DefaultCodeFormatterConstants.setIndentStyle((String)string2, (int)n)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(string, string2);
    }

    protected void updateControlEnablement(boolean bl, int n) {
        boolean bl2 = n != 0;
        this.fIndentStylePolicy.setEnabled(true);
        this.fIndentStyleCombo.setEnabled(bl || bl2);
        this.fForceSplit.setEnabled(bl || bl2);
    }

    private static final class Category {
        public final String key;
        public final String name;
        public final String previewText;
        public final List children;
        public final List preferences;
        public int index;

        public Category(String string, String string2, String string3) {
            this.key = string;
            this.name = string3;
            this.previewText = string2 != null ? String.valueOf(LineWrappingTabPage.createPreviewHeader(string3)) + string2 : null;
            this.children = new ArrayList();
            this.preferences = new ArrayList();
        }

        public Category(String string) {
            this(null, null, string);
        }

        public String toString() {
            return this.name;
        }

        public void addPreference(ModifyDialogTabPage.Preference preference) {
            this.preferences.add(preference);
        }

        public ModifyDialogTabPage.Preference[] getSpecificPreferences() {
            return this.preferences.toArray(new ModifyDialogTabPage.Preference[this.preferences.size()]);
        }
    }

    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List fCategoriesList = new ArrayList();
        private int fIndex = 0;

        public CategoryListener(List list) {
            this.flatten(this.fCategoriesList, list);
        }

        private void flatten(List list, List list2) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Category category = (Category)iterator.next();
                ++this.fIndex;
                category.index = category.index;
                list.add(category);
                this.flatten(list, category.children);
            }
        }

        public void add(Category category) {
            category.index = this.fIndex++;
            this.fCategoriesList.add(category);
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (selectionChangedEvent != null) {
                LineWrappingTabPage.this.fSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
            }
            if (LineWrappingTabPage.this.fSelection.size() == 0) {
                this.disableAll();
                return;
            }
            if (!LineWrappingTabPage.this.fOptionsGroup.isEnabled()) {
                this.enableDefaultComponents(true);
            }
            LineWrappingTabPage.this.fSelectionState.refreshState(LineWrappingTabPage.this.fSelection);
            Category category = (Category)LineWrappingTabPage.this.fSelection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fOptionsGroup.setText(this.getGroupLabel(category));
        }

        private String getGroupLabel(Category category) {
            if (LineWrappingTabPage.this.fSelection.size() == 1) {
                if (LineWrappingTabPage.this.fSelectionState.getElements().size() == 1) {
                    return Messages.format(FormatterMessages.LineWrappingTabPage_group, category.name.toLowerCase());
                }
                return Messages.format(FormatterMessages.LineWrappingTabPage_multi_group, new String[]{category.name.toLowerCase(), Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_multiple_selections, new String[]{Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
        }

        private void disableAll() {
            this.enableDefaultComponents(false);
            LineWrappingTabPage.this.fIndentStyleCombo.setEnabled(false);
            LineWrappingTabPage.this.fForceSplit.setEnabled(false);
        }

        private void enableDefaultComponents(boolean bl) {
            LineWrappingTabPage.this.fOptionsGroup.setEnabled(bl);
            LineWrappingTabPage.this.fWrappingStyleCombo.setEnabled(bl);
            LineWrappingTabPage.this.fWrappingStylePolicy.setEnabled(bl);
        }

        public void restoreSelection() {
            int n;
            try {
                n = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0 || n > this.fCategoriesList.size() - 1) {
                n = 1;
            }
            Category category = (Category)this.fCategoriesList.get(n);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            ISelection iSelection = doubleClickEvent.getSelection();
            if (iSelection instanceof IStructuredSelection) {
                Category category = (Category)((IStructuredSelection)iSelection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)category, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)category));
            }
        }
    }

    private class SelectionState {
        private List fElements = new ArrayList();
        private boolean fRequiresRelayout;

        private SelectionState() {
        }

        public void refreshState(IStructuredSelection iStructuredSelection) {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            this.fRequiresRelayout = false;
            this.showSpecificControls(false);
            this.fElements.clear();
            this.evaluateElements(iStructuredSelection.iterator());
            this.evaluateMaps(hashMap, hashMap2, hashMap3);
            LineWrappingTabPage.this.setPreviewText(this.getPreviewText(hashMap, hashMap2, hashMap3));
            this.refreshControls(hashMap, hashMap2, hashMap3);
        }

        public List getElements() {
            return this.fElements;
        }

        private void evaluateElements(Iterator iterator) {
            while (iterator.hasNext()) {
                Category category = (Category)iterator.next();
                String string = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
                if (string != null) {
                    if (this.fElements.contains(category)) continue;
                    this.fElements.add(category);
                    continue;
                }
                this.evaluateElements(category.children.iterator());
            }
        }

        private void evaluateMaps(Map map, Map map2, Map map3) {
            Iterator iterator = this.fElements.iterator();
            while (iterator.hasNext()) {
                this.insertIntoMap(map, map2, map3, (Category)iterator.next());
            }
        }

        private String getPreviewText(Map map, Map map2, Map map3) {
            Iterator iterator = this.fElements.iterator();
            String string = "";
            while (iterator.hasNext()) {
                Category category = (Category)iterator.next();
                string = String.valueOf(string) + category.previewText + "\n\n";
            }
            return string;
        }

        private void insertIntoMap(Map map, Map map2, Map map3, Category category) {
            Boolean bl;
            Integer n;
            Integer n2;
            String string = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
            try {
                n2 = new Integer(DefaultCodeFormatterConstants.getWrappingStyle((String)string));
                n = new Integer(DefaultCodeFormatterConstants.getIndentStyle((String)string));
                bl = new Boolean(DefaultCodeFormatterConstants.getForceWrapping((String)string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = new Boolean(false);
                n = new Integer(0);
                n2 = new Integer(0);
            }
            this.increaseMapEntry(map, n2);
            this.increaseMapEntry(map2, n);
            this.increaseMapEntry(map3, bl);
        }

        private void increaseMapEntry(Map map, Object object) {
            Integer n = (Integer)map.get(object);
            if (n == null) {
                map.put(object, new Integer(1));
            } else {
                map.put(object, new Integer(n + 1));
            }
        }

        private void refreshControls(Map map, Map map2, Map map3) {
            this.updateCombos(map, map2);
            this.updateButton(map3);
            Integer n = this.getWrappingStyleMax(map);
            boolean bl = this.fElements.size() != ((Integer)map.get(n)).intValue();
            LineWrappingTabPage.this.updateControlEnablement(bl, n);
            this.showSpecificControls(true);
            if (this.fRequiresRelayout) {
                LineWrappingTabPage.this.fOptionsComposite.layout(true, true);
            }
            LineWrappingTabPage.this.doUpdatePreview();
            LineWrappingTabPage.this.notifyValuesModified();
        }

        private void showSpecificControls(boolean bl) {
            if (this.fElements.size() != 1) {
                return;
            }
            ModifyDialogTabPage.Preference[] preferenceArray = ((Category)this.fElements.get(0)).getSpecificPreferences();
            if (preferenceArray.length == 0) {
                return;
            }
            this.fRequiresRelayout = true;
            int n = 0;
            while (n < preferenceArray.length) {
                ModifyDialogTabPage.Preference preference = preferenceArray[n];
                Control control = preference.getControl();
                control.setVisible(bl);
                ((GridData)control.getLayoutData()).exclude = !bl;
                ++n;
            }
        }

        private Integer getWrappingStyleMax(Map map) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < WRAPPING_NAMES.length) {
                Integer n4 = (Integer)map.get(new Integer(n3));
                if (n4 != null && n4 > n) {
                    n = n4;
                    n2 = n3;
                }
                ++n3;
            }
            return new Integer(n2);
        }

        private void updateButton(Map map) {
            Integer n = (Integer)map.get(Boolean.TRUE);
            Integer n2 = (Integer)map.get(Boolean.FALSE);
            if (n == null || n2 == null) {
                LineWrappingTabPage.this.fForceSplit.setSelection(n != null);
            } else {
                LineWrappingTabPage.this.fForceSplit.setSelection(n > n2);
            }
            int n3 = this.getMax(n, n2);
            String string = FormatterMessages.LineWrappingTabPage_force_split_checkbox_multi_text;
            LineWrappingTabPage.this.fForceSplit.setText(this.getLabelText(string, n3, this.fElements.size()));
        }

        private String getLabelText(String string, int n, int n2) {
            if (n2 == 1 || n == 0) {
                return string;
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_occurences, new String[]{string, Integer.toString(n), Integer.toString(n2)});
        }

        private int getMax(Integer n, Integer n2) {
            if (n == null) {
                return n2;
            }
            if (n2 == null) {
                return n;
            }
            if (n.compareTo(n2) >= 0) {
                return n;
            }
            return n2;
        }

        private void updateCombos(Map map, Map map2) {
            this.updateCombo(LineWrappingTabPage.this.fWrappingStyleCombo, map, WRAPPING_NAMES);
            this.updateCombo(LineWrappingTabPage.this.fIndentStyleCombo, map2, INDENT_NAMES);
        }

        private void updateCombo(Combo combo, Map map, String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray.length) {
                int n4;
                Integer n5 = (Integer)map.get(new Integer(n3));
                int n6 = n4 = n5 == null ? 0 : n5;
                if (n4 > n) {
                    n = n4;
                    n2 = n3;
                }
                stringArray2[n3] = this.getLabelText(stringArray[n3], n4, this.fElements.size());
                ++n3;
            }
            combo.setItems(stringArray2);
            combo.setText(stringArray2[n2]);
        }
    }
}

