/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;

public abstract class ModifyDialogTabPage {
    protected final Observer fUpdater = new Observer(){

        public void update(Observable observable, Object object) {
            ModifyDialogTabPage.this.doUpdatePreview();
            ModifyDialogTabPage.this.notifyValuesModified();
        }
    };
    protected final DefaultFocusManager fDefaultFocusManager;
    protected PixelConverter fPixelConverter;
    protected final Map fWorkingValues;
    private final IModificationListener fModifyListener;

    public ModifyDialogTabPage(IModificationListener iModificationListener, Map map) {
        this.fWorkingValues = map;
        this.fModifyListener = iModificationListener;
        this.fDefaultFocusManager = new DefaultFocusManager();
    }

    public final Composite createContents(Composite composite) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)composite);
        }
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setFont(composite.getFont());
        Composite composite2 = new Composite((Composite)sashForm, 0);
        composite2.setFont(sashForm.getFont());
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        gridLayout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        gridLayout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        this.doCreatePreferences(composite2, 4);
        Composite composite3 = new Composite((Composite)sashForm, 0);
        composite3.setLayout((Layout)this.createGridLayout(4, true));
        composite3.setFont(sashForm.getFont());
        this.doCreatePreviewPane(composite3, 4);
        this.initializePage();
        sashForm.setWeights(new int[]{3, 3});
        return sashForm;
    }

    protected abstract void initializePage();

    protected abstract void doCreatePreferences(Composite var1, int var2);

    protected Composite doCreatePreviewPane(Composite composite, int n) {
        ModifyDialogTabPage.createLabel(n, composite, FormatterMessages.ModifyDialogTabPage_preview_label_text);
        JavaPreview javaPreview = this.doCreateJavaPreview(composite);
        this.fDefaultFocusManager.add(javaPreview.getControl());
        GridData gridData = ModifyDialogTabPage.createGridData(n, 1808, 0);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        javaPreview.getControl().setLayoutData((Object)gridData);
        return composite;
    }

    protected abstract JavaPreview doCreateJavaPreview(Composite var1);

    public final void makeVisible() {
        this.fDefaultFocusManager.resetFocus();
        this.doUpdatePreview();
    }

    protected abstract void doUpdatePreview();

    protected void notifyValuesModified() {
        this.fModifyListener.valuesModified();
    }

    public void setInitialFocus() {
        if (this.fDefaultFocusManager.isUsed()) {
            this.fDefaultFocusManager.restoreFocus();
        }
    }

    protected void updateStatus(IStatus iStatus) {
        this.fModifyListener.updateStatus(iStatus);
    }

    protected GridLayout createGridLayout(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (bl) {
            gridLayout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            gridLayout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
        }
        return gridLayout;
    }

    protected static GridData createGridData(int n, int n2, int n3) {
        GridData gridData = new GridData(n2);
        gridData.horizontalSpan = n;
        gridData.widthHint = n3;
        return gridData;
    }

    protected static Label createLabel(int n, Composite composite, String string) {
        return ModifyDialogTabPage.createLabel(n, composite, string, 768);
    }

    protected static Label createLabel(int n, Composite composite, String string, int n2) {
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(string);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        label.setLayoutData((Object)ModifyDialogTabPage.createGridData(n, n2, pixelConverter.convertHorizontalDLUsToPixels(150)));
        return label;
    }

    protected Group createGroup(int n, Composite composite, String string) {
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setLayoutData((Object)ModifyDialogTabPage.createGridData(n, 768, -1));
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        gridLayout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        group.setLayout((Layout)gridLayout);
        group.setText(string);
        return group;
    }

    protected NumberPreference createNumberPref(Composite composite, int n, String string, String string2, int n2, int n3) {
        NumberPreference numberPreference = new NumberPreference(composite, n, this.fWorkingValues, string2, n2, n3, string);
        this.fDefaultFocusManager.add(numberPreference);
        numberPreference.addObserver(this.fUpdater);
        return numberPreference;
    }

    protected ComboPreference createComboPref(Composite composite, int n, String string, String string2, String[] stringArray, String[] stringArray2) {
        ComboPreference comboPreference = new ComboPreference(composite, n, this.fWorkingValues, string2, stringArray, string, stringArray2);
        this.fDefaultFocusManager.add(comboPreference);
        comboPreference.addObserver(this.fUpdater);
        return comboPreference;
    }

    protected CheckboxPreference createCheckboxPref(Composite composite, int n, String string, String string2, String[] stringArray) {
        CheckboxPreference checkboxPreference = new CheckboxPreference(composite, n, this.fWorkingValues, string2, stringArray, string);
        this.fDefaultFocusManager.add(checkboxPreference);
        checkboxPreference.addObserver(this.fUpdater);
        return checkboxPreference;
    }

    protected RadioPreference createRadioPref(Composite composite, int n, String string, String string2, String[] stringArray) {
        RadioPreference radioPreference = new RadioPreference(composite, n, this.fWorkingValues, string2, stringArray, string);
        this.fDefaultFocusManager.add(radioPreference);
        radioPreference.addObserver(this.fUpdater);
        return radioPreference;
    }

    protected static String createPreviewHeader(String string) {
        return "/**\n* " + string + "\n*/\n";
    }

    protected class ButtonPreference
    extends Preference {
        private final String[] fValues;
        private final Button fCheckbox;

        public ButtonPreference(Composite composite, int n, Map map, String string, String[] stringArray, String string2, int n2) {
            super(map, string);
            if (stringArray == null || string2 == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_text_unassigned);
            }
            this.fValues = stringArray;
            this.fCheckbox = new Button(composite, n2);
            this.fCheckbox.setText(string2);
            this.fCheckbox.setLayoutData((Object)ModifyDialogTabPage.createGridData(n, 768, -1));
            this.fCheckbox.setFont(composite.getFont());
            this.updateWidget();
            this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ButtonPreference this$1;
                {
                    this.this$1 = buttonPreference;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.checkboxChecked(((Button)selectionEvent.widget).getSelection());
                }
            });
        }

        protected void checkboxChecked(boolean bl) {
            this.getPreferences().put(this.getKey(), bl ? this.fValues[1] : this.fValues[0]);
            this.setChanged();
            this.notifyObservers();
        }

        protected void updateWidget() {
            if (this.getKey() != null) {
                this.fCheckbox.setEnabled(this.getEnabled());
                this.fCheckbox.setSelection(this.getChecked());
            } else {
                this.fCheckbox.setSelection(false);
                this.fCheckbox.setEnabled(false);
            }
        }

        public boolean getChecked() {
            return this.fValues[1].equals(this.getPreferences().get(this.getKey()));
        }

        public void setChecked(boolean bl) {
            this.getPreferences().put(this.getKey(), bl ? this.fValues[1] : this.fValues[0]);
            this.updateWidget();
            this.checkboxChecked(bl);
        }

        public Control getControl() {
            return this.fCheckbox;
        }
    }

    protected final class CheckboxPreference
    extends ButtonPreference {
        public CheckboxPreference(Composite composite, int n, Map map, String string, String[] stringArray, String string2) {
            super(composite, n, map, string, stringArray, string2, 32);
        }
    }

    protected final class ComboPreference
    extends Preference {
        private final String[] fItems;
        private final String[] fValues;
        private final Combo fCombo;

        public ComboPreference(Composite composite, int n, Map map, String string, String[] stringArray, String string2, String[] stringArray2) {
            super(map, string);
            if (stringArray == null || stringArray2 == null || string2 == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_items_text_unassigned);
            }
            this.fValues = stringArray;
            this.fItems = stringArray2;
            ModifyDialogTabPage.createLabel(n - 1, composite, string2);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setFont(composite.getFont());
            this.fCombo.setItems(stringArray2);
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray2[n3].length() > n2) {
                    n2 = stringArray2[n3].length();
                }
                ++n3;
            }
            this.fCombo.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 256, this.fCombo.computeSize((int)-1, (int)-1).x));
            this.updateWidget();
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ComboPreference this$1;
                {
                    this.this$1 = comboPreference;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.comboSelected(((Combo)selectionEvent.widget).getSelectionIndex());
                }
            });
        }

        protected void comboSelected(int n) {
            this.getPreferences().put(this.getKey(), this.fValues[n]);
            this.setChanged();
            this.notifyObservers(this.fValues[n]);
        }

        protected void updateWidget() {
            if (this.getKey() != null) {
                this.fCombo.setEnabled(this.getEnabled());
                this.fCombo.setText(this.getSelectedItem());
            } else {
                this.fCombo.setText("");
                this.fCombo.setEnabled(false);
            }
        }

        public String getSelectedItem() {
            String string = (String)this.getPreferences().get(this.getKey());
            int n = 0;
            while (n < this.fValues.length) {
                if (this.fValues[n].equals(string)) {
                    return this.fItems[n];
                }
                ++n;
            }
            return "";
        }

        public boolean hasValue(String string) {
            return string.equals(this.getPreferences().get(this.getKey()));
        }

        public Control getControl() {
            return this.fCombo;
        }
    }

    protected static final class DefaultFocusManager
    extends FocusAdapter {
        private static final String PREF_LAST_FOCUS_INDEX = "org.eclipse.wst.jsdt.uiformatter_page.modify_dialog_tab_page.last_focus_index";
        private final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        private final Map fItemMap = new HashMap();
        private final List fItemList = new ArrayList();
        private int fIndex = 0;

        public void focusGained(FocusEvent focusEvent) {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, ((Integer)this.fItemMap.get(focusEvent.widget)).intValue());
        }

        public void add(Control control) {
            control.addFocusListener((FocusListener)this);
            this.fItemList.add(this.fIndex, control);
            this.fItemMap.put(control, new Integer(this.fIndex++));
        }

        public void add(Preference preference) {
            Control control = preference.getControl();
            if (control != null) {
                this.add(control);
            }
        }

        public boolean isUsed() {
            return this.fIndex != 0;
        }

        public void restoreFocus() {
            int n = 0;
            try {
                n = this.fDialogSettings.getInt(PREF_LAST_FOCUS_INDEX);
                if (n >= 0 && n <= this.fItemList.size() - 1) {
                    ((Control)this.fItemList.get(n)).setFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        public void resetFocus() {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, -1);
        }
    }

    public static interface IModificationListener {
        public void updateStatus(IStatus var1);

        public void valuesModified();
    }

    protected final class NumberPreference
    extends Preference {
        private final int fMinValue;
        private final int fMaxValue;
        private final Label fNumberLabel;
        private final Text fNumberText;
        protected int fSelected;
        protected int fOldSelected;

        public NumberPreference(Composite composite, int n, Map map, String string, int n2, int n3, String string2) {
            super(map, string);
            this.fNumberLabel = ModifyDialogTabPage.createLabel(n - 1, composite, string2, 768);
            this.fNumberText = new Text(composite, 133124);
            this.fNumberText.setFont(composite.getFont());
            int n4 = Integer.toString(n3).length() + 3;
            this.fNumberText.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 128, ModifyDialogTabPage.this.fPixelConverter.convertWidthInCharsToPixels(n4)));
            this.fMinValue = n2;
            this.fMaxValue = n3;
            this.updateWidget();
            this.fNumberText.addFocusListener(new FocusListener(this){
                final /* synthetic */ NumberPreference this$1;
                {
                    this.this$1 = numberPreference;
                }

                public void focusGained(FocusEvent focusEvent) {
                    this.this$1.focusGained();
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.focusLost();
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ NumberPreference this$1;
                {
                    this.this$1 = numberPreference;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.fieldModified();
                }
            });
        }

        private IStatus createErrorStatus() {
            return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.ModifyDialogTabPage_NumberPreference_error_invalid_value, new String[]{Integer.toString(this.fMinValue), Integer.toString(this.fMaxValue)}), null);
        }

        protected void focusGained() {
            this.fOldSelected = this.fSelected;
            this.fNumberText.setSelection(0, this.fNumberText.getCharCount());
        }

        protected void focusLost() {
            ModifyDialogTabPage.this.updateStatus(null);
            String string = this.fNumberText.getText();
            this.fSelected = !this.validInput(string) ? this.fOldSelected : Integer.parseInt(string);
            if (this.fSelected != this.fOldSelected) {
                this.saveSelected();
                this.fNumberText.setText(Integer.toString(this.fSelected));
            }
        }

        protected void fieldModified() {
            int n;
            String string = this.fNumberText.getText().trim();
            boolean bl = this.validInput(string);
            ModifyDialogTabPage.this.updateStatus(bl ? null : this.createErrorStatus());
            if (bl && this.fSelected != (n = Integer.parseInt(string))) {
                this.fSelected = n;
                this.saveSelected();
            }
        }

        private boolean validInput(String string) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n < this.fMinValue) {
                return false;
            }
            return n <= this.fMaxValue;
        }

        private void saveSelected() {
            this.getPreferences().put(this.getKey(), Integer.toString(this.fSelected));
            this.setChanged();
            this.notifyObservers();
        }

        protected void updateWidget() {
            boolean bl = this.getKey() != null;
            this.fNumberLabel.setEnabled(bl && this.getEnabled());
            this.fNumberText.setEnabled(bl && this.getEnabled());
            if (bl) {
                String string = (String)this.getPreferences().get(this.getKey());
                try {
                    this.fSelected = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = Messages.format(FormatterMessages.ModifyDialogTabPage_NumberPreference_error_invalid_key, this.getKey());
                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, string2, (Throwable)numberFormatException));
                    string = "";
                }
                this.fNumberText.setText(string);
            } else {
                this.fNumberText.setText("");
            }
        }

        public Control getControl() {
            return this.fNumberText;
        }
    }

    protected abstract class Preference
    extends Observable {
        private final Map fPreferences;
        private boolean fEnabled;
        private String fKey;

        public Preference(Map map, String string) {
            this.fPreferences = map;
            this.fEnabled = true;
            this.fKey = string;
        }

        protected final Map getPreferences() {
            return this.fPreferences;
        }

        public final void setEnabled(boolean bl) {
            this.fEnabled = bl;
            this.updateWidget();
        }

        public final boolean getEnabled() {
            return this.fEnabled;
        }

        public final void setKey(String string) {
            if (string == null || !this.fKey.equals(string)) {
                this.fKey = string;
                this.updateWidget();
            }
        }

        public final String getKey() {
            return this.fKey;
        }

        public abstract Control getControl();

        protected abstract void updateWidget();
    }

    protected final class RadioPreference
    extends ButtonPreference {
        public RadioPreference(Composite composite, int n, Map map, String string, String[] stringArray, String string2) {
            super(composite, n, map, string, stringArray, string2, 16);
        }
    }
}

