/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.VariableNamesProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.RowLayouter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class ExtractConstantWizard
extends RefactoringWizard {
    private static final String MESSAGE = RefactoringMessages.ExtractConstantInputPage_enter_name;

    public ExtractConstantWizard(ExtractConstantRefactoring extractConstantRefactoring) {
        super((Refactoring)extractConstantRefactoring, 36);
        this.setDefaultPageTitle(RefactoringMessages.ExtractConstantWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        String string = null;
        int n = 0;
        if (!this.getExtractConstantRefactoring().selectionAllStaticFinal()) {
            string = RefactoringMessages.ExtractConstantInputPage_selection_refers_to_nonfinal_fields;
            n = 1;
        } else {
            string = MESSAGE;
            n = 0;
        }
        String[] stringArray = this.getExtractConstantRefactoring().guessConstantNames();
        String string2 = stringArray.length == 0 ? "" : stringArray[0];
        this.addPage((IWizardPage)new ExtractConstantInputPage(string, n, string2, stringArray));
    }

    private ExtractConstantRefactoring getExtractConstantRefactoring() {
        return (ExtractConstantRefactoring)this.getRefactoring();
    }

    private static class ExtractConstantInputPage
    extends TextInputWizardPage {
        private static final String QUALIFY_REFERENCES = "qualifyReferences";
        private Label fLabel;
        private final boolean fInitialValid;
        private final int fOriginalMessageType;
        private final String fOriginalMessage;
        private Button fQualifyReferences;
        private String[] fConstNameProposals;
        private VariableNamesProcessor fContentAssistProcessor;
        private String fAccessModifier;

        public ExtractConstantInputPage(String string, int n, String string2, String[] stringArray) {
            super(string, true, string2);
            this.fOriginalMessage = string;
            this.fOriginalMessageType = n;
            this.fInitialValid = !"".equals(string2);
            this.fConstNameProposals = stringArray;
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            this.setControl((Control)composite2);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 8;
            composite2.setLayout((Layout)gridLayout);
            RowLayouter rowLayouter = new RowLayouter(2);
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ExtractConstantInputPage_constant_name);
            Text text = this.createTextInputField(composite2);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            if (this.fConstNameProposals.length > 0) {
                this.fContentAssistProcessor = new VariableNamesProcessor(this.fConstNameProposals);
                ControlContentAssistHelper.createTextContentAssistant(text, this.fContentAssistProcessor);
            }
            rowLayouter.perform((Control)label, (Control)text, 1);
            this.addAccessModifierGroup(composite2, rowLayouter);
            this.addReplaceAllCheckbox(composite2, rowLayouter);
            this.addQualifyReferencesCheckbox(composite2, rowLayouter);
            this.addSeparator(composite2, rowLayouter);
            this.addLabel(composite2, rowLayouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)composite2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.extract_constant_page_context");
        }

        private void addAccessModifierGroup(Composite composite, RowLayouter rowLayouter) {
            this.fAccessModifier = this.getExtractConstantRefactoring().getVisibility();
            if (this.getExtractConstantRefactoring().getTargetIsInterface()) {
                return;
            }
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.ExtractConstantInputPage_access_modifiers);
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            String[] stringArray = new String[]{RefactoringMessages.ExtractMethodInputPage_public, RefactoringMessages.ExtractMethodInputPage_protected, RefactoringMessages.ExtractMethodInputPage_default, RefactoringMessages.ExtractMethodInputPage_private};
            String[] stringArray2 = new String[]{"public", "protected", "", "private"};
            this.updateContentAssistImage();
            int n = 0;
            while (n < stringArray.length) {
                Button button = new Button(composite2, 16);
                button.setText(stringArray[n]);
                button.setData((Object)stringArray2[n]);
                if (stringArray2[n] == this.fAccessModifier) {
                    button.setSelection(true);
                }
                button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ ExtractConstantInputPage this$1;
                    {
                        this.this$1 = extractConstantInputPage;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        ExtractConstantInputPage.access$0(this.this$1, (String)selectionEvent.widget.getData());
                    }
                });
                ++n;
            }
            rowLayouter.perform((Control)label, (Control)composite2, 1);
        }

        private void updateContentAssistImage() {
            if (this.fContentAssistProcessor == null) {
                return;
            }
            int n = this.fAccessModifier == "private" ? 2 : (this.fAccessModifier == "protected" ? 4 : (this.fAccessModifier == "public" ? 1 : 0));
            Object object = JavaElementImageProvider.getFieldImageDescriptor(false, n);
            object = new JavaElementImageDescriptor((ImageDescriptor)object, 10, JavaElementImageProvider.BIG_SIZE);
            this.fContentAssistProcessor.setProposalImageDescriptor((ImageDescriptor)object);
        }

        private void addReplaceAllCheckbox(Composite composite, RowLayouter rowLayouter) {
            String string = RefactoringMessages.ExtractConstantInputPage_replace_all;
            boolean bl = this.getExtractConstantRefactoring().replaceAllOccurrences();
            Button button = ExtractConstantInputPage.createCheckbox(composite, string, bl, rowLayouter);
            this.getExtractConstantRefactoring().setReplaceAllOccurrences(button.getSelection());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ ExtractConstantInputPage this$1;
                private final /* synthetic */ Button val$checkBox;
                {
                    this.this$1 = extractConstantInputPage;
                    this.val$checkBox = button;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractConstantInputPage.access$1(this.this$1).setReplaceAllOccurrences(this.val$checkBox.getSelection());
                }
            });
        }

        private void addQualifyReferencesCheckbox(Composite composite, RowLayouter rowLayouter) {
            String string = RefactoringMessages.ExtractConstantInputPage_qualify_constant_references_with_class_name;
            boolean bl = this.getBooleanSetting(QUALIFY_REFERENCES, this.getExtractConstantRefactoring().qualifyReferencesWithDeclaringClassName());
            this.fQualifyReferences = ExtractConstantInputPage.createCheckbox(composite, string, bl, rowLayouter);
            this.getExtractConstantRefactoring().setQualifyReferencesWithDeclaringClassName(this.fQualifyReferences.getSelection());
            this.fQualifyReferences.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ExtractConstantInputPage this$1;
                {
                    this.this$1 = extractConstantInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractConstantInputPage.access$1(this.this$1).setQualifyReferencesWithDeclaringClassName(ExtractConstantInputPage.access$2(this.this$1).getSelection());
                }
            });
        }

        private void addLabel(Composite composite, RowLayouter rowLayouter) {
            this.fLabel = new Label(composite, 64);
            GridData gridData = new GridData(1808);
            gridData.widthHint = this.convertWidthInCharsToPixels(50);
            this.fLabel.setLayoutData((Object)gridData);
            this.updatePreviewLabel();
            rowLayouter.perform((Control)this.fLabel);
        }

        private void addSeparator(Composite composite, RowLayouter rowLayouter) {
            Label label = new Label(composite, 258);
            label.setLayoutData((Object)new GridData(768));
            rowLayouter.perform((Control)label);
        }

        private void updatePreviewLabel() {
            try {
                if (this.fLabel != null) {
                    this.fLabel.setText(String.valueOf(RefactoringMessages.ExtractConstantInputPage_signature_preview) + this.getExtractConstantRefactoring().getConstantSignaturePreview());
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ExtractTempInputPage_extract_local, RefactoringMessages.ExtractConstantInputPage_exception);
            }
        }

        protected RefactoringStatus validateTextField(String string) {
            try {
                this.getExtractConstantRefactoring().setConstantName(string);
                this.updatePreviewLabel();
                RefactoringStatus refactoringStatus = this.getExtractConstantRefactoring().checkConstantNameOnChange();
                if (this.fOriginalMessageType == 1 && refactoringStatus.getSeverity() == 0) {
                    return RefactoringStatus.createInfoStatus((String)this.fOriginalMessage);
                }
                return refactoringStatus;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.ExtractConstantInputPage_Internal_Error);
            }
        }

        private void setAccessModifier(String string) {
            this.getExtractConstantRefactoring().setVisibility(string);
            this.fAccessModifier = string;
            this.updateContentAssistImage();
            this.updatePreviewLabel();
        }

        private ExtractConstantRefactoring getExtractConstantRefactoring() {
            return (ExtractConstantRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite composite, String string, boolean bl, RowLayouter rowLayouter) {
            Button button = new Button(composite, 32);
            button.setText(string);
            button.setSelection(bl);
            rowLayouter.perform((Control)button);
            return button;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }

        protected void restoreMessage() {
            this.setMessage(this.fOriginalMessage, this.fOriginalMessageType);
        }

        private boolean getBooleanSetting(String string, boolean bl) {
            String string2 = this.getRefactoringSettings().get(string);
            if (string2 != null) {
                return Boolean.valueOf(string2);
            }
            return bl;
        }

        private void saveBooleanSetting(String string, Button button) {
            if (button != null) {
                this.getRefactoringSettings().put(string, button.getSelection());
            }
        }

        private boolean saveSettings() {
            if (this.getContainer() instanceof Dialog) {
                return ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            return true;
        }

        public void dispose() {
            if (this.saveSettings()) {
                this.saveBooleanSetting(QUALIFY_REFERENCES, this.fQualifyReferences);
            }
            super.dispose();
        }

        static /* synthetic */ void access$0(ExtractConstantInputPage extractConstantInputPage, String string) {
            extractConstantInputPage.setAccessModifier(string);
        }

        static /* synthetic */ ExtractConstantRefactoring access$1(ExtractConstantInputPage extractConstantInputPage) {
            return extractConstantInputPage.getExtractConstantRefactoring();
        }

        static /* synthetic */ Button access$2(ExtractConstantInputPage extractConstantInputPage) {
            return extractConstantInputPage.fQualifyReferences;
        }
    }
}

