/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.wst.jsdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class IntroduceParameterWizard
extends RefactoringWizard {
    public IntroduceParameterWizard(IntroduceParameterRefactoring introduceParameterRefactoring) {
        super((Refactoring)introduceParameterRefactoring, 36);
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterInputPage(this.getIntroduceParameterRefactoring().guessParameterNames()));
    }

    private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
        return (IntroduceParameterRefactoring)this.getRefactoring();
    }

    private static class IntroduceParameterInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = RefactoringMessages.IntroduceParameterInputPage_description;
        public static final String PAGE_NAME = "IntroduceParameterInputPage";
        private String[] fParamNameProposals;
        private JavaSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;

        public IntroduceParameterInputPage(String[] stringArray) {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
            Assert.isNotNull((Object)stringArray);
            this.fParamNameProposals = stringArray;
            this.fSignaturePreviewDocument = new Document();
        }

        private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
            return (IntroduceParameterRefactoring)this.getRefactoring();
        }

        public void createControl(Composite composite) {
            Label label;
            Composite composite2 = new Composite(composite, 0);
            this.setControl((Control)composite2);
            GridLayout gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            this.createParameterTableControl(composite2);
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(composite2, this.getRefactoring(), false);
            if (this.fLeaveDelegateCheckBox != null) {
                this.fDeprecateDelegateCheckBox = new Button(composite2, 32);
                label = new GridData();
                label.horizontalAlignment = 4;
                label.horizontalIndent = gridLayout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)label);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                IntroduceParameterRefactoring introduceParameterRefactoring = this.getIntroduceParameterRefactoring();
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(introduceParameterRefactoring));
                introduceParameterRefactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, introduceParameterRefactoring){
                    final /* synthetic */ IntroduceParameterInputPage this$1;
                    private final /* synthetic */ IntroduceParameterRefactoring val$refactoring;
                    {
                        this.this$1 = introduceParameterInputPage;
                        this.val$refactoring = introduceParameterRefactoring;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        this.val$refactoring.setDeprecateDelegates(IntroduceParameterInputPage.access$0(this.this$1).getSelection());
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ IntroduceParameterInputPage this$1;
                    {
                        this.this$1 = introduceParameterInputPage;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        IntroduceParameterInputPage.access$0(this.this$1).setEnabled(IntroduceParameterInputPage.access$1(this.this$1).getSelection());
                    }
                });
            }
            label = new Label(composite2, 258);
            label.setLayoutData((Object)new GridData(768));
            this.createSignaturePreview(composite2);
            this.update(false);
            Dialog.applyDialogFont((Control)composite2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.introduce_parameter_page_context");
        }

        private ChangeParametersControl createParameterTableControl(Composite composite) {
            String string = RefactoringMessages.IntroduceParameterWizard_parameters;
            ChangeParametersControl changeParametersControl = new ChangeParametersControl(composite, 0, string, new IParameterListChangeListener(this){
                final /* synthetic */ IntroduceParameterInputPage this$1;
                {
                    this.this$1 = introduceParameterInputPage;
                }

                public void parameterChanged(ParameterInfo parameterInfo) {
                    IntroduceParameterInputPage.access$2(this.this$1, true);
                }

                public void parameterListChanged() {
                    IntroduceParameterInputPage.access$2(this.this$1, true);
                }

                public void parameterAdded(ParameterInfo parameterInfo) {
                    IntroduceParameterInputPage.access$2(this.this$1, true);
                }
            }, ChangeParametersControl.Mode.INTRODUCE_PARAMETER, this.fParamNameProposals);
            changeParametersControl.setLayoutData(new GridData(1808));
            changeParametersControl.setInput(this.getIntroduceParameterRefactoring().getParameterInfos());
            changeParametersControl.editParameter(this.getIntroduceParameterRefactoring().getAddedParameterInfo());
            return changeParametersControl;
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void createSignaturePreview(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, iPreferenceStore);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), iPreferenceStore, null, null));
            this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control control = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(control);
            GridData gridData = new GridData(1808);
            gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            control.setLayoutData((Object)gridData);
        }

        private void update(boolean bl) {
            this.updateStatus(bl);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean bl) {
            RefactoringStatus refactoringStatus = this.getIntroduceParameterRefactoring().validateInput();
            if (bl) {
                this.setPageComplete(refactoringStatus);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private void updateSignaturePreview() {
            try {
                int n = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.getIntroduceParameterRefactoring().getMethodSignaturePreview());
                this.fSignaturePreview.getTextWidget().setTopPixel(n);
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.IntroduceParameterWizard_defaultPageTitle, RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }

        static /* synthetic */ Button access$0(IntroduceParameterInputPage introduceParameterInputPage) {
            return introduceParameterInputPage.fDeprecateDelegateCheckBox;
        }

        static /* synthetic */ Button access$1(IntroduceParameterInputPage introduceParameterInputPage) {
            return introduceParameterInputPage.fLeaveDelegateCheckBox;
        }

        static /* synthetic */ void access$2(IntroduceParameterInputPage introduceParameterInputPage, boolean bl) {
            introduceParameterInputPage.update(bl);
        }
    }
}

