/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.AccessorDescription;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.MultiStateCellEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSAccessorConfigurationDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.RenameKeysDialog;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

class ExternalizeWizardPage
extends UserInputWizardPage {
    private static final String[] PROPERTIES = new String[3];
    private static final String[] fgTitles;
    private static final int STATE_PROP = 0;
    private static final int VAL_PROP = 1;
    private static final int KEY_PROP = 2;
    private static final int SIZE = 3;
    private static final int ROW_COUNT = 5;
    public static final String PAGE_NAME = "NLSWizardPage1";
    private static final String SETTINGS_NLS_ACCESSORS = "nls_accessor_history";
    private static final int SETTINGS_MAX_ENTRIES = 5;
    private Text fPrefixField;
    private Button fIsEclipseNLS;
    private Table fTable;
    private TableViewer fTableViewer;
    private SourceViewer fSourceViewer;
    private final ICompilationUnit fCu;
    private NLSSubstitution[] fSubstitutions;
    private Button fExternalizeButton;
    private Button fIgnoreButton;
    private Button fInternalizeButton;
    private Button fRevertButton;
    private Button fEditButton;
    private NLSRefactoring fNLSRefactoring;
    private Button fRenameButton;
    private Combo fAccessorClassField;
    private AccessorDescription[] fAccessorChoices;
    private Button fFilterCheckBox;

    static {
        ExternalizeWizardPage.PROPERTIES[0] = "task";
        ExternalizeWizardPage.PROPERTIES[2] = "key";
        ExternalizeWizardPage.PROPERTIES[1] = "value";
        fgTitles = new String[3];
        ExternalizeWizardPage.fgTitles[0] = "";
        ExternalizeWizardPage.fgTitles[2] = NLSUIMessages.ExternalizeWizardPage_key;
        ExternalizeWizardPage.fgTitles[1] = NLSUIMessages.ExternalizeWizardPage_value;
    }

    private static String unwindEscapeChars(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                stringBuffer.append(ExternalizeWizardPage.getUnwoundString(c));
                ++n2;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private static String windEscapeChars(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                if ((c = string.charAt(n2++)) == 'u') {
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < 4) {
                        c = string.charAt(n2++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n3 = (n3 << 4) + c - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n3 = (n3 << 4) + 10 + c - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n3 = (n3 << 4) + 10 + c - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n4;
                    }
                    stringBuffer.append((char)n3);
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public ExternalizeWizardPage(NLSRefactoring nLSRefactoring) {
        super(PAGE_NAME);
        this.fCu = nLSRefactoring.getCu();
        this.fSubstitutions = nLSRefactoring.getSubstitutions();
        this.fNLSRefactoring = nLSRefactoring;
        this.fAccessorChoices = null;
        this.setDescription(NLSUIMessages.ExternalizeWizardPage_description);
        this.createDefaultExternalization(this.fSubstitutions, nLSRefactoring.getPrefix());
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        this.createIsEclipseNLSCheckbox(composite2);
        this.createKeyPrefixField(composite2);
        SashForm sashForm = new SashForm(composite2, 512);
        sashForm.setFont(composite2.getFont());
        GridData gridData = new GridData(1808);
        sashForm.setLayoutData((Object)gridData);
        this.createTableViewer((Composite)sashForm);
        this.createSourceViewer((Composite)sashForm);
        this.createAccessorInfoComposite(composite2);
        sashForm.setWeights(new int[]{65, 45});
        this.validateKeys(false);
        this.updateButtonStates((IStructuredSelection)StructuredSelection.EMPTY);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.externalize_wizard_keyvalue_page_context");
    }

    private void createAccessorInfoComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(NLSUIMessages.ExternalizeWizardPage_accessorclass_label);
        label.setLayoutData((Object)new GridData());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    ExternalizeWizardPage.this.doConfigureButtonPressed();
                } else {
                    ExternalizeWizardPage.this.doAccessorSelectionChanged();
                }
            }
        };
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(30);
        this.fAccessorClassField = new Combo(composite3, 8);
        this.fAccessorClassField.setLayoutData((Object)gridData);
        this.fAccessorClassField.addSelectionListener((SelectionListener)selectionAdapter);
        Button button = new Button(composite2, 8);
        button.setText(NLSUIMessages.ExternalizeWizardPage_configure_button);
        gridData = new GridData(136);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        this.updateAccessorChoices();
    }

    protected void doAccessorSelectionChanged() {
        int n = this.fAccessorClassField.getSelectionIndex();
        if (this.fAccessorChoices != null && n < this.fAccessorChoices.length) {
            AccessorDescription accessorDescription = this.fAccessorChoices[n];
            this.fNLSRefactoring.setAccessorClassName(accessorDescription.getAccessorClassName());
            this.fNLSRefactoring.setAccessorClassPackage(accessorDescription.getAccessorClassPackage());
            this.fNLSRefactoring.setResourceBundleName(accessorDescription.getResourceBundleName());
            this.fNLSRefactoring.setResourceBundlePackage(accessorDescription.getResourceBundlePackage());
            this.fNLSRefactoring.setIsEclipseNLS(this.fNLSRefactoring.detectIsEclipseNLS());
            NLSSubstitution.updateSubtitutions(this.fSubstitutions, this.getProperties(this.fNLSRefactoring.getPropertyFileHandle()), this.fNLSRefactoring.getAccessorClassName());
            if (this.fIsEclipseNLS != null) {
                this.fIsEclipseNLS.setSelection(this.fNLSRefactoring.isEclipseNLS());
                this.fIsEclipseNLS.setEnabled(this.willCreateAccessorClass());
            }
            this.validateKeys(true);
        }
    }

    private boolean willCreateAccessorClass() {
        try {
            return this.fNLSRefactoring.willCreateAccessorClass();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void updateAccessorChoices() {
        AccessorDescription accessorDescription = new AccessorDescription(this.fNLSRefactoring.getAccessorClassName(), this.fNLSRefactoring.getAccessorClassPackage(), this.fNLSRefactoring.getResourceBundleName(), this.fNLSRefactoring.getResourceBundlePackage());
        ArrayList<AccessorDescription> arrayList = new ArrayList<AccessorDescription>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(accessorDescription);
        arrayList2.add(accessorDescription.getLabel());
        AccessorDescription[] accessorDescriptionArray = this.fAccessorChoices;
        if (accessorDescriptionArray == null) {
            accessorDescriptionArray = this.loadAccessorDescriptions();
        }
        int n = 0;
        while (n < accessorDescriptionArray.length) {
            AccessorDescription accessorDescription2 = accessorDescriptionArray[n];
            if (!accessorDescription2.equals(accessorDescription)) {
                arrayList.add(accessorDescription2);
                arrayList2.add(accessorDescription2.getLabel());
            }
            ++n;
        }
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        this.fAccessorChoices = arrayList.toArray(new AccessorDescription[arrayList.size()]);
        this.fAccessorClassField.setItems(stringArray);
        this.fAccessorClassField.select(0);
    }

    private AccessorDescription[] loadAccessorDescriptions() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(SETTINGS_NLS_ACCESSORS);
        if (iDialogSettings == null) {
            return new AccessorDescription[0];
        }
        ArrayList<AccessorDescription> arrayList = new ArrayList<AccessorDescription>();
        int n = 0;
        while (n < 5) {
            AccessorDescription accessorDescription;
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(String.valueOf(n));
            if (iDialogSettings2 != null && (accessorDescription = AccessorDescription.deserialize(iDialogSettings2)) != null) {
                arrayList.add(accessorDescription);
            }
            ++n;
        }
        return arrayList.toArray(new AccessorDescription[arrayList.size()]);
    }

    private void storeAccessorDescriptions() {
        if (this.fAccessorChoices == null) {
            return;
        }
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(SETTINGS_NLS_ACCESSORS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(SETTINGS_NLS_ACCESSORS);
        }
        int n = Math.min(5, this.fAccessorChoices.length);
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings iDialogSettings3 = iDialogSettings2.addNewSection(String.valueOf(n2));
            this.fAccessorChoices[n2].serialize(iDialogSettings3);
            ++n2;
        }
    }

    private void doConfigureButtonPressed() {
        NLSAccessorConfigurationDialog nLSAccessorConfigurationDialog = new NLSAccessorConfigurationDialog(this.getShell(), this.fNLSRefactoring);
        if (nLSAccessorConfigurationDialog.open() == 0) {
            NLSSubstitution.updateSubtitutions(this.fSubstitutions, this.getProperties(this.fNLSRefactoring.getPropertyFileHandle()), this.fNLSRefactoring.getAccessorClassName());
            if (this.fIsEclipseNLS != null) {
                this.fIsEclipseNLS.setSelection(this.fNLSRefactoring.isEclipseNLS());
                this.fIsEclipseNLS.setEnabled(this.willCreateAccessorClass());
            }
            this.validateKeys(true);
            this.updateAccessorChoices();
        }
    }

    private Properties getProperties(IFile iFile) {
        Properties properties = new Properties();
        try {
            if (iFile.exists()) {
                InputStream inputStream = iFile.getContents();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return properties;
    }

    private void createTableViewer(Composite composite) {
        this.createTableComposite(composite);
        this.fTableViewer = new TableViewer(this.fTable){

            protected void hookControl(Control control) {
                super.hookControl(control);
                ((Table)control).addMouseListener((MouseListener)new MouseAdapter(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void mouseDoubleClick(MouseEvent mouseEvent) {
                        if (this.this$1.getTable().getSelection().length == 0) {
                            return;
                        }
                        TableItem tableItem = this.this$1.getTable().getSelection()[0];
                        if (tableItem.getBounds(0).contains(mouseEvent.x, mouseEvent.y)) {
                            List list = 2.access$0(this.this$1);
                            if (list == null || list.size() != 1) {
                                return;
                            }
                            NLSSubstitution nLSSubstitution = (NLSSubstitution)list.get(0);
                            Integer n = (Integer)this.this$1.getCellModifier().getValue((Object)nLSSubstitution, ExternalizeWizardPage.access$0()[0]);
                            int n2 = MultiStateCellEditor.getNextValue(3, n);
                            this.this$1.getCellModifier().modify((Object)tableItem, ExternalizeWizardPage.access$0()[0], (Object)new Integer(n2));
                        }
                    }
                });
            }

            static /* synthetic */ List access$0(2 var0) {
                return var0.getSelectionFromWidget();
            }
        };
        this.fTableViewer.setUseHashlookup(true);
        CellEditor[] cellEditorArray = this.createCellEditors();
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.setColumnProperties(PROPERTIES);
        this.fTableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return ExternalizeWizardPage.this.fSubstitutions;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.fTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (!ExternalizeWizardPage.this.fFilterCheckBox.getSelection()) {
                    return true;
                }
                NLSSubstitution nLSSubstitution = (NLSSubstitution)object2;
                return nLSSubstitution.getInitialState() == 2 || nLSSubstitution.getInitialState() == 0 && nLSSubstitution.getInitialValue() == null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new NLSSubstitutionLabelProvider());
        this.fTableViewer.setInput(new Object());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ExternalizeWizardPage.this.selectionChanged(selectionChangedEvent);
            }
        });
    }

    private void createDefaultExternalization(NLSSubstitution[] nLSSubstitutionArray, String string) {
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.getState() == 2) {
                nLSSubstitution.setState(0);
                nLSSubstitution.generateKey(nLSSubstitutionArray);
            }
            ++n;
        }
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = new MultiStateCellEditor((Composite)this.fTable, 3, 0);
        cellEditorArray[2] = new TextCellEditor((Composite)this.fTable);
        cellEditorArray[1] = new TextCellEditor((Composite)this.fTable);
        return cellEditorArray;
    }

    private void createSourceViewer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(NLSUIMessages.ExternalizeWizardPage_context);
        label.setLayoutData((Object)new GridData());
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        int n = 68354;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(composite2, null, null, false, n, iPreferenceStore);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(javaTextTools.getColorManager(), iPreferenceStore, null, null));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
        try {
            String string = this.fCu.getBuffer().getContents();
            Document document = new Document(string);
            javaTextTools.setupJavaDocumentPartitioner((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
            this.fSourceViewer.setEditable(false);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(10);
            gridData.widthHint = this.convertWidthInCharsToPixels(40);
            this.fSourceViewer.getControl().setLayoutData((Object)gridData);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), NLSUIMessages.ExternalizeWizardPage_exception_title, NLSUIMessages.ExternalizeWizardPage_exception_message);
        }
    }

    private void createKeyPrefixField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(NLSUIMessages.ExternalizeWizardPage_common_prefix);
        label.setLayoutData((Object)new GridData());
        this.fPrefixField = new Text(composite2, 2052);
        this.fPrefixField.setLayoutData((Object)new GridData(768));
        this.fPrefixField.setText(this.fNLSRefactoring.getPrefix());
        this.fPrefixField.selectAll();
        this.fPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExternalizeWizardPage.this.fNLSRefactoring.setPrefix(ExternalizeWizardPage.this.fPrefixField.getText());
                ExternalizeWizardPage.this.validateKeys(true);
            }
        });
    }

    private boolean isEclipseNLSAvailable() {
        if (this.fNLSRefactoring == null || this.fNLSRefactoring.getCu() == null) {
            return false;
        }
        IJavaProject iJavaProject = this.fNLSRefactoring.getCu().getJavaProject();
        if (iJavaProject == null || !iJavaProject.exists()) {
            return false;
        }
        try {
            return iJavaProject.findType("org.eclipse.osgi.util.NLS") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void createIsEclipseNLSCheckbox(Composite composite) {
        if (this.fNLSRefactoring.isEclipseNLS() || this.isEclipseNLSAvailable()) {
            this.fIsEclipseNLS = new Button(composite, 32);
            this.fIsEclipseNLS.setLayoutData((Object)new GridData(768));
            this.fIsEclipseNLS.setText(NLSUIMessages.ExternalizeWizardPage_isEclipseNLSCheckbox);
            this.fIsEclipseNLS.setSelection(this.fNLSRefactoring.isEclipseNLS());
            this.fIsEclipseNLS.setEnabled(this.willCreateAccessorClass());
            this.fIsEclipseNLS.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetDefaultSelected(selectionEvent);
                    boolean bl = ExternalizeWizardPage.this.fIsEclipseNLS.getSelection();
                    ExternalizeWizardPage.this.fNLSRefactoring.setIsEclipseNLS(bl);
                    if (bl) {
                        ExternalizeWizardPage.this.fNLSRefactoring.setPrefix(ExternalizeWizardPage.this.fNLSRefactoring.getPrefix().replace('.', '_'));
                    } else {
                        ExternalizeWizardPage.this.fNLSRefactoring.setPrefix(ExternalizeWizardPage.this.fNLSRefactoring.getPrefix().replace('_', '.'));
                    }
                    ExternalizeWizardPage.this.fPrefixField.setText(ExternalizeWizardPage.this.fNLSRefactoring.getPrefix());
                    ExternalizeWizardPage.this.validateKeys(true);
                }
            });
        }
    }

    private void validateKeys(boolean bl) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.checkInvalidKeys(refactoringStatus);
        this.checkDuplicateKeys(refactoringStatus);
        this.checkMissingKeys(refactoringStatus);
        this.setPageComplete(refactoringStatus);
        if (bl) {
            this.fTableViewer.refresh(true);
        }
    }

    private void checkInvalidKeys(RefactoringStatus refactoringStatus) {
        int n = 0;
        while (n < this.fSubstitutions.length) {
            if (!this.isKeyValid(this.fSubstitutions[n], refactoringStatus)) {
                return;
            }
            ++n;
        }
    }

    private boolean isKeyValid(NLSSubstitution nLSSubstitution, RefactoringStatus refactoringStatus) {
        if (nLSSubstitution == null) {
            return false;
        }
        if (nLSSubstitution.getState() != 0) {
            return true;
        }
        String string = nLSSubstitution.getKey();
        if (this.fNLSRefactoring.isEclipseNLS()) {
            if (string == null || string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
                if (refactoringStatus != null) {
                    refactoringStatus.addFatalError(NLSUIMessages.ExternalizeWizardPage_warning_EclipseNLS_keyInvalid);
                }
                return false;
            }
            int n = 1;
            int n2 = string.length();
            while (n < n2) {
                if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                    if (refactoringStatus != null) {
                        refactoringStatus.addFatalError(NLSUIMessages.ExternalizeWizardPage_warning_EclipseNLS_keyInvalid);
                    }
                    return false;
                }
                ++n;
            }
        } else {
            if (string == null || string.length() == 0) {
                if (refactoringStatus != null) {
                    refactoringStatus.addFatalError(NLSUIMessages.ExternalizeWizardPage_warning_keyInvalid);
                }
                return false;
            }
            int n = 0;
            while (n < string.length()) {
                if (Character.isWhitespace(string.charAt(n))) {
                    if (refactoringStatus != null) {
                        refactoringStatus.addFatalError(NLSUIMessages.ExternalizeWizardPage_warning_keyInvalid);
                    }
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void checkDuplicateKeys(RefactoringStatus refactoringStatus) {
        int n = 0;
        while (n < this.fSubstitutions.length) {
            NLSSubstitution nLSSubstitution = this.fSubstitutions[n];
            if (this.conflictingKeys(nLSSubstitution)) {
                refactoringStatus.addFatalError(NLSUIMessages.ExternalizeWizardPage_warning_conflicting);
                return;
            }
            ++n;
        }
    }

    private void checkMissingKeys(RefactoringStatus refactoringStatus) {
        int n = 0;
        while (n < this.fSubstitutions.length) {
            NLSSubstitution nLSSubstitution = this.fSubstitutions[n];
            if (nLSSubstitution.getValue() == null && nLSSubstitution.getKey() != null) {
                refactoringStatus.addWarning(NLSUIMessages.ExternalizeWizardPage_warning_keymissing);
                return;
            }
            ++n;
        }
    }

    private boolean conflictingKeys(NLSSubstitution nLSSubstitution) {
        if (nLSSubstitution.getState() == 0) {
            return nLSSubstitution.isConflicting(this.fSubstitutions);
        }
        return false;
    }

    private void createTableComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(1808));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        Label label = new Label(composite2, 0);
        label.setText(NLSUIMessages.ExternalizeWizardPage_strings_to_externalize);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)formData);
        Control control = this.createTable(composite2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 5);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        control.setLayoutData((Object)formData);
        this.fFilterCheckBox = new Button(composite2, 32);
        this.fFilterCheckBox.setText(NLSUIMessages.ExternalizeWizardPage_filter_label);
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        this.fFilterCheckBox.setLayoutData((Object)formData);
        this.fFilterCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExternalizeWizardPage.this.doFilterCheckBoxPressed();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fFilterCheckBox.setSelection(this.hasNewOrMissingSubstitutions());
    }

    private boolean hasNewOrMissingSubstitutions() {
        int n = 0;
        while (n < this.fSubstitutions.length) {
            NLSSubstitution nLSSubstitution = this.fSubstitutions[n];
            if (nLSSubstitution.getInitialState() == 2) {
                return true;
            }
            if (nLSSubstitution.getInitialState() == 0 && nLSSubstitution.getInitialValue() == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void doFilterCheckBoxPressed() {
        this.fTableViewer.refresh();
    }

    private Control createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fTable = new Table(composite2, 101122);
        this.fTable.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint(this.fTable, 5);
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.fTable.setLayout((Layout)tableLayout);
        this.fTable.setHeaderVisible(true);
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[3];
        columnLayoutDataArray[0] = new ColumnPixelData(18, false, true);
        columnLayoutDataArray[2] = new ColumnWeightData(40, true);
        columnLayoutDataArray[1] = new ColumnWeightData(40, true);
        int n = 0;
        while (n < fgTitles.length) {
            TableColumn tableColumn = new TableColumn(this.fTable, 0, n);
            tableColumn.setText(fgTitles[n]);
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            ++n;
        }
        this.createButtonComposite(composite2);
        return composite2;
    }

    private void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1040));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExternalizeWizardPage.this.handleButtonPressed(selectionEvent.widget);
            }
        };
        this.fExternalizeButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Externalize_Selected, selectionAdapter);
        this.fIgnoreButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Ignore_Selected, selectionAdapter);
        this.fInternalizeButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Internalize_Selected, selectionAdapter);
        new Label(composite2, 0);
        this.fEditButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Edit_key_and_value, selectionAdapter);
        this.fRevertButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Revert_Selected, selectionAdapter);
        this.fRenameButton = this.createTaskButton(composite2, NLSUIMessages.ExternalizeWizardPage_Rename_Keys, selectionAdapter);
        this.fEditButton.setEnabled(false);
        this.fRenameButton.setEnabled(false);
        composite2.pack();
    }

    protected void handleButtonPressed(Widget widget) {
        if (widget == this.fExternalizeButton) {
            this.setSelectedTasks(0);
        } else if (widget == this.fIgnoreButton) {
            this.setSelectedTasks(1);
        } else if (widget == this.fInternalizeButton) {
            this.setSelectedTasks(2);
        } else if (widget == this.fEditButton) {
            this.openEditButton(this.fTableViewer.getSelection());
        } else if (widget == this.fRevertButton) {
            this.revertStateOfSelection();
        } else if (widget == this.fRenameButton) {
            this.openRenameDialog();
        }
    }

    private void openRenameDialog() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        List list = this.getExternalizedElements(iStructuredSelection);
        RenameKeysDialog renameKeysDialog = new RenameKeysDialog(this.getShell(), list);
        if (renameKeysDialog.open() == 0) {
            this.fTableViewer.refresh();
            this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
        }
    }

    private void revertStateOfSelection() {
        List list = this.getSelectedTableEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)iterator.next();
            nLSSubstitution.revert();
        }
        this.fTableViewer.refresh();
        this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
    }

    private Button createTaskButton(Composite composite, String string, SelectionAdapter selectionAdapter) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        return button;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openEditButton(ISelection iSelection) {
        try {
            NLSInputDialog nLSInputDialog;
            NLSSubstitution nLSSubstitution;
            block9: {
                block8: {
                    block7: {
                        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
                        nLSSubstitution = (NLSSubstitution)iStructuredSelection.getFirstElement();
                        if (nLSSubstitution != null) break block7;
                        break block8;
                    }
                    nLSInputDialog = new NLSInputDialog(this.getShell(), nLSSubstitution);
                    if (nLSInputDialog.open() != 1) break block9;
                }
                Object var6_4 = null;
                this.fTableViewer.refresh();
                this.fTableViewer.getControl().setFocus();
                this.fTableViewer.setSelection(iSelection);
                return;
            }
            KeyValuePair keyValuePair = nLSInputDialog.getResult();
            if (nLSSubstitution.getState() == 0) {
                nLSSubstitution.setKey(keyValuePair.getKey());
            }
            nLSSubstitution.setValue(keyValuePair.getValue());
            this.validateKeys(false);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.fTableViewer.refresh();
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(iSelection);
            throw throwable;
        }
        this.fTableViewer.refresh();
        this.fTableViewer.getControl().setFocus();
        this.fTableViewer.setSelection(iSelection);
    }

    private List getSelectedTableEntries() {
        ISelection iSelection = this.fTableViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return ((IStructuredSelection)iSelection).toList();
        }
        return Collections.EMPTY_LIST;
    }

    private void setSelectedTasks(int n) {
        Assert.isTrue((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
        List list = this.getSelectedTableEntries();
        String[] stringArray = new String[]{PROPERTIES[0]};
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)iterator.next();
            nLSSubstitution.setState(n);
            if (nLSSubstitution.getState() != 0 || !nLSSubstitution.hasStateChanged()) continue;
            nLSSubstitution.generateKey(this.fSubstitutions);
        }
        this.fTableViewer.update(list.toArray(), stringArray);
        this.fTableViewer.getControl().setFocus();
        this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
    }

    private void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateButtonStates(iStructuredSelection);
        this.updateSourceView(iStructuredSelection);
    }

    private void updateSourceView(IStructuredSelection iStructuredSelection) {
        NLSSubstitution nLSSubstitution = (NLSSubstitution)iStructuredSelection.getFirstElement();
        if (nLSSubstitution != null) {
            Region region = nLSSubstitution.getNLSElement().getPosition();
            this.fSourceViewer.setSelectedRange(region.getOffset(), region.getLength());
            this.fSourceViewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    private void updateButtonStates(IStructuredSelection iStructuredSelection) {
        this.fExternalizeButton.setEnabled(true);
        this.fIgnoreButton.setEnabled(true);
        this.fInternalizeButton.setEnabled(true);
        this.fRevertButton.setEnabled(true);
        if (this.containsOnlyElementsOfSameState(0, iStructuredSelection)) {
            this.fExternalizeButton.setEnabled(false);
        }
        if (this.containsOnlyElementsOfSameState(1, iStructuredSelection)) {
            this.fIgnoreButton.setEnabled(false);
        }
        if (this.containsOnlyElementsOfSameState(2, iStructuredSelection)) {
            this.fInternalizeButton.setEnabled(false);
        }
        if (!this.containsElementsWithChange(iStructuredSelection)) {
            this.fRevertButton.setEnabled(false);
        }
        this.fRenameButton.setEnabled(this.getExternalizedElements(iStructuredSelection).size() > 1);
        this.fEditButton.setEnabled(iStructuredSelection.size() == 1);
    }

    private boolean containsElementsWithChange(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)iterator.next();
            if (!nLSSubstitution.hasPropertyFileChange() && !nLSSubstitution.hasSourceChange()) continue;
            return true;
        }
        return false;
    }

    private List getExternalizedElements(IStructuredSelection iStructuredSelection) {
        ArrayList<NLSSubstitution> arrayList = new ArrayList<NLSSubstitution>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)iterator.next();
            if (nLSSubstitution.getState() != 0 || nLSSubstitution.hasStateChanged()) continue;
            arrayList.add(nLSSubstitution);
        }
        return arrayList;
    }

    private boolean containsOnlyElementsOfSameState(int n, IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            NLSSubstitution nLSSubstitution = (NLSSubstitution)iterator.next();
            if (nLSSubstitution.getState() == n) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public void dispose() {
        this.storeAccessorDescriptions();
        this.fPrefixField = null;
        this.fSourceViewer = null;
        this.fTable = null;
        this.fTableViewer = null;
        this.fEditButton = null;
        super.dispose();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            if (string == null) {
                return false;
            }
            if (!(object instanceof NLSSubstitution)) {
                return false;
            }
            NLSSubstitution nLSSubstitution = (NLSSubstitution)object;
            return !PROPERTIES[2].equals(string) || nLSSubstitution.getState() == 0;
        }

        public Object getValue(Object object, String string) {
            if (object instanceof NLSSubstitution) {
                NLSSubstitution nLSSubstitution = (NLSSubstitution)object;
                String string2 = null;
                if (PROPERTIES[2].equals(string)) {
                    string2 = nLSSubstitution.getKeyWithoutPrefix();
                } else if (PROPERTIES[1].equals(string)) {
                    string2 = nLSSubstitution.getValue();
                } else if (PROPERTIES[0].equals(string)) {
                    return new Integer(nLSSubstitution.getState());
                }
                if (string2 != null) {
                    return ExternalizeWizardPage.unwindEscapeChars(string2);
                }
                return "";
            }
            return "";
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                if (object3 instanceof NLSSubstitution) {
                    String string2;
                    NLSSubstitution nLSSubstitution = (NLSSubstitution)object3;
                    if (PROPERTIES[2].equals(string)) {
                        string2 = (String)object2;
                        string2 = ExternalizeWizardPage.windEscapeChars(string2);
                        nLSSubstitution.setKey(string2);
                    }
                    if (PROPERTIES[1].equals(string)) {
                        string2 = (String)object2;
                        string2 = ExternalizeWizardPage.windEscapeChars(string2);
                        nLSSubstitution.setValue(string2);
                    }
                    if (PROPERTIES[0].equals(string)) {
                        nLSSubstitution.setState((Integer)object2);
                        if (nLSSubstitution.getState() == 0 && nLSSubstitution.hasStateChanged()) {
                            nLSSubstitution.generateKey(ExternalizeWizardPage.this.fSubstitutions);
                        }
                    }
                }
                ExternalizeWizardPage.this.validateKeys(false);
                ExternalizeWizardPage.this.fTableViewer.update(object3, null);
            }
        }
    }

    private class NLSInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fKeyField;
        private StringDialogField fValueField;
        private DialogField fMessageField;
        private NLSSubstitution fSubstitution;

        public NLSInputDialog(Shell shell, NLSSubstitution nLSSubstitution) {
            super(shell);
            this.setTitle(NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Title);
            this.fSubstitution = nLSSubstitution;
            this.fMessageField = new DialogField();
            if (nLSSubstitution.getState() == 0) {
                this.fMessageField.setLabelText(NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_ext_Label);
            } else {
                this.fMessageField.setLabelText(NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Label);
            }
            this.fKeyField = new StringDialogField();
            this.fKeyField.setLabelText(NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Enter_key);
            this.fKeyField.setDialogFieldListener(this);
            this.fValueField = new StringDialogField();
            this.fValueField.setLabelText(NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Enter_value);
            this.fValueField.setDialogFieldListener(this);
            if (nLSSubstitution.getState() == 0) {
                this.fKeyField.setText(nLSSubstitution.getKeyWithoutPrefix());
            } else {
                this.fKeyField.setText("");
            }
            this.fValueField.setText(nLSSubstitution.getValueNonEmpty());
        }

        public KeyValuePair getResult() {
            KeyValuePair keyValuePair = new KeyValuePair(this.fKeyField.getText(), this.fValueField.getText());
            return keyValuePair;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setFont(composite2.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 2;
            composite3.setLayout((Layout)gridLayout);
            this.fMessageField.doFillIntoGrid(composite3, 2);
            if (this.fSubstitution.getState() == 0) {
                this.fKeyField.doFillIntoGrid(composite3, 2);
                LayoutUtil.setWidthHint((Control)this.fKeyField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            }
            this.fValueField.doFillIntoGrid(composite3, 2);
            LayoutUtil.setWidthHint((Control)this.fValueField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            LayoutUtil.setHorizontalGrabbing((Control)this.fValueField.getTextControl(null));
            this.fValueField.postSetFocusOnDialogField(composite.getDisplay());
            NLSInputDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            IStatus iStatus = this.validateKey(this.fKeyField.getText());
            this.updateStatus(iStatus);
        }

        private IStatus validateKey(String string) {
            if (this.fSubstitution.getState() != 0) {
                return StatusInfo.OK_STATUS;
            }
            if (string == null || string.length() == 0) {
                return new StatusInfo(4, NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Error_empty_key);
            }
            if (ExternalizeWizardPage.this.fNLSRefactoring.isEclipseNLS()) {
                if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                    return new StatusInfo(4, NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Error_invalid_EclipseNLS_key);
                }
                int n = 1;
                int n2 = string.length();
                while (n < n2) {
                    if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                        return new StatusInfo(4, NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Error_invalid_EclipseNLS_key);
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < string.length()) {
                    if (Character.isWhitespace(string.charAt(n))) {
                        return new StatusInfo(4, NLSUIMessages.ExternalizeWizardPage_NLSInputDialog_Error_invalid_key);
                    }
                    ++n;
                }
            }
            return StatusInfo.OK_STATUS;
        }
    }

    private class NLSSubstitutionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private FontRegistry fFontRegistry = JFaceResources.getFontRegistry();

        public String getColumnText(Object object, int n) {
            String string = "";
            if (object instanceof NLSSubstitution) {
                NLSSubstitution nLSSubstitution = (NLSSubstitution)object;
                if (n == 2) {
                    if (nLSSubstitution.getState() == 0) {
                        string = nLSSubstitution.getKey();
                    }
                } else if (n == 1 && nLSSubstitution.getValue() != null) {
                    string = nLSSubstitution.getValue();
                }
            }
            return ExternalizeWizardPage.unwindEscapeChars(string);
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0 && object instanceof NLSSubstitution) {
                return this.getNLSImage((NLSSubstitution)object);
            }
            return null;
        }

        public Font getFont(Object object) {
            NLSSubstitution nLSSubstitution;
            if (object instanceof NLSSubstitution && ((nLSSubstitution = (NLSSubstitution)object).hasPropertyFileChange() || nLSSubstitution.hasSourceChange())) {
                return this.fFontRegistry.getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private Image getNLSImage(NLSSubstitution nLSSubstitution) {
            if (nLSSubstitution.getValue() == null && nLSSubstitution.getKey() != null) {
                JavaElementImageDescriptor javaElementImageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(nLSSubstitution.getState()), 32, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)javaElementImageDescriptor);
            }
            if (nLSSubstitution.isConflicting(ExternalizeWizardPage.this.fSubstitutions) || !ExternalizeWizardPage.this.isKeyValid(nLSSubstitution, null)) {
                JavaElementImageDescriptor javaElementImageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(nLSSubstitution.getState()), 64, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)javaElementImageDescriptor);
            }
            return this.getNLSImage(nLSSubstitution.getState());
        }

        private Image getNLSImage(int n) {
            switch (n) {
                case 0: {
                    return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.translate.gif");
                }
                case 1: {
                    return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.never_translate.gif");
                }
                case 2: {
                    return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.skip.gif");
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        private ImageDescriptor getNLSImageDescriptor(int n) {
            switch (n) {
                case 0: {
                    return JavaPluginImages.DESC_OBJS_NLS_TRANSLATE;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_NLS_NEVER_TRANSLATE;
                }
                case 2: {
                    return JavaPluginImages.DESC_OBJS_NLS_SKIP;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

