/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.CompilationUnitEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchQuery;

public class NLSSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];
    private NLSSearchQuery fQuery;
    private final List fFileEntryGroups;
    private final List fCompilationUnitGroups;

    public NLSSearchResult(NLSSearchQuery nLSSearchQuery) {
        this.fQuery = nLSSearchQuery;
        this.fFileEntryGroups = new ArrayList();
        this.fCompilationUnitGroups = new ArrayList();
    }

    public void addFileEntryGroup(FileEntry fileEntry) {
        this.fFileEntryGroups.add(fileEntry);
    }

    public void addCompilationUnitGroup(CompilationUnitEntry compilationUnitEntry) {
        this.fCompilationUnitGroups.add(compilationUnitEntry);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
            HashSet hashSet = new HashSet();
            this.collectMatches(hashSet, (IJavaElement)iClassFileEditorInput.getClassFile());
            return hashSet.toArray(new Match[hashSet.size()]);
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        Object object;
        HashSet<Match> hashSet = new HashSet<Match>();
        IJavaElement iJavaElement = this.fFileEntryGroups.iterator();
        while (iJavaElement.hasNext()) {
            object = (FileEntry)iJavaElement.next();
            if (!((FileEntry)object).getPropertiesFile().equals((Object)iFile)) continue;
            hashSet.addAll(Arrays.asList(this.getMatches(object)));
        }
        if (hashSet.size() > 0) {
            return hashSet.toArray(new Match[hashSet.size()]);
        }
        try {
            iJavaElement = this.fCompilationUnitGroups.iterator();
            while (iJavaElement.hasNext()) {
                object = (CompilationUnitEntry)iJavaElement.next();
                ICompilationUnit iCompilationUnit = ((CompilationUnitEntry)object).getCompilationUnit();
                if (!iCompilationUnit.exists() || !iFile.equals((Object)iCompilationUnit.getCorrespondingResource())) continue;
                hashSet.addAll(Arrays.asList(this.getMatches(object)));
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return NO_MATCHES;
        }
        iJavaElement = JavaCore.create((IFile)iFile);
        this.collectMatches(hashSet, iJavaElement);
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    private void collectMatches(Set set, IJavaElement iJavaElement) {
        Match[] matchArray = this.getMatches(iJavaElement);
        if (matchArray.length != 0) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
        if (iJavaElement instanceof IParent) {
            IParent iParent = (IParent)iJavaElement;
            try {
                IJavaElement[] iJavaElementArray = iParent.getChildren();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    this.collectMatches(set, iJavaElementArray[n]);
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public IFile getFile(Object object) {
        if (object instanceof FileEntry) {
            return ((FileEntry)object).getPropertiesFile();
        }
        Object object2 = null;
        object2 = object instanceof CompilationUnitEntry ? ((CompilationUnitEntry)object).getCompilationUnit() : (IJavaElement)object;
        IResource iResource = null;
        try {
            iResource = object2.getCorrespondingResource();
        }
        catch (JavaModelException javaModelException) {}
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (match.getElement() instanceof FileEntry) {
            IFile iFile = ((FileEntry)match.getElement()).getPropertiesFile();
            if (iEditorInput instanceof IFileEditorInput) {
                return ((IFileEditorInput)iEditorInput).getFile().equals((Object)iFile);
            }
        } else if (match.getElement() instanceof IJavaElement || match.getElement() instanceof CompilationUnitEntry) {
            Object object = null;
            object = match.getElement() instanceof IJavaElement ? (IJavaElement)match.getElement() : ((CompilationUnitEntry)match.getElement()).getCompilationUnit();
            if (iEditorInput instanceof IFileEditorInput) {
                ICompilationUnit iCompilationUnit;
                block9: {
                    try {
                        iCompilationUnit = (ICompilationUnit)object.getAncestor(5);
                        if (iCompilationUnit != null) break block9;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
                return ((IFileEditorInput)iEditorInput).getFile().equals((Object)iCompilationUnit.getCorrespondingResource());
            }
            if (iEditorInput instanceof IClassFileEditorInput) {
                return ((IClassFileEditorInput)iEditorInput).getClassFile().equals(object.getAncestor(6));
            }
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

