/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypedSource;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard) {
        super(iWorkbenchSite);
        this.setText(ReorgMessages.CopyToClipboardAction_0);
        this.setDescription(ReorgMessages.CopyToClipboardAction_1);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        ISharedImages iSharedImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.copy_action");
    }

    public void setAutoRepeatOnFailure(boolean bl) {
        this.fAutoRepeatOnFailure = bl;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return JavaPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ReorgUtils.getResources(list);
            IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(list);
            if (list.size() != iResourceArray.length + iJavaElementArray.length) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.canEnable(iResourceArray, iJavaElementArray));
            }
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ReorgUtils.getResources(list);
            IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(list);
            if (list.size() == iResourceArray.length + iJavaElementArray.length && this.canEnable(iResourceArray, iJavaElementArray)) {
                this.doRun(iResourceArray, iJavaElementArray);
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), ReorgMessages.CopyToClipboardAction_2, ReorgMessages.CopyToClipboardAction_3);
        }
    }

    private void doRun(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws CoreException {
        new ClipboardCopier(iResourceArray, iJavaElementArray, this.fClipboard, this.getShell(), this.fAutoRepeatOnFailure).copyToClipboard();
    }

    private boolean canEnable(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        return new CopyToClipboardEnablementPolicy(iResourceArray, iJavaElementArray).canEnable();
    }

    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;
        private final Clipboard fClipboard;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] iResourceArray, IJavaElement[] iJavaElementArray, Clipboard clipboard, Shell shell, boolean bl) {
            Assert.isNotNull((Object)iResourceArray);
            Assert.isNotNull((Object)iJavaElementArray);
            Assert.isNotNull((Object)clipboard);
            Assert.isNotNull((Object)shell);
            this.fResources = iResourceArray;
            this.fJavaElements = iJavaElementArray;
            this.fClipboard = clipboard;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = bl;
        }

        public void copyToClipboard() throws CoreException {
            HashSet hashSet = new HashSet(this.fResources.length + this.fJavaElements.length);
            StringBuffer stringBuffer = new StringBuffer();
            this.processResources(hashSet, stringBuffer);
            this.processJavaElements(hashSet, stringBuffer);
            IType[] iTypeArray = ReorgUtils.getMainTypes(this.fJavaElements);
            ICompilationUnit[] iCompilationUnitArray = ReorgUtils.getCompilationUnits((IJavaElement[])iTypeArray);
            IResource[] iResourceArray = ReorgUtils.getResources((IJavaElement[])iCompilationUnitArray);
            ClipboardCopier.addFileNames(hashSet, iResourceArray);
            IResource[] iResourceArray2 = ReorgUtils.getResources(ClipboardCopier.getCompilationUnits(this.fJavaElements));
            ClipboardCopier.addFileNames(hashSet, iResourceArray2);
            IResource[] iResourceArray3 = ReorgUtils.union(this.fResources, ReorgUtils.union(iResourceArray2, iResourceArray));
            IJavaElement[] iJavaElementArray = ReorgUtils.union(this.fJavaElements, (IJavaElement[])iCompilationUnitArray);
            TypedSource[] typedSourceArray = TypedSource.createTypedSources(iJavaElementArray);
            String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
            this.copyToClipboard(iResourceArray3, stringArray, stringBuffer.toString(), iJavaElementArray, typedSourceArray, 0);
        }

        private static IJavaElement[] getCompilationUnits(IJavaElement[] iJavaElementArray) {
            List list = ReorgUtils.getElementsOfType(iJavaElementArray, 5);
            return list.toArray(new ICompilationUnit[list.size()]);
        }

        private void processResources(Set set, StringBuffer stringBuffer) {
            int n = 0;
            while (n < this.fResources.length) {
                IResource iResource = this.fResources[n];
                ClipboardCopier.addFileName(set, iResource);
                if (n > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.getName(iResource));
                ++n;
            }
        }

        private void processJavaElements(Set set, StringBuffer stringBuffer) {
            int n = 0;
            while (n < this.fJavaElements.length) {
                IJavaElement iJavaElement = this.fJavaElements[n];
                switch (iJavaElement.getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ClipboardCopier.addFileName(set, ReorgUtils.getResource(iJavaElement));
                        break;
                    }
                }
                if (this.fResources.length > 0 || n > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.getName(iJavaElement));
                ++n;
            }
        }

        private static void addFileNames(Set set, IResource[] iResourceArray) {
            int n = 0;
            while (n < iResourceArray.length) {
                ClipboardCopier.addFileName(set, iResourceArray[n]);
                ++n;
            }
        }

        private static void addFileName(Set set, IResource iResource) {
            if (iResource == null) {
                return;
            }
            IPath iPath = iResource.getLocation();
            if (iPath != null) {
                set.add(iPath.toOSString());
            }
        }

        private void copyToClipboard(IResource[] iResourceArray, String[] stringArray, String string, IJavaElement[] iJavaElementArray, TypedSource[] typedSourceArray, int n) {
            block6: {
                try {
                    this.fClipboard.setContents(ClipboardCopier.createDataArray(iResourceArray, iJavaElementArray, stringArray, string, typedSourceArray), ClipboardCopier.createDataTypeArray(iResourceArray, iJavaElementArray, stringArray, typedSourceArray));
                }
                catch (SWTError sWTError) {
                    if (sWTError.code != 2002 || n >= 10) {
                        throw sWTError;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)ReorgMessages.CopyToClipboardAction_4, (String)ReorgMessages.CopyToClipboardAction_5)) break block6;
                    this.copyToClipboard(iResourceArray, stringArray, string, iJavaElementArray, typedSourceArray, n + 1);
                }
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] iResourceArray, IJavaElement[] iJavaElementArray, String[] stringArray, TypedSource[] typedSourceArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            if (iResourceArray.length != 0) {
                arrayList.add(ResourceTransfer.getInstance());
            }
            if (iJavaElementArray.length != 0) {
                arrayList.add((Object)JavaElementTransfer.getInstance());
            }
            if (stringArray.length != 0) {
                arrayList.add(FileTransfer.getInstance());
            }
            if (typedSourceArray.length != 0) {
                arrayList.add((Object)TypedSourceTransfer.getInstance());
            }
            arrayList.add(TextTransfer.getInstance());
            return arrayList.toArray(new Transfer[arrayList.size()]);
        }

        private static Object[] createDataArray(IResource[] iResourceArray, IJavaElement[] iJavaElementArray, String[] stringArray, String string, TypedSource[] typedSourceArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            if (iResourceArray.length != 0) {
                arrayList.add(iResourceArray);
            }
            if (iJavaElementArray.length != 0) {
                arrayList.add(iJavaElementArray);
            }
            if (stringArray.length != 0) {
                arrayList.add(stringArray);
            }
            if (typedSourceArray.length != 0) {
                arrayList.add(typedSourceArray);
            }
            arrayList.add(string);
            return arrayList.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(546);
        }

        private String getName(IResource iResource) {
            return this.fLabelProvider.getText((Object)iResource);
        }

        private String getName(IJavaElement iJavaElement) {
            return this.fLabelProvider.getText((Object)iJavaElement);
        }
    }

    private static class CopyToClipboardEnablementPolicy {
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;

        public CopyToClipboardEnablementPolicy(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) {
            Assert.isNotNull((Object)iResourceArray);
            Assert.isNotNull((Object)iJavaElementArray);
            this.fResources = iResourceArray;
            this.fJavaElements = iJavaElementArray;
        }

        public boolean canEnable() throws JavaModelException {
            if (this.fResources.length + this.fJavaElements.length == 0) {
                return false;
            }
            if (this.hasProjects() && this.hasNonProjects()) {
                return false;
            }
            if (!this.canCopyAllToClipboard()) {
                return false;
            }
            return new ParentChecker(this.fResources, this.fJavaElements).haveCommonParent();
        }

        private boolean canCopyAllToClipboard() throws JavaModelException {
            int n = 0;
            while (n < this.fResources.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fResources[n])) {
                    return false;
                }
                ++n;
            }
            n = 0;
            while (n < this.fJavaElements.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fJavaElements[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private static boolean canCopyToClipboard(IJavaElement iJavaElement) throws JavaModelException {
            if (iJavaElement == null || !iJavaElement.exists()) {
                return false;
            }
            return !JavaElementUtil.isDefaultPackage(iJavaElement);
        }

        private static boolean canCopyToClipboard(IResource iResource) {
            return iResource != null && iResource.exists() && !iResource.isPhantom() && iResource.getType() != 8;
        }

        private boolean hasProjects() {
            int n = 0;
            while (n < this.fResources.length) {
                if (ReorgUtils.isProject(this.fResources[n])) {
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < this.fJavaElements.length) {
                if (ReorgUtils.isProject(this.fJavaElements[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean hasNonProjects() {
            int n = 0;
            while (n < this.fResources.length) {
                if (!ReorgUtils.isProject(this.fResources[n])) {
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < this.fJavaElements.length) {
                if (!ReorgUtils.isProject(this.fJavaElements[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

