/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard) {
        super(iWorkbenchSite);
        this.setText(ReorgMessages.CutAction_text);
        this.fCopyToClipboardAction = new CopyToClipboardAction(iWorkbenchSite, clipboard);
        ISharedImages iSharedImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            try {
                if (!CutAction.containsOnlyElementsInsideCompilationUnits(iStructuredSelection) || CutAction.containsTopLevelTypes(iStructuredSelection)) {
                    this.setEnabled(false);
                    return;
                }
                this.fCopyToClipboardAction.selectionChanged(iStructuredSelection);
                this.setEnabled(this.fCopyToClipboardAction.isEnabled() && RefactoringAvailabilityTester.isDeleteAvailable(iStructuredSelection));
            }
            catch (CoreException coreException) {
                if (JavaModelUtil.isExceptionToBeLogged(coreException)) {
                    JavaPlugin.log(coreException);
                }
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsideCompilationUnits(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IJavaElement && ReorgUtils.isInsideCompilationUnit((IJavaElement)e)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IType) || ((IType)e).getDeclaringType() != null) continue;
            return true;
        }
        return false;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            this.selectionChanged(iStructuredSelection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(iStructuredSelection);
                RefactoringExecutionStarter.startCutRefactoring(iStructuredSelection.toArray(), this.getShell());
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

