/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator iReorgDestinationValidator) {
        super(true);
        this.fValidator = iReorgDestinationValidator;
    }

    public boolean hasChildren(Object object) {
        IResource iResource;
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            if (!this.fValidator.canChildrenBeDestinations(iJavaElement)) {
                return false;
            }
            if (iJavaElement.getElementType() == 3 && ((IPackageFragmentRoot)iJavaElement).isArchive()) {
                return false;
            }
        } else if (object instanceof IResource && !this.fValidator.canChildrenBeDestinations(iResource = (IResource)object)) {
            return false;
        }
        return super.hasChildren(object);
    }

    public Object[] getChildren(Object object) {
        try {
            if (object instanceof IJavaModel) {
                return DestinationContentProvider.concatenate(this.getJavaProjects((IJavaModel)object), DestinationContentProvider.getOpenNonJavaProjects((IJavaModel)object));
            }
            Object[] objectArray = this.doGetChildren(object);
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                IJavaElement iJavaElement;
                if (objectArray[n] instanceof IJavaElement) {
                    iJavaElement = (IJavaElement)objectArray[n];
                    if (this.fValidator.canElementBeDestination(iJavaElement) || this.fValidator.canChildrenBeDestinations(iJavaElement)) {
                        arrayList.add(iJavaElement);
                    }
                } else if (objectArray[n] instanceof IResource && (this.fValidator.canElementBeDestination((IResource)(iJavaElement = (IResource)objectArray[n])) || this.fValidator.canChildrenBeDestinations((IResource)iJavaElement))) {
                    arrayList.add(iJavaElement);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new Object[0];
        }
    }

    private Object[] doGetChildren(Object object) {
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            return this.getResources(iContainer);
        }
        return super.getChildren(object);
    }

    private Object[] getResources(IContainer iContainer) {
        try {
            Object[] objectArray = iContainer.members();
            IJavaProject iJavaProject = JavaCore.create((IProject)iContainer.getProject());
            if (iJavaProject == null || !iJavaProject.exists()) {
                return objectArray;
            }
            boolean bl = iJavaProject.isOnClasspath((IResource)iContainer);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (bl) {
                    if (iJavaProject.findPackageFragmentRoot(object.getFullPath()) == null) {
                        arrayList.add(object);
                    }
                } else if (!iJavaProject.isOnClasspath((IResource)object)) {
                    arrayList.add(object);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaModel iJavaModel) throws JavaModelException {
        Object[] objectArray = iJavaModel.getNonJavaResources();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            IProject iProject = (IProject)objectArray[n];
            if (iProject.isOpen()) {
                arrayList.add(iProject);
            }
            ++n;
        }
        return arrayList.toArray();
    }
}

