/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.JavaMoveRefactoring;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class ReorgMoveStarter {
    private final JavaMoveProcessor fMoveProcessor;

    private ReorgMoveStarter(JavaMoveProcessor javaMoveProcessor) {
        Assert.isNotNull((Object)javaMoveProcessor);
        this.fMoveProcessor = javaMoveProcessor;
    }

    public static ReorgMoveStarter create(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IJavaElement iJavaElement) throws JavaModelException {
        Assert.isNotNull((Object)iJavaElementArray);
        Assert.isNotNull((Object)iResourceArray);
        Assert.isNotNull((Object)iJavaElement);
        IReorgPolicy.IMovePolicy iMovePolicy = ReorgPolicyFactory.createMovePolicy(iResourceArray, iJavaElementArray);
        if (!iMovePolicy.canEnable()) {
            return null;
        }
        JavaMoveProcessor javaMoveProcessor = new JavaMoveProcessor(iMovePolicy);
        if (!javaMoveProcessor.setDestination(iJavaElement).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(javaMoveProcessor);
    }

    public static ReorgMoveStarter create(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IResource iResource) throws JavaModelException {
        Assert.isNotNull((Object)iJavaElementArray);
        Assert.isNotNull((Object)iResourceArray);
        Assert.isNotNull((Object)iResource);
        IReorgPolicy.IMovePolicy iMovePolicy = ReorgPolicyFactory.createMovePolicy(iResourceArray, iJavaElementArray);
        if (!iMovePolicy.canEnable()) {
            return null;
        }
        JavaMoveProcessor javaMoveProcessor = new JavaMoveProcessor(iMovePolicy);
        if (!javaMoveProcessor.setDestination(iResource).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(javaMoveProcessor);
    }

    public void run(Shell shell) throws InterruptedException, InvocationTargetException {
        try {
            JavaMoveRefactoring javaMoveRefactoring = new JavaMoveRefactoring(this.fMoveProcessor);
            if (this.fMoveProcessor.hasAllInputSet()) {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries(shell));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries(shell));
                new RefactoringExecutionHelper((Refactoring)javaMoveRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), 2, shell, (IRunnableContext)progressMonitorDialog).perform(false, false);
            } else {
                ReorgMoveWizard reorgMoveWizard = new ReorgMoveWizard(javaMoveRefactoring);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)reorgMoveWizard));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)reorgMoveWizard));
                new RefactoringStarter().activate((Refactoring)javaMoveRefactoring, reorgMoveWizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 2);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

