/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class BreakContinueTargetFinder
extends ASTVisitor {
    private ASTNode fSelected;
    private boolean fIsBreak;
    private SimpleName fLabel;
    private String fContents;
    private static final Class[] STOPPERS;
    private static final Class[] BREAKTARGETS;
    private static final Class[] CONTINUETARGETS;
    private static final int BRACE_LENGTH = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Initializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        STOPPERS = classArray;
        Class[] classArray2 = new Class[6];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.ForInStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.wst.jsdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.wst.jsdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.wst.jsdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[4] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.wst.jsdt.core.dom.SwitchStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[5] = clazz8;
        BREAKTARGETS = classArray2;
        Class[] classArray3 = new Class[5];
        Class<?> clazz9 = class$2;
        if (clazz9 == null) {
            try {
                clazz9 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz9;
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.ForInStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz10;
        Class<?> clazz11 = class$4;
        if (clazz11 == null) {
            try {
                clazz11 = class$4 = Class.forName("org.eclipse.wst.jsdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[2] = clazz11;
        Class<?> clazz12 = class$5;
        if (clazz12 == null) {
            try {
                clazz12 = class$5 = Class.forName("org.eclipse.wst.jsdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[3] = clazz12;
        Class<?> clazz13 = class$6;
        if (clazz13 == null) {
            try {
                clazz13 = class$6 = Class.forName("org.eclipse.wst.jsdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[4] = clazz13;
        CONTINUETARGETS = classArray3;
    }

    public String initialize(CompilationUnit compilationUnit, int n, int n2) {
        return this.initialize(compilationUnit, NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    public String initialize(CompilationUnit compilationUnit, ASTNode aSTNode) {
        ASTNode aSTNode2 = this.getBreakOrContinueNode(aSTNode);
        if (aSTNode2 != null) {
            this.fContents = this.getContents(compilationUnit);
            if (this.fContents == null) {
                return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
            }
            this.fSelected = aSTNode2;
            this.fIsBreak = this.fSelected instanceof BreakStatement;
            this.fLabel = this.getLabel();
            return null;
        }
        return SearchMessages.BreakContinueTargetFinder_no_break_or_continue_selected;
    }

    private String getContents(CompilationUnit compilationUnit) {
        try {
            IJavaElement iJavaElement = compilationUnit.getJavaElement();
            if (iJavaElement instanceof ISourceReference) {
                return ((ISourceReference)iJavaElement).getSource();
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return null;
        }
    }

    private ASTNode getBreakOrContinueNode(ASTNode aSTNode) {
        if (aSTNode instanceof BreakStatement) {
            return aSTNode;
        }
        if (aSTNode instanceof ContinueStatement) {
            return aSTNode;
        }
        if (aSTNode instanceof SimpleName && aSTNode.getParent() instanceof BreakStatement) {
            return aSTNode.getParent();
        }
        if (aSTNode instanceof SimpleName && aSTNode.getParent() instanceof ContinueStatement) {
            return aSTNode.getParent();
        }
        return null;
    }

    public List perform() {
        return this.getNodesToHighlight();
    }

    private SimpleName getLabel() {
        if (this.fIsBreak) {
            BreakStatement breakStatement = (BreakStatement)this.fSelected;
            return breakStatement.getLabel();
        }
        ContinueStatement continueStatement = (ContinueStatement)this.fSelected;
        return continueStatement.getLabel();
    }

    private List getNodesToHighlight() {
        ASTNode aSTNode = this.findTargetNode(this.fSelected);
        if (!this.isEnclosingStatement(aSTNode)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ASTNode aSTNode2 = this.makeFakeNodeForFirstToken(aSTNode);
        if (aSTNode2 != null) {
            arrayList.add(aSTNode2);
        }
        if (this.fIsBreak && (aSTNode2 = this.makeFakeNodeForClosingBrace(aSTNode)) != null) {
            arrayList.add(aSTNode2);
        }
        return arrayList;
    }

    private boolean isEnclosingStatement(ASTNode aSTNode) {
        return aSTNode != null && !(aSTNode instanceof MethodDeclaration) && !(aSTNode instanceof Initializer);
    }

    private ASTNode findTargetNode(ASTNode aSTNode) {
        while (this.keepWalkingUp(aSTNode = aSTNode.getParent())) {
        }
        return aSTNode;
    }

    private ASTNode makeFakeNodeForFirstToken(ASTNode aSTNode) {
        try {
            int n = this.getLengthOfFirstTokenOf(aSTNode);
            if (n < 1) {
                return aSTNode;
            }
            return this.makeFakeNode(aSTNode.getStartPosition(), n, aSTNode.getAST());
        }
        catch (InvalidInputException invalidInputException) {
            return aSTNode;
        }
    }

    private SimpleName makeFakeNode(int n, int n2, AST aST) {
        String string = BreakContinueTargetFinder.makeStringOfLength(n2);
        SimpleName simpleName = aST.newSimpleName(string);
        simpleName.setSourceRange(n, n2);
        return simpleName;
    }

    private ASTNode makeFakeNodeForClosingBrace(ASTNode aSTNode) {
        ASTNode aSTNode2 = this.getOptionalBlock(aSTNode);
        if (aSTNode2 == null) {
            return null;
        }
        return this.makeFakeNode(ASTNodes.getExclusiveEnd(aSTNode2) - 1, 1, aSTNode.getAST());
    }

    private ASTNode getOptionalBlock(ASTNode aSTNode) {
        final ASTNode[] aSTNodeArray = new ASTNode[1];
        aSTNode.accept(new ASTVisitor(){

            public boolean visit(ForStatement forStatement) {
                if (forStatement.getBody() instanceof Block) {
                    aSTNodeArray[0] = forStatement.getBody();
                }
                return false;
            }

            public boolean visit(ForInStatement forInStatement) {
                if (forInStatement.getBody() instanceof Block) {
                    aSTNodeArray[0] = forInStatement.getBody();
                }
                return false;
            }

            public boolean visit(EnhancedForStatement enhancedForStatement) {
                if (enhancedForStatement.getBody() instanceof Block) {
                    aSTNodeArray[0] = enhancedForStatement.getBody();
                }
                return false;
            }

            public boolean visit(WhileStatement whileStatement) {
                if (whileStatement.getBody() instanceof Block) {
                    aSTNodeArray[0] = whileStatement.getBody();
                }
                return false;
            }

            public boolean visit(DoStatement doStatement) {
                if (doStatement.getBody() instanceof Block) {
                    aSTNodeArray[0] = doStatement.getBody();
                }
                return false;
            }

            public boolean visit(SwitchStatement switchStatement) {
                aSTNodeArray[0] = switchStatement;
                return false;
            }
        });
        return aSTNodeArray[0];
    }

    private static String makeStringOfLength(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, 'x');
        return new String(cArray);
    }

    private int getLengthOfFirstTokenOf(ASTNode aSTNode) throws InvalidInputException {
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        iScanner.setSource(this.getSource(aSTNode).toCharArray());
        iScanner.getNextToken();
        return iScanner.getRawTokenSource().length;
    }

    private String getSource(ASTNode aSTNode) {
        return this.fContents.substring(aSTNode.getStartPosition(), ASTNodes.getInclusiveEnd(aSTNode));
    }

    private boolean keepWalkingUp(ASTNode aSTNode) {
        if (aSTNode == null) {
            return false;
        }
        if (BreakContinueTargetFinder.isAnyInstanceOf(STOPPERS, aSTNode)) {
            return false;
        }
        if (this.fLabel != null) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("org.eclipse.wst.jsdt.core.dom.LabeledStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(aSTNode)) {
                LabeledStatement labeledStatement = (LabeledStatement)aSTNode;
                return !BreakContinueTargetFinder.areEqualLabels(labeledStatement.getLabel(), this.fLabel);
            }
        }
        if (this.fLabel == null && this.fIsBreak && BreakContinueTargetFinder.isAnyInstanceOf(BREAKTARGETS, aSTNode)) {
            return false;
        }
        return this.fLabel != null || this.fIsBreak || !BreakContinueTargetFinder.isAnyInstanceOf(CONTINUETARGETS, aSTNode);
    }

    private static boolean areEqualLabels(SimpleName simpleName, SimpleName simpleName2) {
        return simpleName2.getIdentifier().equals(simpleName.getIdentifier());
    }

    private static boolean isAnyInstanceOf(Class[] classArray, ASTNode aSTNode) {
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].isInstance(aSTNode)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

