/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.DeprecatedFilter;
import org.eclipse.wst.jsdt.internal.ui.search.ErasureMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.ImportFilter;
import org.eclipse.wst.jsdt.internal.ui.search.InexactMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.JavadocFilter;
import org.eclipse.wst.jsdt.internal.ui.search.NonDeprecatedFilter;
import org.eclipse.wst.jsdt.internal.ui.search.NonPublicFilter;
import org.eclipse.wst.jsdt.internal.ui.search.NonStaticFilter;
import org.eclipse.wst.jsdt.internal.ui.search.PolymorphicFilter;
import org.eclipse.wst.jsdt.internal.ui.search.PotentialFilter;
import org.eclipse.wst.jsdt.internal.ui.search.ReadFilter;
import org.eclipse.wst.jsdt.internal.ui.search.StaticFilter;
import org.eclipse.wst.jsdt.internal.ui.search.WriteFilter;

abstract class JavaMatchFilter
extends MatchFilter {
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final JavaMatchFilter POTENTIAL_FILTER = new PotentialFilter();
    private static final JavaMatchFilter IMPORT_FILTER = new ImportFilter();
    private static final JavaMatchFilter JAVADOC_FILTER = new JavadocFilter();
    private static final JavaMatchFilter READ_FILTER = new ReadFilter();
    private static final JavaMatchFilter WRITE_FILTER = new WriteFilter();
    private static final JavaMatchFilter POLYMORPHIC_FILTER = new PolymorphicFilter();
    private static final JavaMatchFilter INEXACT_FILTER = new InexactMatchFilter();
    private static final JavaMatchFilter ERASURE_FILTER = new ErasureMatchFilter();
    private static final JavaMatchFilter NON_PUBLIC_FILTER = new NonPublicFilter();
    private static final JavaMatchFilter STATIC_FILTER = new StaticFilter();
    private static final JavaMatchFilter NON_STATIC_FILTER = new NonStaticFilter();
    private static final JavaMatchFilter DEPRECATED_FILTER = new DeprecatedFilter();
    private static final JavaMatchFilter NON_DEPRECATED_FILTER = new NonDeprecatedFilter();
    private static final JavaMatchFilter[] ALL_FILTERS = new JavaMatchFilter[]{POTENTIAL_FILTER, IMPORT_FILTER, JAVADOC_FILTER, READ_FILTER, WRITE_FILTER, POLYMORPHIC_FILTER, INEXACT_FILTER, ERASURE_FILTER, NON_PUBLIC_FILTER, STATIC_FILTER, NON_STATIC_FILTER, DEPRECATED_FILTER, NON_DEPRECATED_FILTER};

    JavaMatchFilter() {
    }

    public abstract boolean filters(JavaElementMatch var1);

    public abstract boolean isApplicable(JavaSearchQuery var1);

    public boolean filters(Match match) {
        if (match instanceof JavaElementMatch) {
            return this.filters((JavaElementMatch)match);
        }
        return false;
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = JavaPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return JavaMatchFilter.decodeFiltersString(string);
        }
        return JavaMatchFilter.getDefaultFilters();
    }

    public static void setLastUsedFilters(MatchFilter[] matchFilterArray) {
        String string = JavaMatchFilter.encodeFilters(matchFilterArray);
        JavaPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, string);
    }

    public static MatchFilter[] getDefaultFilters() {
        return new MatchFilter[]{IMPORT_FILTER};
    }

    private static String encodeFilters(MatchFilter[] matchFilterArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < matchFilterArray.length) {
            MatchFilter matchFilter = matchFilterArray[n];
            stringBuffer.append(matchFilter.getID());
            stringBuffer.append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static JavaMatchFilter[] decodeFiltersString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(';'));
        HashSet<JavaMatchFilter> hashSet = new HashSet<JavaMatchFilter>();
        while (stringTokenizer.hasMoreTokens()) {
            JavaMatchFilter javaMatchFilter = JavaMatchFilter.findMatchFilter(stringTokenizer.nextToken());
            if (javaMatchFilter == null) continue;
            hashSet.add(javaMatchFilter);
        }
        return hashSet.toArray(new JavaMatchFilter[hashSet.size()]);
    }

    public static JavaMatchFilter[] allFilters() {
        return ALL_FILTERS;
    }

    public static JavaMatchFilter[] allFilters(JavaSearchQuery javaSearchQuery) {
        ArrayList<JavaMatchFilter> arrayList = new ArrayList<JavaMatchFilter>();
        int n = 0;
        while (n < ALL_FILTERS.length) {
            JavaMatchFilter javaMatchFilter = ALL_FILTERS[n];
            if (javaMatchFilter.isApplicable(javaSearchQuery)) {
                arrayList.add(javaMatchFilter);
            }
            ++n;
        }
        return arrayList.toArray(new JavaMatchFilter[arrayList.size()]);
    }

    private static JavaMatchFilter findMatchFilter(String string) {
        int n = 0;
        while (n < ALL_FILTERS.length) {
            JavaMatchFilter javaMatchFilter = ALL_FILTERS[n];
            if (javaMatchFilter.getID().equals(string)) {
                return javaMatchFilter;
            }
            ++n;
        }
        return null;
    }
}

