/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class JavaSearchEditorOpener {
    private IEditorReference fReusedEditor;

    public IEditorPart openElement(Object object) throws PartInitException, JavaModelException {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(object, iWorkbenchPage);
        }
        return this.showWithoutReuse(object, iWorkbenchPage);
    }

    public IEditorPart openMatch(Match match) throws PartInitException, JavaModelException {
        Object object = this.getElementToOpen(match);
        return this.openElement(object);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object object, IWorkbenchPage iWorkbenchPage) throws PartInitException, JavaModelException {
        return EditorUtility.openInEditor(object, false);
    }

    private IEditorPart showWithReuse(Object object, IWorkbenchPage iWorkbenchPage) throws JavaModelException, PartInitException {
        IFile iFile = this.getFile(object);
        if (iFile != null) {
            String string = this.getEditorID(iFile);
            return this.showInEditor(iWorkbenchPage, (IEditorInput)new FileEditorInput(iFile), string);
        }
        IClassFile iClassFile = this.getClassFile(object);
        if (iClassFile != null) {
            return this.showInEditor(iWorkbenchPage, new InternalClassFileEditorInput(iClassFile), "org.eclipse.wst.jsdt.ui.ClassFileEditor");
        }
        return null;
    }

    private IFile getFile(Object object) throws JavaModelException {
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
            if (iCompilationUnit != null) {
                return (IFile)iCompilationUnit.getCorrespondingResource();
            }
            IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
            if (iClassFile != null) {
                return (IFile)iClassFile.getCorrespondingResource();
            }
        }
        return null;
    }

    private String getEditorID(IFile iFile) throws PartInitException {
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
        if (iEditorDescriptor == null) {
            return JavaPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return iEditorDescriptor.getId();
    }

    private IEditorPart showInEditor(IWorkbenchPage iWorkbenchPage, IEditorInput iEditorInput, String string) {
        IEditorPart iEditorPart = iWorkbenchPage.findEditor(iEditorInput);
        if (iEditorPart != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            return iEditorPart;
        }
        IEditorReference iEditorReference = this.fReusedEditor;
        if (iEditorReference != null) {
            boolean bl;
            boolean bl2 = iEditorReference.getEditor(false) != null;
            boolean bl3 = bl = bl2 && !iEditorReference.isDirty() && !iEditorReference.isPinned();
            if (bl) {
                boolean bl4 = iEditorReference.getId().equals(string);
                if (!bl4) {
                    iWorkbenchPage.closeEditors(new IEditorReference[]{iEditorReference}, false);
                    this.fReusedEditor = null;
                } else {
                    iEditorPart = iEditorReference.getEditor(true);
                    if (iEditorPart instanceof IReusableEditor) {
                        ((IReusableEditor)iEditorPart).setInput(iEditorInput);
                        iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                        return iEditorPart;
                    }
                }
            }
        }
        try {
            IEditorReference iEditorReference2;
            iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, false);
            this.fReusedEditor = iEditorPart instanceof IReusableEditor ? (iEditorReference2 = (IEditorReference)iWorkbenchPage.getReference((IWorkbenchPart)iEditorPart)) : null;
            return iEditorPart;
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.Search_Error_openEditor_title, (String)SearchMessages.Search_Error_openEditor_message);
            return null;
        }
    }

    private IClassFile getClassFile(Object object) {
        if (!(object instanceof IJavaElement)) {
            return null;
        }
        if (object instanceof IClassFile) {
            return (IClassFile)object;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        if (iJavaElement instanceof IMember) {
            return ((IMember)iJavaElement).getClassFile();
        }
        return null;
    }
}

