/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.CopyQualifiedNameAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.search.GroupAction;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchTableContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.NewSearchViewActionGroup;
import org.eclipse.wst.jsdt.internal.ui.search.PostfixLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SortAction;
import org.eclipse.wst.jsdt.internal.ui.search.SortingLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;

public class JavaSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String KEY_GROUPING = "org.eclipse.wst.jsdt.search.resultpage.grouping";
    private static final String KEY_SORTING = "org.eclipse.wst.jsdt.search.resultpage.sorting";
    private static final String KEY_LIMIT_ENABLED = "org.eclipse.wst.jsdt.search.resultpage.limit_enabled";
    private static final String KEY_LIMIT = "org.eclipse.wst.jsdt.search.resultpage.limit";
    private static final String GROUP_GROUPING = "org.eclipse.wst.jsdt.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "org.eclipse.wst.jsdt.search.resultpage.filtering";
    private NewSearchViewActionGroup fActionGroup;
    private JavaSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByParentName;
    private SortAction fSortByPathAction;
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupPackageAction;
    private GroupAction fGroupProjectAction;
    private SelectionDispatchAction fCopyQualifiedNameAction = null;
    private SortingLabelProvider fSortingLabelProvider;
    private int fCurrentGrouping;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private JavaSearchEditorOpener fEditorOpener = new JavaSearchEditorOpener();
    static /* synthetic */ Class class$0;

    public JavaSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.setElementLimit(new Integer(1000));
    }

    private void initSortActions() {
        this.fSortByNameAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByName, this, 1);
        this.fSortByPathAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByPath, this, 3);
        this.fSortByParentName = new SortAction(SearchMessages.JavaSearchResultPage_sortByParentName, this, 2);
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_project, SearchMessages.JavaSearchResultPage_groupby_project_tooltip, this, 4);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "prj_mode.gif");
        this.fGroupPackageAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_package, SearchMessages.JavaSearchResultPage_groupby_package_tooltip, this, 3);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupPackageAction, "package_mode.gif");
        this.fGroupFileAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_file, SearchMessages.JavaSearchResultPage_groupby_file_tooltip, this, 2);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "file_mode.gif");
        this.fGroupTypeAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_type, SearchMessages.JavaSearchResultPage_groupby_type_tooltip, this, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "type_mode.gif");
    }

    public void setViewPart(ISearchResultViewPart iSearchResultViewPart) {
        super.setViewPart(iSearchResultViewPart);
        this.fActionGroup = new NewSearchViewActionGroup((IViewPart)iSearchResultViewPart);
    }

    public void showMatch(Match match, int n, int n2, boolean bl) throws PartInitException {
        IEditorPart iEditorPart;
        try {
            iEditorPart = this.fEditorOpener.openMatch(match);
        }
        catch (JavaModelException javaModelException) {
            throw new PartInitException(javaModelException.getStatus());
        }
        if (iEditorPart != null && bl) {
            iEditorPart.getEditorSite().getPage().activate((IWorkbenchPart)iEditorPart);
        }
        Object object = match.getElement();
        if (iEditorPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            iTextEditor.selectAndReveal(n, n2);
        } else if (iEditorPart != null) {
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                this.showWithMarker(iEditorPart, iFile, n, n2);
            }
        } else {
            JavaSearchResult javaSearchResult = (JavaSearchResult)this.getInput();
            IMatchPresentation iMatchPresentation = javaSearchResult.getSearchParticpant(object);
            if (iMatchPresentation != null) {
                iMatchPresentation.showMatch(match, n, n2, bl);
            }
        }
    }

    private void showWithMarker(IEditorPart iEditorPart, IFile iFile, int n, int n2) throws PartInitException {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
            hashMap.put("charStart", new Integer(n));
            hashMap.put("charEnd", new Integer(n + n2));
            iMarker.setAttributes(hashMap);
            IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            iMarker.delete();
        }
        catch (CoreException coreException) {
            throw new PartInitException(SearchMessages.JavaSearchResultPage_error_marker, (Throwable)coreException);
        }
    }

    private SelectionDispatchAction getCopyQualifiedNameAction() {
        if (this.fCopyQualifiedNameAction == null) {
            this.fCopyQualifiedNameAction = new CopyQualifiedNameAction((IWorkbenchSite)this.getSite());
        }
        return this.fCopyQualifiedNameAction;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.addSortActions(iMenuManager);
        iMenuManager.appendToGroup("group.edit", (IAction)this.getCopyQualifiedNameAction());
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(iMenuManager);
    }

    private void addSortActions(IMenuManager iMenuManager) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager menuManager = new MenuManager(SearchMessages.JavaSearchResultPage_sortBylabel);
        menuManager.add((IAction)this.fSortByNameAction);
        menuManager.add((IAction)this.fSortByPathAction);
        menuManager.add((IAction)this.fSortByParentName);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        this.fSortByParentName.setChecked(this.fCurrentSortOrder == this.fSortByParentName.getSortOrder());
        iMenuManager.appendToGroup("group.viewerSetup", (IContributionItem)menuManager);
    }

    protected void fillToolbar(IToolBarManager iToolBarManager) {
        super.fillToolbar(iToolBarManager);
        IActionBars iActionBars = this.getSite().getActionBars();
        if (iActionBars != null) {
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.CopyQualifiedName", (IAction)this.getCopyQualifiedNameAction());
        }
        if (this.getLayout() != 1) {
            this.addGroupActions(iToolBarManager);
        }
    }

    private void addGroupActions(IToolBarManager iToolBarManager) {
        iToolBarManager.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.wst.jsdt.search.resultpage.grouping"));
        iToolBarManager.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        iToolBarManager.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupPackageAction);
        iToolBarManager.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        iToolBarManager.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 4);
        this.fGroupPackageAction.setChecked(this.fCurrentGrouping == 3);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 2);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 1);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objectArray) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objectArray);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    private void addDragAdapters(StructuredViewer structuredViewer) {
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        int n = 5;
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)structuredViewer), new ResourceTransferDragAdapter((ISelectionProvider)structuredViewer)};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new JdtViewerDragAdapter(structuredViewer, transferDragSourceListenerArray));
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        tableViewer.setUseHashlookup(true);
        this.fSortingLabelProvider = new SortingLabelProvider(this);
        tableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fSortingLabelProvider, false));
        this.fContentProvider = new JavaSearchTableContentProvider(this);
        tableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        tableViewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter(this.fSortingLabelProvider));
        this.setSortOrder(this.fCurrentSortOrder);
        this.addDragAdapters((StructuredViewer)tableViewer);
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        PostfixLabelProvider postfixLabelProvider = new PostfixLabelProvider(this);
        treeViewer.setUseHashlookup(true);
        treeViewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter(postfixLabelProvider));
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(postfixLabelProvider, false));
        this.fContentProvider = new LevelTreeContentProvider(this, this.fCurrentGrouping);
        treeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.addDragAdapters((StructuredViewer)treeViewer);
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        ProblemTreeViewer problemTreeViewer = new ProblemTreeViewer(composite, 770);
        ColoredViewersManager.install((StructuredViewer)problemTreeViewer);
        return problemTreeViewer;
    }

    protected TableViewer createTableViewer(Composite composite) {
        ProblemTableViewer problemTableViewer = new ProblemTableViewer(composite, 770);
        ColoredViewersManager.install((StructuredViewer)problemTableViewer);
        return problemTableViewer;
    }

    void setSortOrder(int n) {
        if (this.fSortingLabelProvider != null) {
            this.fCurrentSortOrder = n;
            StructuredViewer structuredViewer = this.getViewer();
            this.fSortingLabelProvider.setOrder(n);
            structuredViewer.refresh();
            this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
        }
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        IMenuManager iMenuManager = iPageSite.getActionBars().getMenuManager();
        iMenuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        this.fActionGroup.fillActionBars(iPageSite.getActionBars());
        iMenuManager.appendToGroup("group.properties", (IAction)new Action(SearchMessages.JavaSearchResultPage_preferences_label){

            public void run() {
                String string = "org.eclipse.search.preferences.SearchPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)string, null, null).open();
            }
        });
    }

    void setGrouping(int n) {
        this.fCurrentGrouping = n;
        StructuredViewer structuredViewer = this.getViewer();
        LevelTreeContentProvider levelTreeContentProvider = (LevelTreeContentProvider)structuredViewer.getContentProvider();
        levelTreeContentProvider.setLevel(n);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.wst.jsdt.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento iMemento) {
        super.restoreState(iMemento);
        int n = 1;
        int n2 = 3;
        int n3 = 1000;
        try {
            n = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            n2 = this.getSettings().getInt("org.eclipse.wst.jsdt.search.resultpage.grouping");
        }
        catch (NumberFormatException numberFormatException) {}
        if (FALSE.equals(this.getSettings().get(KEY_LIMIT_ENABLED))) {
            n3 = -1;
        } else {
            try {
                n3 = this.getSettings().getInt(KEY_LIMIT);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (iMemento != null) {
            Integer n4 = iMemento.getInteger("org.eclipse.wst.jsdt.search.resultpage.grouping");
            if (n4 != null) {
                n2 = n4;
            }
            if ((n4 = iMemento.getInteger(KEY_SORTING)) != null) {
                n = n4;
            }
            boolean bl = !FALSE.equals(iMemento.getString(KEY_LIMIT_ENABLED));
            n4 = iMemento.getInteger(KEY_LIMIT);
            if (n4 != null) {
                n3 = bl ? n4 : -1;
            }
        }
        this.fCurrentGrouping = n2;
        this.fCurrentSortOrder = n;
        this.setElementLimit(new Integer(n3));
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        iMemento.putInteger("org.eclipse.wst.jsdt.search.resultpage.grouping", this.fCurrentGrouping);
        iMemento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        int n = this.getElementLimit();
        if (n != -1) {
            iMemento.putString(KEY_LIMIT_ENABLED, TRUE);
        } else {
            iMemento.putString(KEY_LIMIT_ENABLED, FALSE);
        }
        iMemento.putInteger(KEY_LIMIT, n);
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult abstractTextSearchResult = this.getInput();
        if (abstractTextSearchResult != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)abstractTextSearchResult.getQuery());
        }
        return false;
    }

    public String getLabel() {
        String string = super.getLabel();
        AbstractTextSearchResult abstractTextSearchResult = this.getInput();
        if (abstractTextSearchResult != null && abstractTextSearchResult.getActiveMatchFilters() != null && abstractTextSearchResult.getActiveMatchFilters().length > 0) {
            if (this.isQueryRunning()) {
                String string2 = SearchMessages.JavaSearchResultPage_filtered_message;
                return Messages.format(string2, new Object[]{string});
            }
            int n = abstractTextSearchResult.getMatchCount() - this.getFilteredMatchCount();
            String string3 = SearchMessages.JavaSearchResultPage_filteredWithCount_message;
            return Messages.format(string3, new Object[]{string, String.valueOf(n)});
        }
        return string;
    }

    private int getFilteredMatchCount() {
        StructuredViewer structuredViewer = this.getViewer();
        if (structuredViewer instanceof TreeViewer) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)structuredViewer.getContentProvider();
            return this.getMatchCount(iTreeContentProvider, this.getRootElements((TreeViewer)this.getViewer()));
        }
        return this.getMatchCount((TableViewer)structuredViewer);
    }

    private Object[] getRootElements(TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        TreeItem[] treeItemArray = tree.getItems();
        Object[] objectArray = new Object[treeItemArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = treeItemArray[n].getData();
            ++n;
        }
        return objectArray;
    }

    private Object[] getRootElements(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableItem[] tableItemArray = table.getItems();
        Object[] objectArray = new Object[tableItemArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = tableItemArray[n].getData();
            ++n;
        }
        return objectArray;
    }

    private int getMatchCount(ITreeContentProvider iTreeContentProvider, Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += this.getDisplayedMatchCount(objectArray[n2]);
            Object[] objectArray2 = iTreeContentProvider.getChildren(objectArray[n2]);
            n += this.getMatchCount(iTreeContentProvider, objectArray2);
            ++n2;
        }
        return n;
    }

    private int getMatchCount(TableViewer tableViewer) {
        Object[] objectArray = this.getRootElements(tableViewer);
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += this.getDisplayedMatchCount(objectArray[n2]);
            ++n2;
        }
        return n;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent openEvent) {
        Object object = ((IStructuredSelection)openEvent.getSelection()).getFirstElement();
        if ((object instanceof ICompilationUnit || object instanceof IClassFile || object instanceof IMember) && this.getDisplayedMatchCount(object) == 0) {
            try {
                this.fEditorOpener.openElement(object);
            }
            catch (CoreException coreException) {
                ExceptionHandler.handle(coreException, this.getSite().getShell(), SearchMessages.JavaSearchResultPage_open_editor_error_title, SearchMessages.JavaSearchResultPage_open_editor_error_message);
            }
            return;
        }
        super.handleOpen(openEvent);
    }

    public void setElementLimit(Integer n) {
        super.setElementLimit(n);
        int n2 = n;
        this.getSettings().put(KEY_LIMIT, n2);
        this.getSettings().put(KEY_LIMIT_ENABLED, n2 != -1 ? TRUE : FALSE);
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider iLabelProvider) {
            this.fLabelProvider = iLabelProvider;
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            String string = this.fLabelProvider.getText(object);
            String string2 = this.fLabelProvider.getText(object2);
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return this.getComparator().compare(string, string2);
        }
    }
}

