/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;

public class SearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    JavaSearchResult fResult;
    private static final int REMOVED_FLAGS = 1185;

    public SearchResultUpdater(JavaSearchResult javaSearchResult) {
        this.fResult = javaSearchResult;
        NewSearchUI.addQueryListener((IQueryListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        IJavaElementDelta iJavaElementDelta = elementChangedEvent.getDelta();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.collectRemoved(hashSet2, hashSet, iJavaElementDelta);
        if (hashSet.size() > 0) {
            this.handleRemoved(hashSet);
        }
        if (hashSet2.size() > 0) {
            this.handleRemoved(hashSet2);
        }
    }

    private void handleRemoved(Set set) {
        Object[] objectArray = this.fResult.getElements();
        int n = 0;
        while (n < objectArray.length) {
            if (this.isContainedInRemoved(set, objectArray[n])) {
                int n2;
                Match[] matchArray;
                IJavaElement iJavaElement;
                if (objectArray[n] instanceof IJavaElement) {
                    iJavaElement = (IJavaElement)objectArray[n];
                    if (!iJavaElement.exists()) {
                        matchArray = this.fResult.getMatches(objectArray[n]);
                        n2 = 0;
                        while (n2 < matchArray.length) {
                            this.fResult.removeMatch(matchArray[n2]);
                            ++n2;
                        }
                    }
                } else if (objectArray[n] instanceof IResource && !(iJavaElement = (IResource)objectArray[n]).exists()) {
                    matchArray = this.fResult.getMatches(objectArray[n]);
                    n2 = 0;
                    while (n2 < matchArray.length) {
                        this.fResult.removeMatch(matchArray[n2]);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private boolean isContainedInRemoved(Set set, Object object) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!this.isParentOf(iterator.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object object, Object object2) {
        while (object2 != null && !object.equals(object2)) {
            object2 = this.getParent(object2);
        }
        return object2 != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private void collectRemoved(Set set, Set set2, IJavaElementDelta iJavaElementDelta) {
        if (iJavaElementDelta.getKind() == 2) {
            set2.add(iJavaElementDelta.getElement());
        } else if (iJavaElementDelta.getKind() == 4) {
            int n = iJavaElementDelta.getFlags();
            if ((n & 0x4A1) != 0) {
                set.add(iJavaElementDelta.getElement());
            } else {
                IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
                int n2 = 0;
                while (n2 < iJavaElementDeltaArray.length) {
                    this.collectRemoved(set, set2, iJavaElementDeltaArray[n2]);
                    ++n2;
                }
            }
        }
        IResourceDelta[] iResourceDeltaArray = iJavaElementDelta.getResourceDeltas();
        if (iResourceDeltaArray != null) {
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.collectRemovals(set2, iResourceDeltaArray[n]);
                ++n;
            }
        }
    }

    public void queryAdded(ISearchQuery iSearchQuery) {
    }

    public void queryRemoved(ISearchQuery iSearchQuery) {
        if (((Object)((Object)this.fResult)).equals(iSearchQuery.getSearchResult())) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    private void collectRemovals(Set set, IResourceDelta iResourceDelta) {
        if (iResourceDelta.getKind() == 2) {
            set.add(iResourceDelta.getResource());
        } else {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.collectRemovals(set, iResourceDeltaArray[n]);
                ++n;
            }
        }
    }

    public void queryStarting(ISearchQuery iSearchQuery) {
    }

    public void queryFinished(ISearchQuery iSearchQuery) {
    }
}

