/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;

public class SearchUtil {
    public static final int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "JavaElementSearchActions";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static final String BIN_PRIM_CONST_WARN_DIALOG_ID = "BinaryPrimitiveConstantWarningDialog";
    static /* synthetic */ Class class$0;

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static void runQueryInBackground(Object object) {
        NewSearchUI.runQueryInBackground((ISearchQuery)((ISearchQuery)object));
    }

    public static IStatus runQueryInForeground(IRunnableContext iRunnableContext, Object object) {
        return NewSearchUI.runQueryInForeground((IRunnableContext)iRunnableContext, (ISearchQuery)((ISearchQuery)object));
    }

    static ICompilationUnit findCompilationUnit(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        return (ICompilationUnit)iJavaElement.getAncestor(5);
    }

    public static String toString(IWorkingSet[] iWorkingSetArray) {
        Arrays.sort(iWorkingSetArray, new WorkingSetComparator());
        String string = "";
        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < iWorkingSetArray.length) {
                String string2 = iWorkingSetArray[n].getLabel();
                if (bl) {
                    string = Messages.format(SearchMessages.SearchUtil_workingSetConcatenation, new String[]{string, string2});
                } else {
                    string = string2;
                    bl = true;
                }
                ++n;
            }
        }
        return string;
    }

    public static void updateLRUWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null || iWorkingSetArray.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(iWorkingSetArray);
        SearchUtil.saveState(SearchUtil.getDialogStoreSection());
    }

    private static void saveState(IDialogSettings iDialogSettings) {
        Iterator iterator = fgLRUWorkingSets.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IWorkingSet[] iWorkingSetArray = (IWorkingSet[])iterator.next();
            String[] stringArray = new String[iWorkingSetArray.length];
            int n2 = 0;
            while (n2 < iWorkingSetArray.length) {
                stringArray[n2] = iWorkingSetArray[n2].getName();
                ++n2;
            }
            iDialogSettings.put(STORE_LRU_WORKING_SET_NAMES + n, stringArray);
            ++n;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    private static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings iDialogSettings = SearchUtil.getDialogStoreSection();
        boolean bl = false;
        int n = 2;
        while (n >= 0) {
            String[] stringArray = iDialogSettings.getArray(STORE_LRU_WORKING_SET_NAMES + n);
            if (stringArray != null) {
                HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(2);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    IWorkingSet iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(stringArray[n2]);
                    if (iWorkingSet != null) {
                        hashSet.add(iWorkingSet);
                    }
                    ++n2;
                }
                bl = true;
                if (!hashSet.isEmpty()) {
                    fgLRUWorkingSets.add(hashSet.toArray(new IWorkingSet[hashSet.size()]));
                }
            }
            --n;
        }
        if (!bl) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static IDialogSettings getDialogStoreSection() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings == null) {
            iDialogSettings = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return iDialogSettings;
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings iDialogSettings = SearchUtil.getDialogStoreSection();
        boolean bl = false;
        String[] stringArray = iDialogSettings.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (stringArray != null) {
            int n = stringArray.length - 1;
            while (n >= 0) {
                IWorkingSet iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(stringArray[n]);
                if (iWorkingSet != null) {
                    bl = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{iWorkingSet});
                }
                --n;
            }
        }
        if (bl) {
            SearchUtil.saveState(iDialogSettings);
        }
    }

    public static void warnIfBinaryConstant(IJavaElement iJavaElement, Shell shell) {
        if (SearchUtil.isBinaryPrimitiveConstantOrString(iJavaElement)) {
            OptionalMessageDialog.open(BIN_PRIM_CONST_WARN_DIALOG_ID, shell, SearchMessages.Search_FindReferencesAction_BinPrimConstWarnDialog_title, null, SearchMessages.Search_FindReferencesAction_BinPrimConstWarnDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }
    }

    private static boolean isBinaryPrimitiveConstantOrString(IJavaElement iJavaElement) {
        if (iJavaElement != null && iJavaElement.getElementType() == 8) {
            int n;
            IField iField = (IField)iJavaElement;
            try {
                n = iField.getFlags();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            return iField.isBinary() && Flags.isStatic((int)n) && Flags.isFinal((int)n) && SearchUtil.isPrimitiveOrString(iField);
        }
        return false;
    }

    private static boolean isPrimitiveOrString(IField iField) {
        block9: {
            block10: {
                String string;
                try {
                    string = iField.getTypeSignature();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                char c = string.charAt(0);
                if (c != 'L' && c != 'Q' && c != '[') break block9;
                if (c != 'L') break block10;
                String string2 = string.substring(1, string.length() - 1);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (string2.equals(clazz.getName())) break block9;
            }
            return false;
        }
        return true;
    }
}

