/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.internal.ui.text.ChangeHoverInformationControl;

public class JavaChangeHover
extends LineChangeHover {
    private String fPartition;
    private ChangeHoverInformationControl fInformationControl;
    private String fPartitioning;
    private int fLastScrollIndex = 0;
    private int fOrientation;

    public JavaChangeHover(String string, int n) {
        Assert.isLegal((n == 0x4000000 || n == 0x2000000 ? 1 : 0) != 0);
        this.fPartitioning = string;
        this.fOrientation = n;
    }

    protected String formatSource(String string) {
        return string;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 0xC | JavaChangeHover.this.fOrientation;
                JavaChangeHover.this.fInformationControl = new ChangeHoverInformationControl(shell, n, 0, JavaChangeHover.this.fPartition, EditorsUI.getTooltipAffordanceString());
                JavaChangeHover.this.fInformationControl.setHorizontalScrollPixel(JavaChangeHover.this.fLastScrollIndex);
                return JavaChangeHover.this.fInformationControl;
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 0x14 | JavaChangeHover.this.fOrientation;
                int n2 = 768;
                JavaChangeHover.this.fInformationControl = new ChangeHoverInformationControl(shell, n, n2, JavaChangeHover.this.fPartition, null);
                JavaChangeHover.this.fInformationControl.setHorizontalScrollPixel(JavaChangeHover.this.fLastScrollIndex);
                return JavaChangeHover.this.fInformationControl;
            }
        };
    }

    protected Point computeLineRange(ISourceViewer iSourceViewer, int n, int n2, int n3) {
        Point point = super.computeLineRange(iSourceViewer, n, n2, n3);
        this.fPartition = point != null ? this.getPartition(iSourceViewer, point.x) : "__dftl_partition_content_type";
        this.fLastScrollIndex = iSourceViewer.getTextWidget().getHorizontalPixel();
        if (this.fInformationControl != null) {
            this.fInformationControl.setStartingPartitionType(this.fPartition);
            this.fInformationControl.setHorizontalScrollPixel(this.fLastScrollIndex);
        }
        return point;
    }

    private String getPartition(ISourceViewer iSourceViewer, int n) {
        if (iSourceViewer == null) {
            return null;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return null;
        }
        if (n <= 0) {
            return "__dftl_partition_content_type";
        }
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)(iDocument.getLineOffset(n) - 1), (boolean)true);
            return iTypedRegion.getType();
        }
        catch (BadLocationException badLocationException) {
            return "__dftl_partition_content_type";
        }
    }

    protected String getTabReplacement() {
        return Character.toString('\t');
    }
}

