/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.CombinedWordRule;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public class JavaCommentScanner
extends AbstractJavaScanner {
    private static final String COMPILER_TASK_TAGS = "org.eclipse.wst.jsdt.core.compiler.taskTags";
    protected static final String TASK_TAG = "java_comment_task_tag";
    private static final String COMPILER_TASK_CASE_SENSITIVE = "org.eclipse.wst.jsdt.core.compiler.taskCaseSensitive";
    private static final String ENABLED = "enabled";
    private TaskTagMatcher fTaskTagMatcher;
    private Preferences fCorePreferenceStore;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public JavaCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, String string) {
        this(iColorManager, iPreferenceStore, preferences, string, new String[]{string, TASK_TAG});
    }

    public JavaCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, String string, String[] stringArray) {
        super(iColorManager, iPreferenceStore);
        this.fCorePreferenceStore = preferences;
        this.fDefaultTokenProperty = string;
        this.fTokenProperties = stringArray;
        this.initialize();
    }

    public JavaCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string) {
        this(iColorManager, iPreferenceStore, null, string, new String[]{string, TASK_TAG});
    }

    public JavaCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string, String[] stringArray) {
        this(iColorManager, iPreferenceStore, null, string, stringArray);
    }

    protected List createRules() {
        ArrayList<CombinedWordRule> arrayList = new ArrayList<CombinedWordRule>();
        Token token = this.getToken(this.fDefaultTokenProperty);
        List list = this.createMatchers();
        if (list.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new AtJavaIdentifierDetector(), (IToken)token);
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)list.get(n));
                ++n;
            }
            arrayList.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)token);
        return arrayList;
    }

    protected List createMatchers() {
        ArrayList<TaskTagMatcher> arrayList = new ArrayList<TaskTagMatcher>();
        boolean bl = true;
        String string = null;
        if (this.getPreferenceStore().contains(COMPILER_TASK_TAGS)) {
            string = this.getPreferenceStore().getString(COMPILER_TASK_TAGS);
            bl = ENABLED.equals(this.getPreferenceStore().getString(COMPILER_TASK_CASE_SENSITIVE));
        } else if (this.fCorePreferenceStore != null) {
            string = this.fCorePreferenceStore.getString(COMPILER_TASK_TAGS);
            bl = ENABLED.equals(this.fCorePreferenceStore.getString(COMPILER_TASK_CASE_SENSITIVE));
        }
        if (string != null) {
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)this.getToken(TASK_TAG));
            this.fTaskTagMatcher.addTaskTags(string);
            this.fTaskTagMatcher.setCaseSensitive(bl);
            arrayList.add(this.fTaskTagMatcher);
        }
        return arrayList;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(COMPILER_TASK_TAGS) || propertyChangeEvent.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE) || super.affectsBehavior(propertyChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fTaskTagMatcher != null && propertyChangeEvent.getProperty().equals(COMPILER_TASK_TAGS)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags((String)object);
                }
            }
        } else if (this.fTaskTagMatcher != null && propertyChangeEvent.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                this.fTaskTagMatcher.setCaseSensitive(ENABLED.equals(object));
            }
        } else if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private static class AtJavaIdentifierDetector
    implements IWordDetector {
        private AtJavaIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return c == '.' || Character.isJavaIdentifierPart(c);
        }
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map fUppercaseWords = new HashMap();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken iToken) {
            this.fToken = iToken;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String string) {
            String[] stringArray = this.split(string, ",");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    this.addWord(stringArray[n], this.fToken);
                }
                ++n;
            }
        }

        private String[] split(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }

        public synchronized void addWord(String string, IToken iToken) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)iToken);
            super.addWord(string, iToken);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(string.toUpperCase()), iToken);
        }

        public synchronized IToken evaluate(ICharacterScanner iCharacterScanner, CombinedWordRule.CharacterBuffer characterBuffer) {
            if (this.fCaseSensitive) {
                return super.evaluate(iCharacterScanner, characterBuffer);
            }
            this.fBuffer.clear();
            int n = 0;
            int n2 = characterBuffer.length();
            while (n < n2) {
                this.fBuffer.append(Character.toUpperCase(characterBuffer.charAt(n)));
                ++n;
            }
            IToken iToken = (IToken)this.fUppercaseWords.get(this.fBuffer);
            if (iToken != null) {
                return iToken;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean bl) {
            this.fCaseSensitive = bl;
        }
    }
}

