/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.wst.jsdt.internal.ui.text.TextMessages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.AbstractHierarchyViewerSorter;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.OverrideIndicatorLabelDecorator;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public class JavaOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private IJavaElement fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    private boolean fShowOnlyMainType;
    private LexicalSortingAction fLexicalSortingAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;
    private ShowOnlyMainTypeAction fShowOnlyMainTypeAction;
    private Map fTypeHierarchies = new HashMap();
    private CategoryFilterActionGroup fCategoryFilterActionGroup;
    private String fPattern;

    public JavaOutlineInformationControl(Shell shell, int n, int n2, String string) {
        super(shell, n, n2, string, true);
    }

    protected Text createFilterText(Composite composite) {
        Text text = super.createFilterText(composite);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite composite, int n) {
        Tree tree = new Tree(composite, 4 | n & 0xFFFFFFFD);
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gridData);
        OutlineTreeViewer outlineTreeViewer = new OutlineTreeViewer(tree);
        ColoredViewersManager.install((StructuredViewer)outlineTreeViewer);
        outlineTreeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        outlineTreeViewer.addFilter(new MemberFilter());
        this.fInnerLabelProvider = new OutlineLabelProvider();
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        IDecoratorManager iDecoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (iDecoratorManager.getEnabled("org.eclipse.wst.jsdt.ui.override.decorator")) {
            this.fInnerLabelProvider.addLabelDecorator(new OverrideIndicatorLabelDecorator(null));
        }
        outlineTreeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fLexicalSortingAction = new LexicalSortingAction(outlineTreeViewer);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(outlineTreeViewer);
        this.fShowOnlyMainTypeAction = new ShowOnlyMainTypeAction(outlineTreeViewer);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup((StructuredViewer)outlineTreeViewer, this.getId(), this.getInputForCategories());
        this.fOutlineContentProvider = new OutlineContentProvider(false);
        outlineTreeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        outlineTreeViewer.setComparator(this.fOutlineSorter);
        outlineTreeViewer.setAutoExpandLevel(-1);
        outlineTreeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return outlineTreeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] keySequenceArray = this.getInvokingCommandKeySequences();
        if (keySequenceArray == null || keySequenceArray.length == 0) {
            return "";
        }
        String string = keySequenceArray[0].format();
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            return Messages.format(JavaUIMessages.JavaOutlineControl_statusFieldText_hideInheritedMembers, string);
        }
        return Messages.format(JavaUIMessages.JavaOutlineControl_statusFieldText_showInheritedMembers, string);
    }

    protected String getId() {
        return "org.eclipse.wst.jsdt.internal.ui.text.QuickOutline";
    }

    public void setInput(Object object) {
        if (object == null || object instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
        this.fInput = iCompilationUnit != null ? iCompilationUnit : iJavaElement.getAncestor(6);
        this.inputChanged(this.fInput, object);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
                    KeySequence[] keySequenceArray = JavaOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (keySequenceArray == null) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < keySequenceArray.length) {
                        if (keySequenceArray[n2].equals((Object)keySequence)) {
                            keyEvent.doit = false;
                            JavaOutlineInformationControl.this.toggleShowInheritedMembers();
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void handleStatusFieldClicked() {
        this.toggleShowInheritedMembers();
    }

    protected void toggleShowInheritedMembers() {
        long l = this.fInnerLabelProvider.getTextFlags();
        this.fInnerLabelProvider.setTextFlags(l ^= JavaElementLabels.ALL_POST_QUALIFIED);
        this.fOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
    }

    protected void fillViewMenu(IMenuManager iMenuManager) {
        super.fillViewMenu(iMenuManager);
        iMenuManager.add((IAction)this.fShowOnlyMainTypeAction);
        iMenuManager.add((IContributionItem)new Separator("Sorters"));
        iMenuManager.add((IAction)this.fLexicalSortingAction);
        iMenuManager.add((IAction)this.fSortByDefiningTypeAction);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
        this.fCategoryFilterActionGroup.contributeToViewMenu(iMenuManager);
    }

    protected void setMatcherString(String string, boolean bl) {
        this.fPattern = string;
        if (string.length() == 0 || !this.fSortByDefiningTypeAction.isChecked()) {
            super.setMatcherString(string, bl);
            return;
        }
        boolean bl2 = string.toLowerCase().equals(string);
        String string2 = "*" + JavaElementLabels.CONCAT_STRING + string;
        this.fStringMatcher = new OrStringMatcher(string, string2, bl2, false);
        if (bl) {
            this.stringMatcherUpdated();
        }
    }

    private IJavaElement[] getInputForCategories() {
        if (this.fInput == null) {
            return new IJavaElement[0];
        }
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            IJavaElement iJavaElement = this.fInput;
            if (iJavaElement instanceof ITypeRoot) {
                iJavaElement = ((ITypeRoot)iJavaElement).findPrimaryType();
            }
            while (iJavaElement != null && !(iJavaElement instanceof IType)) {
                iJavaElement = iJavaElement.getParent();
            }
            if (!(iJavaElement instanceof IType)) {
                return new IJavaElement[]{this.fInput};
            }
            ITypeHierarchy iTypeHierarchy = this.getSuperTypeHierarchy((IType)iJavaElement);
            if (iTypeHierarchy == null) {
                return new IJavaElement[]{this.fInput};
            }
            IType[] iTypeArray = iTypeHierarchy.getAllSupertypes((IType)iJavaElement);
            IJavaElement[] iJavaElementArray = new IJavaElement[iTypeArray.length + 1];
            iJavaElementArray[0] = this.fInput;
            System.arraycopy(iTypeArray, 0, iJavaElementArray, 1, iTypeArray.length);
            return iJavaElementArray;
        }
        return new IJavaElement[]{this.fInput};
    }

    private ITypeHierarchy getSuperTypeHierarchy(IType iType) {
        ITypeHierarchy iTypeHierarchy = (ITypeHierarchy)this.fTypeHierarchies.get(iType);
        if (iTypeHierarchy == null) {
            try {
                iTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(iType, this.getProgressMonitor());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            this.fTypeHierarchies.put(iType, iTypeHierarchy);
        }
        return iTypeHierarchy;
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        return iEditorPart.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    static /* synthetic */ String access$11(JavaOutlineInformationControl javaOutlineInformationControl) {
        return javaOutlineInformationControl.fPattern;
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer treeViewer) {
            super(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_label, 2);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_tooltip);
            this.setDescription(TextMessages.JavaOutlineInformationControl_LexicalSortingAction_description);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.fOutlineViewer = treeViewer;
            boolean bl = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(bl);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.lexical_sorting_browsing_action");
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ LexicalSortingAction this$1;
                {
                    this.this$1 = lexicalSortingAction;
                }

                public void run() {
                    LexicalSortingAction.access$0(this.this$1).refresh(false);
                }
            });
            if (bl2) {
                JavaOutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, bl);
            }
        }

        static /* synthetic */ TreeViewer access$0(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.fOutlineViewer;
        }
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String string, String string2, boolean bl, boolean bl2) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(string, bl, false);
            this.fMatcher2 = new StringMatcher(string2, bl, false);
        }

        public boolean match(String string) {
            return this.fMatcher2.match(string) || this.fMatcher1.match(string);
        }
    }

    private class OutlineContentProvider
    extends StandardJavaElementContentProvider {
        private boolean fShowInheritedMembers;

        private OutlineContentProvider(boolean bl) {
            super(true);
            this.fShowInheritedMembers = bl;
        }

        public boolean isShowingInheritedMembers() {
            return this.fShowInheritedMembers;
        }

        public void toggleShowInheritedMembers() {
            Tree tree = JavaOutlineInformationControl.this.getTreeViewer().getTree();
            tree.setRedraw(false);
            this.fShowInheritedMembers = !this.fShowInheritedMembers;
            JavaOutlineInformationControl.this.getTreeViewer().refresh();
            JavaOutlineInformationControl.this.getTreeViewer().expandToLevel(2);
            Object object = JavaOutlineInformationControl.this.getSelectedElement();
            if (object != null) {
                JavaOutlineInformationControl.this.getTreeViewer().reveal(object);
            }
            tree.setRedraw(true);
        }

        public Object[] getChildren(Object object) {
            ITypeHierarchy iTypeHierarchy;
            IType iType;
            if (JavaOutlineInformationControl.this.fShowOnlyMainType) {
                if (object instanceof ITypeRoot) {
                    object = ((ITypeRoot)object).findPrimaryType();
                }
                if (object == null) {
                    return NO_CHILDREN;
                }
            }
            if (this.fShowInheritedMembers && object instanceof IType && (iType = (IType)object).getDeclaringType() == null && (iTypeHierarchy = JavaOutlineInformationControl.this.getSuperTypeHierarchy(iType)) != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                IType[] iTypeArray = iTypeHierarchy.getAllSupertypes(iType);
                arrayList.addAll(Arrays.asList(super.getChildren(iType)));
                int n = 0;
                int n2 = iTypeArray.length;
                while (n < n2) {
                    arrayList.addAll(Arrays.asList(super.getChildren(iTypeArray[n])));
                    ++n;
                }
                return arrayList.toArray();
            }
            return super.getChildren(object);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            super.inputChanged(viewer, object, object2);
            JavaOutlineInformationControl.this.fTypeHierarchies.clear();
        }

        public void dispose() {
            super.dispose();
            if (JavaOutlineInformationControl.this.fCategoryFilterActionGroup != null) {
                JavaOutlineInformationControl.this.fCategoryFilterActionGroup.dispose();
                JavaOutlineInformationControl.this.fCategoryFilterActionGroup = null;
            }
            JavaOutlineInformationControl.this.fTypeHierarchies.clear();
        }
    }

    private class OutlineLabelProvider
    extends AppearanceAwareLabelProvider {
        private boolean fShowDefiningType;

        private OutlineLabelProvider() {
            super(0x210000204029L | JavaElementLabels.ALL_CATEGORY, 1);
        }

        public String getText(Object object) {
            String string = super.getText(object);
            if (this.fShowDefiningType) {
                try {
                    IType iType = this.getDefiningType(object);
                    if (iType != null) {
                        StringBuffer stringBuffer = new StringBuffer(super.getText(iType));
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(string);
                        return stringBuffer.toString();
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return string;
        }

        public Color getForeground(Object object) {
            if (JavaOutlineInformationControl.this.fOutlineContentProvider.isShowingInheritedMembers()) {
                if (object instanceof IJavaElement) {
                    IJavaElement iJavaElement = (IJavaElement)object;
                    iJavaElement = JavaOutlineInformationControl.this.fInput.getElementType() == 6 ? iJavaElement.getAncestor(6) : iJavaElement.getAncestor(5);
                    if (JavaOutlineInformationControl.this.fInput.equals(iJavaElement)) {
                        return null;
                    }
                }
                return JFaceResources.getColorRegistry().get("org.eclipse.wst.jsdt.ui.ColoredLabels.inherited");
            }
            return null;
        }

        public void setShowDefiningType(boolean bl) {
            this.fShowDefiningType = bl;
        }

        public boolean isShowDefiningType() {
            return this.fShowDefiningType;
        }

        private IType getDefiningType(Object object) throws JavaModelException {
            int n = ((IJavaElement)object).getElementType();
            if (n != 9 && n != 8 && n != 10) {
                return null;
            }
            IType iType = ((IMember)object).getDeclaringType();
            if (n != 9) {
                return iType;
            }
            ITypeHierarchy iTypeHierarchy = JavaOutlineInformationControl.this.getSuperTypeHierarchy(iType);
            if (iTypeHierarchy == null) {
                return iType;
            }
            MethodOverrideTester methodOverrideTester = new MethodOverrideTester(iType, iTypeHierarchy);
            IMethod iMethod = (IMethod)object;
            IMethod iMethod2 = methodOverrideTester.findDeclaringMethod(iMethod, true);
            if (iMethod2 == null || iMethod.equals(iMethod2)) {
                return iType;
            }
            return iMethod2.getDeclaringType();
        }
    }

    private class OutlineSorter
    extends AbstractHierarchyViewerSorter {
        private OutlineSorter() {
        }

        protected ITypeHierarchy getHierarchy(IType iType) {
            return JavaOutlineInformationControl.this.getSuperTypeHierarchy(iType);
        }

        public boolean isSortByDefiningType() {
            return JavaOutlineInformationControl.this.fSortByDefiningTypeAction.isChecked();
        }

        public boolean isSortAlphabetically() {
            return JavaOutlineInformationControl.this.fLexicalSortingAction.isChecked();
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering = false;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
        }

        protected Object[] getFilteredChildren(Object object) {
            Object[] objectArray = this.getRawChildren(object);
            int n = objectArray.length;
            ViewerFilter[] viewerFilterArray = this.getFilters();
            if (viewerFilterArray != null) {
                int n2 = 0;
                while (n2 < viewerFilterArray.length) {
                    objectArray = viewerFilterArray[n2].filter((Viewer)this, object, objectArray);
                    ++n2;
                }
            }
            this.fIsFiltering = n != objectArray.length;
            return objectArray;
        }

        protected void internalExpandToLevel(Widget widget, int n) {
            IJavaElement iJavaElement;
            TreeItem treeItem;
            if (!this.fIsFiltering && widget instanceof TreeItem && JavaOutlineInformationControl.this.getMatcher() == null && (treeItem = (TreeItem)widget).getParentItem() != null && treeItem.getData() instanceof IJavaElement && ((iJavaElement = (IJavaElement)treeItem.getData()).getElementType() == 12 || this.isInnerType(iJavaElement))) {
                this.setExpanded((Item)treeItem, false);
                return;
            }
            super.internalExpandToLevel(widget, n);
        }

        private boolean isInnerType(IJavaElement iJavaElement) {
            block3: {
                if (iJavaElement != null && iJavaElement.getElementType() == 7) {
                    IType iType = (IType)iJavaElement;
                    try {
                        return iType.isMember();
                    }
                    catch (JavaModelException javaModelException) {
                        IJavaElement iJavaElement2 = iType.getParent();
                        if (iJavaElement2 == null) break block3;
                        int n = iJavaElement2.getElementType();
                        return n != 5 && n != 6;
                    }
                }
            }
            return false;
        }
    }

    private class ShowOnlyMainTypeAction
    extends Action {
        private static final String STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED = "GoIntoTopLevelTypeAction.isChecked";
        private TreeViewer fOutlineViewer;

        private ShowOnlyMainTypeAction(TreeViewer treeViewer) {
            super(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_label, 2);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_tooltip);
            this.setDescription(TextMessages.JavaOutlineInformationControl_GoIntoTopLevelType_description);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.gif");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.go_into_top_level_type_action");
            this.fOutlineViewer = treeViewer;
            boolean bl = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED);
            this.setTopLevelTypeOnly(bl);
        }

        public void run() {
            this.setTopLevelTypeOnly(!JavaOutlineInformationControl.this.fShowOnlyMainType);
        }

        private void setTopLevelTypeOnly(boolean bl) {
            Object object;
            JavaOutlineInformationControl.this.fShowOnlyMainType = bl;
            this.setChecked(bl);
            Tree tree = this.fOutlineViewer.getTree();
            tree.setRedraw(false);
            this.fOutlineViewer.refresh(false);
            if (!JavaOutlineInformationControl.this.fShowOnlyMainType) {
                this.fOutlineViewer.expandToLevel(2);
            }
            if ((object = JavaOutlineInformationControl.this.getSelectedElement()) != null) {
                this.fOutlineViewer.reveal(object);
            }
            tree.setRedraw(true);
            JavaOutlineInformationControl.this.getDialogSettings().put(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED, bl);
        }
    }

    private class SortByDefiningTypeAction
    extends Action {
        private static final String STORE_SORT_BY_DEFINING_TYPE_CHECKED = "SortByDefiningType.isChecked";
        private TreeViewer fOutlineViewer;

        private SortByDefiningTypeAction(TreeViewer treeViewer) {
            super(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_label);
            this.setDescription(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_description);
            this.setToolTipText(TextMessages.JavaOutlineInformationControl_SortByDefiningTypeAction_tooltip);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "definingtype_sort_co.gif");
            this.fOutlineViewer = treeViewer;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_by_defining_type_action");
            boolean bl = JavaOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_SORT_BY_DEFINING_TYPE_CHECKED);
            this.setChecked(bl);
            JavaOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(bl);
        }

        public void run() {
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ SortByDefiningTypeAction this$1;
                {
                    this.this$1 = sortByDefiningTypeAction;
                }

                public void run() {
                    JavaOutlineInformationControl.access$10(SortByDefiningTypeAction.access$2(this.this$1)).setShowDefiningType(this.this$1.isChecked());
                    SortByDefiningTypeAction.access$2(this.this$1).getDialogSettings().put("SortByDefiningType.isChecked", this.this$1.isChecked());
                    SortByDefiningTypeAction.access$2(this.this$1).setMatcherString(JavaOutlineInformationControl.access$11(SortByDefiningTypeAction.access$2(this.this$1)), false);
                    SortByDefiningTypeAction.access$0(this.this$1).refresh(true);
                    Object object = SortByDefiningTypeAction.access$2(this.this$1).getSelectedElement();
                    if (object != null) {
                        SortByDefiningTypeAction.access$0(this.this$1).reveal(object);
                    }
                }
            });
        }

        static /* synthetic */ TreeViewer access$0(SortByDefiningTypeAction sortByDefiningTypeAction) {
            return sortByDefiningTypeAction.fOutlineViewer;
        }

        static /* synthetic */ JavaOutlineInformationControl access$2(SortByDefiningTypeAction sortByDefiningTypeAction) {
            return sortByDefiningTypeAction.JavaOutlineInformationControl.this;
        }
    }
}

